/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.generation.defaults;

import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.loot.ModLootConditions;
import com.minecolonies.core.blocks.BlockMinecoloniesRack;
import com.minecolonies.core.blocks.MinecoloniesCropBlock;
import com.minecolonies.core.generation.SimpleLootTableProvider;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.CopyNameFunction;
import net.minecraft.world.level.storage.loot.functions.CopyNbtFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class DefaultBlockLootTableProvider
extends SimpleLootTableProvider {
    public DefaultBlockLootTableProvider(PackOutput output) {
        super(output);
    }

    public String m_6055_() {
        return "Mcol Loot";
    }

    @Override
    protected void registerTables(@NotNull SimpleLootTableProvider.LootTableRegistrar registrar) {
        this.saveBlocks(Arrays.asList(ModBlocks.getHuts()), registrar);
        this.saveBlock(ModBlocks.blockHutWareHouse, registrar);
        this.saveBlock(ModBlocks.blockStash, registrar);
        this.saveBlock((Block)ModBlocks.blockConstructionTape, registrar);
        this.saveBlock(ModBlocks.blockRack, registrar);
        this.saveBlock(ModBlocks.blockWayPoint, registrar);
        this.saveBlock((Block)ModBlocks.blockBarrel, registrar);
        this.saveBlock(ModBlocks.blockScarecrow, registrar);
        this.saveBlock((Block)ModBlocks.blockPlantationField, registrar);
        this.saveBlock((Block)ModBlocks.blockColonyBanner, registrar);
        this.saveBlock((Block)ModBlocks.blockColonyWallBanner, registrar);
        this.saveBlock((Block)ModBlocks.blockIronGate, registrar);
        this.saveBlock((Block)ModBlocks.blockWoodenGate, registrar);
        this.saveBlock(ModBlocks.blockCompostedDirt, registrar, lootPool -> lootPool.m_79076_((LootPoolEntryContainer.Builder)AlternativesEntry.m_79395_((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[0]).m_7170_(LootItem.m_79579_(ModBlocks.blockCompostedDirt).m_79080_(ModLootConditions.HAS_SILK_TOUCH)).m_7170_(LootItem.m_79579_((ItemLike)Blocks.f_50493_).m_79080_(ExplosionCondition.m_81661_()))));
        this.saveBlock(ModBlocks.farmland, registrar, lootPool -> lootPool.m_79076_((LootPoolEntryContainer.Builder)AlternativesEntry.m_79395_((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[0]).m_7170_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Blocks.f_50493_))));
        this.saveBlock(ModBlocks.floodedFarmland, registrar, lootPool -> lootPool.m_79076_((LootPoolEntryContainer.Builder)AlternativesEntry.m_79395_((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[0]).m_7170_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Blocks.f_50493_))));
        for (MinecoloniesCropBlock block : ModBlocks.getCrops()) {
            LootItemBlockStatePropertyCondition.Builder cropCondition = LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)CropBlock.f_52244_, 6));
            this.saveBlock(block, registrar, lootPool -> lootPool.m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)block.m_5456_()).m_79080_((LootItemCondition.Builder)cropCondition)).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79917_((Enchantment)Enchantments.f_44987_, (float)0.5714286f, (int)3)).m_7170_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block.m_5456_()))));
        }
        this.saveBannerBlock(Blocks.f_50429_, registrar);
        this.saveBannerBlock(Blocks.f_50425_, registrar);
        this.saveBannerBlock(Blocks.f_50426_, registrar);
        this.saveBannerBlock(Blocks.f_50414_, registrar);
        this.saveBannerBlock(Blocks.f_50423_, registrar);
        this.saveBannerBlock(Blocks.f_50421_, registrar);
        this.saveBannerBlock(Blocks.f_50427_, registrar);
        this.saveBannerBlock(Blocks.f_50417_, registrar);
        this.saveBannerBlock(Blocks.f_50422_, registrar);
        this.saveBannerBlock(Blocks.f_50419_, registrar);
        this.saveBannerBlock(Blocks.f_50416_, registrar);
        this.saveBannerBlock(Blocks.f_50415_, registrar);
        this.saveBannerBlock(Blocks.f_50420_, registrar);
        this.saveBannerBlock(Blocks.f_50424_, registrar);
        this.saveBannerBlock(Blocks.f_50428_, registrar);
        this.saveBannerBlock(Blocks.f_50418_, registrar);
        this.saveBannerBlock(Blocks.f_50393_, registrar);
        this.saveBannerBlock(Blocks.f_50389_, registrar);
        this.saveBannerBlock(Blocks.f_50390_, registrar);
        this.saveBannerBlock(Blocks.f_50430_, registrar);
        this.saveBannerBlock(Blocks.f_50439_, registrar);
        this.saveBannerBlock(Blocks.f_50437_, registrar);
        this.saveBannerBlock(Blocks.f_50391_, registrar);
        this.saveBannerBlock(Blocks.f_50433_, registrar);
        this.saveBannerBlock(Blocks.f_50438_, registrar);
        this.saveBannerBlock(Blocks.f_50435_, registrar);
        this.saveBannerBlock(Blocks.f_50432_, registrar);
        this.saveBannerBlock(Blocks.f_50431_, registrar);
        this.saveBannerBlock(Blocks.f_50436_, registrar);
        this.saveBannerBlock(Blocks.f_50388_, registrar);
        this.saveBannerBlock(Blocks.f_50392_, registrar);
        this.saveBannerBlock(Blocks.f_50434_, registrar);
    }

    private <T extends Block> void saveBlocks(@NotNull List<T> blocks, @NotNull SimpleLootTableProvider.LootTableRegistrar registrar) {
        for (Block block : blocks) {
            this.saveBlock(block, registrar);
        }
    }

    private void saveBlock(@NotNull Block block, @NotNull SimpleLootTableProvider.LootTableRegistrar registrar) {
        LootPoolSingletonContainer.Builder item = LootItem.m_79579_((ItemLike)block);
        if (block instanceof AbstractBlockHut || block instanceof BlockMinecoloniesRack) {
            item.m_79078_((LootItemFunction.Builder)CopyNameFunction.m_80187_((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY));
        }
        this.saveBlock(block, registrar, lootPool -> lootPool.m_79076_((LootPoolEntryContainer.Builder)item).m_79080_(ExplosionCondition.m_81661_()));
    }

    private void saveBlock(@NotNull Block block, @NotNull SimpleLootTableProvider.LootTableRegistrar registrar, Consumer<LootPool.Builder> lootPoolConfigurer) {
        ResourceLocation location = ForgeRegistries.BLOCKS.getKey((Object)block);
        if (location != null) {
            ResourceLocation id = new ResourceLocation(location.m_135827_(), "blocks/" + location.m_135815_());
            LootPool.Builder lootPoolbuilder = LootPool.m_79043_();
            lootPoolConfigurer.accept(lootPoolbuilder);
            registrar.register(id, LootContextParamSets.f_81421_, LootTable.m_79147_().m_79161_(lootPoolbuilder));
        }
    }

    private void saveBannerBlock(@NotNull Block block, @NotNull SimpleLootTableProvider.LootTableRegistrar registrar) {
        ResourceLocation location = ForgeRegistries.BLOCKS.getKey((Object)block);
        if (location != null) {
            registrar.register(new ResourceLocation(location.m_135827_(), "blocks/" + location.m_135815_()), LootContextParamSets.f_81421_, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block)).m_79078_((LootItemFunction.Builder)CopyNameFunction.m_80187_((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)).m_79078_((LootItemFunction.Builder)CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_).m_80279_("Patterns", "BlockEntityTag.Patterns").m_80279_("id", "BlockEntityTag.id")).m_79080_(ExplosionCondition.m_81661_())));
        }
    }
}

