/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.event;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.research.IGlobalResearchTree;
import com.minecolonies.core.MineColonies;
import com.minecolonies.core.Network;
import com.minecolonies.core.colony.crafting.CustomRecipeManager;
import com.minecolonies.core.compatibility.CraftingTagAuditor;
import com.minecolonies.core.datalistener.DiseasesListener;
import com.minecolonies.core.datalistener.QuestJsonListener;
import com.minecolonies.core.network.messages.client.UpdateClientWithCompatibilityMessage;
import com.minecolonies.core.util.FurnaceRecipes;
import com.mojang.authlib.GameProfile;
import net.minecraft.client.Minecraft;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

public class DataPackSyncEventHandler {

    public static class ClientEvents {
        @SubscribeEvent
        public static void onRecipesLoaded(@NotNull RecipesUpdatedEvent event) {
            GameProfile owner;
            IntegratedServer server = Minecraft.m_91087_().m_91092_();
            GameProfile gameProfile = owner = server == null ? null : server.m_236731_();
            if (owner != null && owner == Minecraft.m_91087_().f_91074_.m_36316_()) {
                return;
            }
            FurnaceRecipes.getInstance().loadRecipes(event.getRecipeManager(), (Level)Minecraft.m_91087_().f_91073_);
        }
    }

    public static class ServerEvents {
        private static void discoverCompatLists(@NotNull MinecraftServer server) {
            FurnaceRecipes.getInstance().loadRecipes(server.m_129894_(), (Level)server.m_129783_());
            IMinecoloniesAPI.getInstance().getColonyManager().getCompatibilityManager().discover(server.m_129894_(), (Level)server.m_129783_());
            CustomRecipeManager.getInstance().resolveTemplates();
            CustomRecipeManager.getInstance().buildLootData(server.m_278653_(), (Level)server.m_129783_());
        }

        private static void sendPackets(@NotNull ServerPlayer player, @NotNull UpdateClientWithCompatibilityMessage compatMsg) {
            Network.getNetwork().sendToPlayer(compatMsg, player);
            CustomRecipeManager.getInstance().sendCustomRecipeManagerPackets(player);
            IGlobalResearchTree.getInstance().sendGlobalResearchTreePackets(player);
            QuestJsonListener.sendGlobalQuestPackets(player);
            DiseasesListener.sendGlobalDiseasesPackets(player);
        }

        @SubscribeEvent
        public static void onDataPackSync(OnDatapackSyncEvent event) {
            CustomRecipeManager recipeManager = CustomRecipeManager.getInstance();
            MinecraftServer server = event.getPlayerList().m_7873_();
            GameProfile owner = server.m_236731_();
            if (event.getPlayer() == null) {
                ServerEvents.discoverCompatLists(server);
                UpdateClientWithCompatibilityMessage compatMsg = new UpdateClientWithCompatibilityMessage(true);
                for (ServerPlayer player : event.getPlayerList().m_11314_()) {
                    if (player.m_36316_() == owner) continue;
                    ServerEvents.sendPackets(player, compatMsg);
                }
            } else if (event.getPlayer().m_36316_() != owner) {
                ServerEvents.sendPackets(event.getPlayer(), new UpdateClientWithCompatibilityMessage(true));
            }
            if (((Boolean)MineColonies.getConfig().getServer().auditCraftingTags.get()).booleanValue() && (event.getPlayer() == null || event.getPlayerList().m_11314_().isEmpty())) {
                CraftingTagAuditor.doRecipeAudit(server, recipeManager);
            }
        }

        @SubscribeEvent
        public static void onServerStarted(@NotNull ServerStartedEvent event) {
            ServerEvents.discoverCompatLists(event.getServer());
        }
    }
}

