/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.workers.production.agriculture;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.advancements.AdvancementTriggers;
import com.minecolonies.api.colony.buildingextensions.IBuildingExtension;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.requestsystem.requestable.StackList;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.core.Network;
import com.minecolonies.core.blocks.BlockScarecrow;
import com.minecolonies.core.blocks.MinecoloniesCropBlock;
import com.minecolonies.core.blocks.MinecoloniesFarmland;
import com.minecolonies.core.colony.buildingextensions.FarmField;
import com.minecolonies.core.colony.buildings.modules.BuildingExtensionsModule;
import com.minecolonies.core.colony.buildings.modules.BuildingModules;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingFarmer;
import com.minecolonies.core.colony.interactionhandling.StandardInteraction;
import com.minecolonies.core.colony.jobs.JobFarmer;
import com.minecolonies.core.entity.ai.workers.crafting.AbstractEntityAICrafting;
import com.minecolonies.core.items.ItemCrop;
import com.minecolonies.core.network.messages.client.CompostParticleMessage;
import com.minecolonies.core.util.AdvancementUtils;
import com.minecolonies.core.util.citizenutils.CitizenItemUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.MelonBlock;
import net.minecraft.world.level.block.PumpkinBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.WebBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityAIWorkFarmer
extends AbstractEntityAICrafting<JobFarmer, BuildingFarmer> {
    private static final int MAX_BLOCKS_MINED = 64;
    private static final int DEFAULT_DELAY = 40;
    private static final int SMALLEST_DELAY = 1;
    private static final double DELAY_DIVIDER = 1.0;
    private static final double XP_PER_HARVEST = 0.5;
    private static final int MAX_DEPTH = 5;
    private static final VisibleCitizenStatus FARMING_ICON = new VisibleCitizenStatus(new ResourceLocation("minecolonies", "textures/icons/work/farmer.png"), "com.minecolonies.gui.visiblestatus.farmer");
    private boolean shouldDumpInventory = false;
    @Nullable
    private BlockPos workingOffset;
    @Nullable
    private BlockPos prevPos;
    private int cell = -1;

    public EntityAIWorkFarmer(@NotNull JobFarmer job) {
        super(job);
        super.registerTargets(new AITarget<Object>(AIWorkerState.PREPARING, this::prepareForFarming, 20), new AITarget<Object>(AIWorkerState.FARMER_HOE, this::workAtField, 5), new AITarget<Object>(AIWorkerState.FARMER_PLANT, this::workAtField, 5), new AITarget<Object>(AIWorkerState.FARMER_HARVEST, this::workAtField, 5));
        this.worker.m_21553_(true);
    }

    @Override
    public Class<BuildingFarmer> getExpectedBuildingClass() {
        return BuildingFarmer.class;
    }

    @Override
    protected boolean wantInventoryDumped() {
        if (this.shouldDumpInventory || ((JobFarmer)this.job).getActionsDone() >= this.getActionRewardForCraftingSuccess()) {
            this.shouldDumpInventory = false;
            return true;
        }
        return super.wantInventoryDumped();
    }

    @Override
    protected int getActionRewardForCraftingSuccess() {
        return 64;
    }

    @Override
    protected void updateRenderMetaData() {
        this.worker.setRenderMetadata(this.getState() == AIWorkerState.FARMER_PLANT || this.getState() == AIWorkerState.FARMER_HARVEST ? "working" : "");
    }

    @Override
    protected IAIState decide() {
        IAIState state = super.decide();
        if (state == AIWorkerState.IDLE) {
            return AIWorkerState.PREPARING;
        }
        return state;
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 64;
    }

    @NotNull
    private IAIState prepareForFarming() {
        int amountOfCompostInInv;
        int amountOfCompostInBuilding;
        this.worker.getCitizenData().setIdleAtJob(true);
        if (this.building == null || ((BuildingFarmer)this.building).getBuildingLevel() < 1) {
            return AIWorkerState.PREPARING;
        }
        BuildingExtensionsModule module = (BuildingExtensionsModule)((BuildingFarmer)this.building).getFirstModuleOccurance(BuildingExtensionsModule.class);
        module.claimExtensions();
        if (module.getOwnedExtensions().size() == ((BuildingFarmer)this.building).getMaxBuildingLevel()) {
            AdvancementUtils.TriggerAdvancementPlayersForColony(((BuildingFarmer)this.building).getColony(), AdvancementTriggers.MAX_FIELDS::trigger);
        }
        if ((amountOfCompostInBuilding = InventoryUtils.hasBuildingEnoughElseCount((IBuilding)this.building, this::isCompost, 1)) + (amountOfCompostInInv = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), this::isCompost)) <= 0) {
            if (((BuildingFarmer)this.building).requestFertilizer() && !((BuildingFarmer)this.building).hasWorkerOpenRequestsOfType(this.worker.getCitizenData().getId(), TypeToken.of(StackList.class))) {
                ArrayList<ItemStack> compostAbleItems = new ArrayList<ItemStack>();
                compostAbleItems.add(new ItemStack((ItemLike)ModItems.compost, 1));
                compostAbleItems.add(new ItemStack((ItemLike)Items.f_42499_, 1));
                this.worker.getCitizenData().createRequestAsync(new StackList(compostAbleItems, "com.minecolonies.coremod.request.fertilizer", 64, 1));
            }
        } else if (amountOfCompostInInv <= 0 && amountOfCompostInBuilding > 0) {
            this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(this::isCompost, 64);
            return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
        }
        if (module.hasNoExtensions()) {
            if (this.worker.getCitizenData() != null) {
                this.worker.getCitizenData().triggerInteraction(new StandardInteraction((Component)Component.m_237115_((String)"entity.farmer.nofreefields"), ChatPriority.BLOCKING));
            }
            return AIWorkerState.IDLE;
        }
        module.resetCurrentExtension();
        IBuildingExtension fieldToWork = module.getExtensionToWorkOn();
        if (fieldToWork instanceof FarmField) {
            FarmField farmField = (FarmField)fieldToWork;
            this.worker.getCitizenData().setIdleAtJob(false);
            this.worker.getCitizenData().setVisibleStatus(FARMING_ICON);
            if (farmField.getFieldStage() == FarmField.Stage.PLANTED && this.checkIfShouldExecute(farmField, pos -> this.findHarvestableSurface((BlockPos)pos) != null)) {
                return AIWorkerState.FARMER_HARVEST;
            }
            if (farmField.getFieldStage() == FarmField.Stage.HOED) {
                return this.canGoPlanting(farmField);
            }
            if (farmField.getFieldStage() == FarmField.Stage.EMPTY && this.checkIfShouldExecute(farmField, pos -> this.findHoeableSurface((BlockPos)pos, farmField) != null)) {
                return AIWorkerState.FARMER_HOE;
            }
            farmField.nextState();
        }
        return AIWorkerState.PREPARING;
    }

    private boolean isCompost(ItemStack itemStack) {
        if (itemStack.m_41720_() == ModItems.compost) {
            return true;
        }
        return itemStack.m_41720_() == Items.f_42499_;
    }

    private boolean checkIfShouldExecute(@NotNull FarmField farmField, @NotNull Predicate<BlockPos> predicate) {
        BlockPos position;
        do {
            this.workingOffset = this.nextValidCell(farmField);
            if (this.workingOffset != null) continue;
            return false;
        } while (!predicate.test(position = farmField.getPosition().m_7495_().m_122020_(this.workingOffset.m_123343_()).m_122030_(this.workingOffset.m_123341_())));
        return true;
    }

    private IAIState canGoPlanting(@NotNull FarmField farmField) {
        if (farmField.getSeed() == null) {
            return AIWorkerState.PREPARING;
        }
        ItemStack seeds = farmField.getSeed();
        int slot = this.worker.getCitizenInventoryHandler().findFirstSlotInInventoryWith(seeds.m_41720_());
        if (slot != -1) {
            return AIWorkerState.FARMER_PLANT;
        }
        if (!this.walkToBuilding()) {
            return AIWorkerState.PREPARING;
        }
        seeds.m_41764_(seeds.m_41741_());
        this.checkIfRequestForItemExistOrCreateAsync(seeds, seeds.m_41741_(), 1);
        farmField.nextState();
        return AIWorkerState.PREPARING;
    }

    private BlockPos findHoeableSurface(@NotNull BlockPos position, @NotNull FarmField farmField) {
        if ((position = this.getSurfacePos(position)) == null) {
            return null;
        }
        BlockState blockState = this.world.m_8055_(position);
        if (farmField.isNoPartOfField(this.world, position) || this.world.m_8055_(position.m_7494_()).m_60734_() instanceof CropBlock || this.world.m_8055_(position.m_7494_()).m_60734_() instanceof BlockScarecrow || !blockState.m_204336_(BlockTags.f_144274_) && !(blockState.m_60734_() instanceof MinecoloniesFarmland) && !(blockState.m_60734_() instanceof FarmBlock) || this.isRightFarmLandForCrop(farmField, blockState) || this.world.m_8055_(position.m_7494_()).m_60734_() instanceof MinecoloniesCropBlock) {
            return null;
        }
        BlockState aboveState = this.world.m_8055_(position.m_7494_());
        if (aboveState.m_247087_() && !(aboveState.m_60734_() instanceof MinecoloniesCropBlock)) {
            this.world.m_46961_(position.m_7494_(), true);
        }
        if (!this.isRightFarmLandForCrop(farmField, blockState)) {
            return position;
        }
        BlockHitResult blockHitResult = new BlockHitResult(Vec3.f_82478_, Direction.UP, position, false);
        UseOnContext useOnContext = new UseOnContext(this.world, null, InteractionHand.MAIN_HAND, this.getInventory().getStackInSlot(InventoryUtils.getFirstSlotOfItemHandlerContainingEquipment((IItemHandler)this.getInventory(), (EquipmentTypeEntry)ModEquipmentTypes.hoe.get(), 0, ((BuildingFarmer)this.building).getMaxEquipmentLevel())), blockHitResult);
        BlockState toolModifiedState = blockState.getToolModifiedState(useOnContext, ToolActions.HOE_TILL, true);
        if (toolModifiedState == null || !toolModifiedState.m_60713_(Blocks.f_50093_)) {
            return null;
        }
        return position;
    }

    private BlockPos getSurfacePos(BlockPos position) {
        return this.getSurfacePos(position, 0);
    }

    private BlockPos getSurfacePos(BlockPos position, Integer depth) {
        if (Math.abs(depth) > 5 || !WorldUtil.isBlockLoaded((LevelAccessor)this.world, position)) {
            return null;
        }
        BlockState curBlockState = this.world.m_8055_(position);
        @Nullable Block curBlock = curBlockState.m_60734_();
        if (curBlockState.m_280296_() && !(curBlock instanceof PumpkinBlock) && !(curBlock instanceof MelonBlock) && !(curBlock instanceof WebBlock) || curBlockState.m_278721_()) {
            if (depth < 0) {
                return position;
            }
            return this.getSurfacePos(position.m_7494_(), depth + 1);
        }
        if (depth > 0) {
            return position.m_7495_();
        }
        return this.getSurfacePos(position.m_7495_(), depth - 1);
    }

    protected BlockPos nextValidCell(FarmField farmField) {
        int x;
        int z;
        if (this.workingOffset == null) {
            this.cell = -1;
        }
        do {
            if (++this.cell == this.getLargestCell(farmField)) {
                return null;
            }
            int ring = (int)Math.floor((Math.sqrt((double)this.cell + 1.0) + 1.0) / 2.0);
            int ringCell = this.cell - (int)(4.0 * Math.pow((double)ring - 1.0, 2.0) + (double)(4 * (ring - 1)));
            Direction facing = Direction.m_122407_((int)Math.floorDiv(ringCell, 2 * ring));
            if (facing.m_122434_() == Direction.Axis.Z) {
                x = (facing == Direction.NORTH ? -1 : 1) * (ring - ringCell % (2 * ring));
                z = (facing == Direction.NORTH ? -1 : 1) * ring;
                continue;
            }
            x = (facing == Direction.WEST ? -1 : 1) * ring;
            z = (facing == Direction.EAST ? -1 : 1) * (ring - ringCell % (2 * ring));
        } while (-z > farmField.getRadius(Direction.NORTH) || x > farmField.getRadius(Direction.EAST) || z > farmField.getRadius(Direction.SOUTH) || -x > farmField.getRadius(Direction.WEST));
        return new BlockPos(x, 0, z);
    }

    protected int getLargestCell(FarmField farmField) {
        return (int)Math.pow((double)farmField.getMaxRadius() * 2.0 + 1.0, 2.0);
    }

    private IAIState workAtField() {
        BuildingExtensionsModule module = (BuildingExtensionsModule)((BuildingFarmer)this.building).getFirstModuleOccurance(BuildingExtensionsModule.class);
        if (this.checkForToolOrWeapon((EquipmentTypeEntry)ModEquipmentTypes.hoe.get()) || module.getCurrentExtension() == null) {
            return AIWorkerState.PREPARING;
        }
        this.worker.getCitizenData().setVisibleStatus(FARMING_ICON);
        IBuildingExtension field = module.getCurrentExtension();
        if (field instanceof FarmField) {
            FarmField farmField = (FarmField)field;
            if (this.workingOffset != null) {
                BlockPos position = farmField.getPosition().m_7495_().m_122020_(this.workingOffset.m_123343_()).m_122030_(this.workingOffset.m_123341_());
                if (!this.walkToSafePos(position.m_7494_())) {
                    return this.getState();
                }
                switch ((AIWorkerState)this.getState()) {
                    case FARMER_HOE: {
                        if (this.hoeIfAble(position, farmField)) break;
                        return this.getState();
                    }
                    case FARMER_PLANT: {
                        if (this.tryToPlant(farmField, position)) break;
                        return AIWorkerState.PREPARING;
                    }
                    case FARMER_HARVEST: {
                        if (this.harvestIfAble(position)) break;
                        return this.getState();
                    }
                    default: {
                        return AIWorkerState.PREPARING;
                    }
                }
                this.prevPos = position;
                this.setDelay(this.getLevelDelay());
            }
            this.workingOffset = this.nextValidCell(farmField);
            if (this.workingOffset == null) {
                this.shouldDumpInventory = true;
                farmField.nextState();
                this.prevPos = null;
                return AIWorkerState.IDLE;
            }
        } else {
            return AIWorkerState.IDLE;
        }
        return this.getState();
    }

    private boolean hoeIfAble(BlockPos position, FarmField farmField) {
        if ((position = this.findHoeableSurface(position, farmField)) != null && !this.checkForToolOrWeapon((EquipmentTypeEntry)ModEquipmentTypes.hoe.get())) {
            if (this.mineBlock(position.m_7494_())) {
                this.equipHoe();
                this.worker.m_6674_(this.worker.m_7655_());
                this.createCorrectFarmlandForSeed(farmField.getSeed(), position);
                CitizenItemUtils.damageItemInHand(this.worker, InteractionHand.MAIN_HAND, 1);
                this.worker.decreaseSaturationForContinuousAction();
                this.worker.getCitizenColonyHandler().getColonyOrRegister().getStatisticsManager().increment("land_tilled", this.worker.getCitizenColonyHandler().getColonyOrRegister().getDay());
                return true;
            }
            return false;
        }
        return true;
    }

    private void createCorrectFarmlandForSeed(ItemStack seed, BlockPos pos) {
        Item item = seed.m_41720_();
        if (item instanceof ItemCrop) {
            ItemCrop itemCrop = (ItemCrop)item;
            this.world.m_46597_(pos, ((MinecoloniesCropBlock)itemCrop.m_40614_()).getPreferredFarmland().m_49966_());
        } else {
            this.world.m_46597_(pos, Blocks.f_50093_.m_49966_());
        }
    }

    private boolean isRightFarmLandForCrop(FarmField farmField, BlockState blockState) {
        Item item = farmField.getSeed().m_41720_();
        if (item instanceof ItemCrop) {
            ItemCrop itemCrop = (ItemCrop)item;
            return blockState.m_60734_() == ((MinecoloniesCropBlock)itemCrop.m_40614_()).getPreferredFarmland();
        }
        return blockState.m_60734_() instanceof FarmBlock;
    }

    private boolean harvestIfAble(BlockPos position) {
        if ((position = this.findHarvestableSurface(position)) != null) {
            if (this.mineBlock(position.m_7494_())) {
                this.worker.getCitizenColonyHandler().getColonyOrRegister().getStatisticsManager().increment("crops_harvested", this.worker.getCitizenColonyHandler().getColonyOrRegister().getDay());
                this.worker.getCitizenExperienceHandler().addExperience(0.5);
            } else {
                return false;
            }
        }
        return true;
    }

    @Override
    public void onBlockDropReception(List<ItemStack> blockDrops) {
        super.onBlockDropReception(blockDrops);
        for (ItemStack stack : blockDrops) {
            ((BuildingFarmer)this.building).getModule(BuildingModules.STATS_MODULE).incrementBy("item_obtained;" + stack.m_41720_().m_5524_(), stack.m_41613_());
        }
    }

    protected int getLevelDelay() {
        return (int)Math.max(1.0, 40.0 - (double)this.getPrimarySkillLevel() / 2.0 * 1.0);
    }

    private boolean tryToPlant(FarmField farmField, BlockPos position) {
        return (position = this.findPlantableSurface(position, farmField)) == null || this.plantCrop(farmField.getSeed(), position);
    }

    private void equipHoe() {
        CitizenItemUtils.setHeldItem(this.worker, InteractionHand.MAIN_HAND, this.getHoeSlot());
    }

    private BlockPos findPlantableSurface(@NotNull BlockPos position, @NotNull FarmField farmField) {
        if ((position = this.getSurfacePos(position)) == null || farmField.isNoPartOfField(this.world, position) || this.world.m_8055_(position.m_7494_()).m_60734_() instanceof CropBlock || this.world.m_8055_(position.m_7494_()).m_60734_() instanceof StemBlock || this.world.m_8055_(position).m_60734_() instanceof BlockScarecrow || !this.isRightFarmLandForCrop(farmField, this.world.m_8055_(position)) || this.world.m_8055_(position.m_7494_()).m_60734_() instanceof MinecoloniesCropBlock) {
            return null;
        }
        return position;
    }

    private boolean plantCrop(ItemStack item, @NotNull BlockPos position) {
        BlockItem blockItem;
        if (item == null || item.m_41619_()) {
            return false;
        }
        int slot = this.worker.getCitizenInventoryHandler().findFirstSlotInInventoryWith(item.m_41720_());
        if (slot == -1) {
            return false;
        }
        Item item2 = item.m_41720_();
        if (item2 instanceof BlockItem && ((blockItem = (BlockItem)item2).m_40614_() instanceof CropBlock || blockItem.m_40614_() instanceof StemBlock || blockItem.m_40614_() instanceof MinecoloniesCropBlock)) {
            @NotNull Item seed = item.m_41720_();
            if (!(seed != Items.f_42578_ && seed != Items.f_42577_ || this.prevPos == null || this.world.m_46859_(this.prevPos.m_7494_()))) {
                return true;
            }
            this.world.m_46597_(position.m_7494_(), ((BlockItem)item.m_41720_()).m_40614_().m_49966_());
            this.worker.decreaseSaturationForContinuousAction();
            this.getInventory().extractItem(slot, 1, false);
        }
        return true;
    }

    private BlockPos findHarvestableSurface(@NotNull BlockPos position) {
        if ((position = this.getSurfacePos(position)) == null) {
            return null;
        }
        BlockState state = this.world.m_8055_(position.m_7494_());
        Block block = state.m_60734_();
        if (block == Blocks.f_50133_ || block == Blocks.f_50186_) {
            return position;
        }
        if (block instanceof CropBlock) {
            @NotNull CropBlock crop = (CropBlock)block;
            if (crop.m_52307_(state)) {
                return position;
            }
            int amountOfCompostInInv = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), this::isCompost);
            if (amountOfCompostInInv == 0) {
                return null;
            }
            if (InventoryUtils.shrinkItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), this::isCompost)) {
                Network.getNetwork().sendToPosition(new CompostParticleMessage(position.m_7494_()), new PacketDistributor.TargetPoint((double)position.m_123341_(), (double)position.m_123342_(), (double)position.m_123343_(), 16.0, this.world.m_46472_()));
                crop.m_52263_(this.world, position.m_7494_(), state);
                state = this.world.m_8055_(position.m_7494_());
                block = state.m_60734_();
                if (block instanceof CropBlock) {
                    crop = (CropBlock)block;
                } else {
                    return null;
                }
            }
            return crop.m_52307_(state) ? position : null;
        }
        if (block instanceof MinecoloniesCropBlock) {
            MinecoloniesCropBlock minecoloniesCrop = (MinecoloniesCropBlock)block;
            if (minecoloniesCrop.isMaxAge(state)) {
                return position;
            }
            int amountOfCompostInInv = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), this::isCompost);
            if (amountOfCompostInInv == 0) {
                return null;
            }
            if (InventoryUtils.shrinkItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), this::isCompost)) {
                Network.getNetwork().sendToPosition(new CompostParticleMessage(position.m_7494_()), new PacketDistributor.TargetPoint((double)position.m_123341_(), (double)position.m_123342_(), (double)position.m_123343_(), 16.0, this.world.m_46472_()));
                minecoloniesCrop.attemptGrow(state, (ServerLevel)this.world, position.m_7494_());
                state = this.world.m_8055_(position.m_7494_());
                block = state.m_60734_();
                if (block instanceof MinecoloniesCropBlock) {
                    minecoloniesCrop = (MinecoloniesCropBlock)block;
                } else {
                    return null;
                }
            }
            return minecoloniesCrop.isMaxAge(state) ? position : null;
        }
        return null;
    }

    @Override
    protected List<ItemStack> increaseBlockDrops(List<ItemStack> drops) {
        double increaseCrops = this.worker.getCitizenColonyHandler().getColonyOrRegister().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.FARMING);
        if (increaseCrops == 0.0) {
            return drops;
        }
        ArrayList<ItemStack> newDrops = new ArrayList<ItemStack>();
        for (ItemStack stack : drops) {
            ItemStack drop = stack.m_41777_();
            if (this.worker.m_217043_().m_188500_() < increaseCrops) {
                drop.m_41764_(drop.m_41613_() * 2);
            }
            newDrops.add(drop);
        }
        return newDrops;
    }

    @Override
    public int getBreakSpeedLevel() {
        return this.getSecondarySkillLevel();
    }

    private int getHoeSlot() {
        return InventoryUtils.getFirstSlotOfItemHandlerContainingEquipment((IItemHandler)this.getInventory(), (EquipmentTypeEntry)ModEquipmentTypes.hoe.get(), 0, ((BuildingFarmer)this.building).getMaxEquipmentLevel());
    }

    @Nullable
    public AbstractEntityCitizen getCitizen() {
        return this.worker;
    }
}

