/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.datalistener;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class RecruitmentItemsListener
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final String KEY_ITEM = "item";
    private static final String KEY_RARITY = "rarity";
    private static List<RecruitCost> RECRUIT_COSTS = new ArrayList<RecruitCost>();

    public RecruitmentItemsListener() {
        super(GSON, "recruitment_items");
    }

    public static RecruitCost getRandomRecruitCost(RandomSource source, int level) {
        int minimumRarity = level > 35 ? 3 : (level > 30 ? 2 : 0);
        List<RecruitCost> recruitCostStream = RECRUIT_COSTS.stream().filter(f -> f.rarity >= minimumRarity).toList();
        return recruitCostStream.get(source.m_188503_(recruitCostStream.size()));
    }

    protected void apply(@NotNull Map<ResourceLocation, JsonElement> jsonElementMap, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profiler) {
        ArrayList<RecruitCost> recruitCosts = new ArrayList<RecruitCost>();
        for (Map.Entry<ResourceLocation, JsonElement> entry : jsonElementMap.entrySet()) {
            if (!entry.getValue().isJsonObject()) {
                return;
            }
            JsonObject object = entry.getValue().getAsJsonObject();
            Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(GsonHelper.m_13906_((JsonObject)object, (String)KEY_ITEM)));
            int rarity = GsonHelper.m_13927_((JsonObject)object, (String)KEY_RARITY);
            if (item == Items.f_41852_) {
                throw new IllegalArgumentException("Recruit cost '" + String.valueOf(entry.getKey()) + "' item not allowed to be air");
            }
            recruitCosts.add(new RecruitCost(item, rarity));
        }
        RECRUIT_COSTS = Collections.unmodifiableList(recruitCosts);
    }

    public record RecruitCost(Item item, int rarity) {
        public ItemStack toItemStack(int level) {
            return new ItemStack((ItemLike)this.item, (int)Math.round((double)level * 3.0 / (double)this.rarity));
        }
    }
}

