/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.requestsystem.management.manager.wrapped;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.requestsystem.data.IDataStoreManager;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.colony.requestsystem.requester.IRequester;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolver;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolverProvider;
import com.minecolonies.api.colony.requestsystem.resolver.player.IPlayerRequestResolver;
import com.minecolonies.api.colony.requestsystem.resolver.retrying.IRetryingRequestResolver;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.core.colony.requestsystem.management.IStandardRequestManager;
import java.util.Collection;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractWrappedRequestManager
implements IRequestManager {
    @NotNull
    protected final IStandardRequestManager wrappedManager;

    public AbstractWrappedRequestManager(@NotNull IStandardRequestManager wrappedManager) {
        this.wrappedManager = wrappedManager;
    }

    @Override
    @NotNull
    public IColony getColony() {
        return this.wrappedManager.getColony();
    }

    @Override
    @NotNull
    public IFactoryController getFactoryController() {
        return this.wrappedManager.getFactoryController();
    }

    @Override
    @NotNull
    public <T extends IRequestable> IToken<?> createRequest(@NotNull IRequester requester, @NotNull T object) throws IllegalArgumentException {
        return this.wrappedManager.createRequest(requester, object);
    }

    @Override
    public void assignRequest(@NotNull IToken<?> token) throws IllegalArgumentException {
        this.wrappedManager.assignRequest(token);
    }

    @Override
    @NotNull
    public <T extends IRequestable> IToken<?> createAndAssignRequest(@NotNull IRequester requester, @NotNull T object) throws IllegalArgumentException {
        IToken<?> token = this.createRequest(requester, object);
        this.assignRequest(token);
        return token;
    }

    @Override
    public IToken<?> reassignRequest(@NotNull IToken<?> token, @NotNull Collection<IToken<?>> resolverTokenBlackList) throws IllegalArgumentException {
        return this.wrappedManager.reassignRequest(token, resolverTokenBlackList);
    }

    @Override
    @Nullable
    public IRequest<?> getRequestForToken(@NotNull IToken<?> token) throws IllegalArgumentException {
        return this.wrappedManager.getRequestHandler().getRequestOrNull(token);
    }

    @Override
    @NotNull
    public IRequestResolver<?> getResolverForToken(@NotNull IToken<?> token) throws IllegalArgumentException {
        return this.wrappedManager.getResolverForToken(token);
    }

    @Override
    @Nullable
    public IRequestResolver<?> getResolverForRequest(@NotNull IToken<?> requestToken) throws IllegalArgumentException {
        return this.wrappedManager.getResolverForRequest(requestToken);
    }

    @Override
    public void updateRequestState(@NotNull IToken<?> token, @NotNull RequestState state) throws IllegalArgumentException {
        this.wrappedManager.updateRequestState(token, state);
    }

    @Override
    public void overruleRequest(@NotNull IToken<?> token, @Nullable ItemStack stack) throws IllegalArgumentException {
        this.wrappedManager.overruleRequest(token, stack);
    }

    @Override
    public void onProviderAddedToColony(@NotNull IRequestResolverProvider provider) throws IllegalArgumentException {
        this.wrappedManager.onProviderAddedToColony(provider);
    }

    @Override
    public void onProviderRemovedFromColony(@NotNull IRequestResolverProvider provider) throws IllegalArgumentException {
        this.wrappedManager.onProviderRemovedFromColony(provider);
    }

    @Override
    public void onRequesterRemovedFromColony(@NotNull IRequester requester) throws IllegalArgumentException {
        this.wrappedManager.onRequesterRemovedFromColony(requester);
    }

    @Override
    @NotNull
    public IPlayerRequestResolver getPlayerResolver() {
        return this.wrappedManager.getPlayerResolver();
    }

    @Override
    @NotNull
    public IRetryingRequestResolver getRetryingRequestResolver() {
        return this.wrappedManager.getRetryingRequestResolver();
    }

    public CompoundTag serializeNBT() {
        return (CompoundTag)this.wrappedManager.serializeNBT();
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.wrappedManager.deserializeNBT((Tag)nbt);
    }

    @Override
    public void serialize(IFactoryController controller, FriendlyByteBuf buffer) {
        this.wrappedManager.serialize(controller, buffer);
    }

    @Override
    public void deserialize(IFactoryController controller, FriendlyByteBuf buffer) {
        this.wrappedManager.deserialize(controller, buffer);
    }

    @Override
    public void tick() {
        this.wrappedManager.tick();
    }

    @Override
    @NotNull
    public IDataStoreManager getDataStoreManager() {
        return this.wrappedManager.getDataStoreManager();
    }

    @Override
    public void reset() {
        this.wrappedManager.reset();
    }

    @Override
    public boolean isDirty() {
        return this.wrappedManager.isDirty();
    }

    @Override
    public void setDirty(boolean isDirty) {
        this.wrappedManager.setDirty(isDirty);
    }

    @Override
    public void markDirty() {
        this.wrappedManager.markDirty();
    }

    @Override
    public void onColonyUpdate(@NotNull Predicate<IRequest<?>> shouldTriggerReassign) {
        throw new UnsupportedOperationException("This method cannot be used by Wrapped Request Managers!");
    }

    @Override
    public void log(String message) {
        this.wrappedManager.log(message);
    }
}

