/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.modules;

import com.minecolonies.api.colony.buildingextensions.IBuildingExtension;
import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IPersistentModule;
import com.minecolonies.core.util.CollectorUtils;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BuildingExtensionsModule
extends AbstractBuildingModule
implements IPersistentModule,
IBuildingModule {
    private static final String TAG_ASSIGN_MANUALLY = "assign";
    private final Map<IBuildingExtension, Instant> checkedExtensions = new HashMap<IBuildingExtension, Instant>();
    @Nullable
    private IBuildingExtension currentExtension;
    private boolean shouldAssignManually = false;

    @Override
    public void deserializeNBT(CompoundTag compound) {
        this.shouldAssignManually = compound.m_128471_(TAG_ASSIGN_MANUALLY);
    }

    @Override
    public void serializeNBT(CompoundTag compound) {
        compound.m_128379_(TAG_ASSIGN_MANUALLY, this.shouldAssignManually);
    }

    @Override
    public void serializeToView(@NotNull FriendlyByteBuf buf) {
        buf.writeBoolean(this.shouldAssignManually);
        buf.writeInt(this.getMaxExtensionCount());
    }

    protected abstract int getMaxExtensionCount();

    public abstract Class<?> getExpectedExtensionType();

    @Nullable
    public IBuildingExtension getCurrentExtension() {
        return this.currentExtension;
    }

    @Nullable
    public IBuildingExtension getExtensionToWorkOn() {
        if (this.currentExtension != null) {
            return this.currentExtension;
        }
        Instant now = Instant.now();
        for (IBuildingExtension extension : this.getOwnedExtensions().stream().collect(CollectorUtils.toShuffledList())) {
            if (this.checkedExtensions.containsKey(extension) && !now.isAfter(this.checkedExtensions.get(extension))) continue;
            this.checkedExtensions.remove(extension);
            this.currentExtension = extension;
            return extension;
        }
        return null;
    }

    @NotNull
    public final List<IBuildingExtension> getOwnedExtensions() {
        return this.getExtensions().stream().filter(f -> this.building.getID().equals((Object)f.getBuildingId())).toList();
    }

    @NotNull
    public abstract List<IBuildingExtension> getExtensions();

    public void claimExtensions() {
        if (!this.shouldAssignManually) {
            for (IBuildingExtension extension : this.getFreeExtensions()) {
                this.assignExtension(extension);
            }
        }
    }

    public final List<IBuildingExtension> getFreeExtensions() {
        return this.getExtensions().stream().filter(extension -> !extension.isTaken()).toList();
    }

    public void assignExtension(IBuildingExtension extension) {
        if (this.canAssignExtension(extension)) {
            extension.setBuilding(this.building.getID());
            this.markDirty();
        }
    }

    public final boolean canAssignExtension(IBuildingExtension extension) {
        return this.getOwnedExtensions().size() < this.getMaxExtensionCount() && this.canAssignExtensionOverride(extension);
    }

    @Override
    public void markDirty() {
        super.markDirty();
        this.building.getColony().getBuildingManager().markBuildingExtensionsDirty();
    }

    protected abstract boolean canAssignExtensionOverride(IBuildingExtension var1);

    public final boolean assignManually() {
        return this.shouldAssignManually;
    }

    public final boolean hasNoExtensions() {
        return this.getOwnedExtensions().isEmpty();
    }

    public final void setAssignManually(boolean assignManually) {
        this.shouldAssignManually = assignManually;
    }

    public void freeExtension(IBuildingExtension extension) {
        extension.resetOwningBuilding();
        this.markDirty();
        if (Objects.equals(this.currentExtension, extension)) {
            this.resetCurrentExtension();
        }
    }

    public void resetCurrentExtension() {
        if (this.currentExtension != null) {
            this.checkedExtensions.put(this.currentExtension, Instant.now().plus((long)this.getExtensionCheckTimeoutSeconds(), ChronoUnit.SECONDS));
        }
        this.currentExtension = null;
    }

    protected abstract int getExtensionCheckTimeoutSeconds();
}

