/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildingextensions;

import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildingextensions.registry.BuildingExtensionRegistries;
import com.minecolonies.core.colony.buildingextensions.AbstractBuildingExtensionModule;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class FarmField
extends AbstractBuildingExtensionModule {
    private static final int MAX_RANGE = 5;
    private static final String TAG_SEED = "seed";
    private static final String TAG_RADIUS = "radius";
    private static final String TAG_MAX_RANGE = "maxRange";
    private static final String TAG_STAGE = "stage";
    private ItemStack seed = ItemStack.f_41583_;
    private int[] radii = new int[]{5, 5, 5, 5};
    private int maxRadius = 5;
    private Stage fieldStage = Stage.EMPTY;

    public FarmField(BuildingExtensionRegistries.BuildingExtensionEntry fieldType, BlockPos position) {
        super(fieldType, position);
    }

    public static FarmField create(BlockPos position) {
        return (FarmField)((BuildingExtensionRegistries.BuildingExtensionEntry)BuildingExtensionRegistries.farmField.get()).produceExtension(position);
    }

    @Override
    public boolean isValidPlacement(IColony colony) {
        BlockState blockState = colony.getWorld().m_8055_(this.getPosition());
        return blockState.m_60713_(ModBlocks.blockScarecrow);
    }

    @Override
    @NotNull
    public CompoundTag serializeNBT() {
        CompoundTag compound = super.serializeNBT();
        compound.m_128365_(TAG_SEED, (Tag)this.seed.serializeNBT());
        compound.m_128385_(TAG_RADIUS, this.radii);
        compound.m_128405_(TAG_MAX_RANGE, this.maxRadius);
        compound.m_128359_(TAG_STAGE, this.fieldStage.name());
        return compound;
    }

    @Override
    public void deserializeNBT(@NotNull CompoundTag compound) {
        super.deserializeNBT(compound);
        this.setSeed(ItemStack.m_41712_((CompoundTag)compound.m_128469_(TAG_SEED)));
        this.radii = compound.m_128465_(TAG_RADIUS);
        this.maxRadius = compound.m_128451_(TAG_MAX_RANGE);
        this.fieldStage = Stage.valueOf(compound.m_128461_(TAG_STAGE));
    }

    @Override
    public void serialize(@NotNull FriendlyByteBuf buf) {
        super.serialize(buf);
        buf.m_130055_(this.getSeed());
        buf.m_130089_(this.radii);
        buf.writeInt(this.maxRadius);
        buf.m_130068_((Enum)this.fieldStage);
    }

    @Override
    public void deserialize(@NotNull FriendlyByteBuf buf) {
        super.deserialize(buf);
        this.setSeed(buf.m_130267_());
        this.radii = buf.m_130100_();
        this.maxRadius = buf.readInt();
        this.fieldStage = (Stage)buf.m_130066_(Stage.class);
    }

    @NotNull
    public ItemStack getSeed() {
        this.seed.m_41764_(1);
        return this.seed;
    }

    public void setSeed(ItemStack seed) {
        this.seed = seed.m_41777_();
        this.seed.m_41764_(1);
    }

    public void nextState() {
        if (this.getFieldStage().ordinal() + 1 >= Stage.values().length) {
            this.setFieldStage(Stage.values()[0]);
            return;
        }
        this.setFieldStage(Stage.values()[this.getFieldStage().ordinal() + 1]);
    }

    public Stage getFieldStage() {
        return this.fieldStage;
    }

    public void setFieldStage(Stage fieldStage) {
        this.fieldStage = fieldStage;
    }

    public int getMaxRadius() {
        return this.maxRadius;
    }

    public int getRadius(Direction direction) {
        return this.radii[direction.m_122416_()];
    }

    public void setRadius(Direction direction, int radius) {
        this.radii[direction.m_122416_()] = Math.min(radius, this.maxRadius);
    }

    public boolean isNoPartOfField(@NotNull Level world, @NotNull BlockPos position) {
        return world.m_46859_(position) || FarmField.isValidDelimiter(world.m_8055_(position.m_7494_()).m_60734_());
    }

    private static boolean isValidDelimiter(Block block) {
        return block instanceof FenceBlock || block instanceof FenceGateBlock || block instanceof WallBlock;
    }

    public static enum Stage {
        EMPTY,
        HOED,
        PLANTED;

    }
}

