/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.render.worldevent.highlightmanager;

import com.ldtteam.structurize.util.WorldRenderMacros;
import com.minecolonies.core.client.render.worldevent.ColonyWorldRenderMacros;
import com.minecolonies.core.client.render.worldevent.WorldEventContext;
import com.minecolonies.core.client.render.worldevent.highlightmanager.IHighlightRenderData;
import com.mojang.blaze3d.vertex.PoseStack;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.AABB;

public class TimedBoxRenderData
implements IHighlightRenderData {
    private final List<String> text = new ArrayList<String>();
    private final BlockPos pos;
    private Duration duration;
    private int argbColor = -1;

    public TimedBoxRenderData(BlockPos pos) {
        this.pos = pos;
    }

    @Override
    public void render(WorldEventContext context) {
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        ColonyWorldRenderMacros.renderLineBox(context.poseStack, buffer, new AABB(this.pos), 0.025f, this.argbColor, true);
        if (!this.text.isEmpty()) {
            WorldRenderMacros.renderDebugText((BlockPos)this.pos, this.text, (PoseStack)context.poseStack, (boolean)true, (int)3, (MultiBufferSource)buffer);
        }
        ColonyWorldRenderMacros.endRenderLineBox(buffer);
        buffer.m_109911_();
    }

    @Override
    public Duration getDuration() {
        return this.duration;
    }

    public TimedBoxRenderData setDuration(Duration duration) {
        this.duration = duration;
        return this;
    }

    public TimedBoxRenderData addText(String text) {
        this.text.add(text);
        return this;
    }

    public TimedBoxRenderData setColor(int argbColor) {
        this.argbColor = argbColor;
        return this;
    }
}

