/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.render;

import com.minecolonies.api.client.render.modeltype.CitizenModel;
import com.minecolonies.api.client.render.modeltype.IModelType;
import com.minecolonies.api.client.render.modeltype.ModModelTypes;
import com.minecolonies.api.client.render.modeltype.registry.IModelTypeRegistry;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.apiimp.initializer.ModModelTypeInitializer;
import com.minecolonies.core.client.render.CitizenArmorLayer;
import com.minecolonies.core.client.render.RenderUtils;
import com.minecolonies.core.client.render.worldevent.RenderTypes;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class RenderBipedCitizen
extends MobRenderer<AbstractEntityCitizen, CitizenModel<AbstractEntityCitizen>> {
    private static final double SHADOW_SIZE = 0.5;
    public static boolean isItGhostTime = false;

    public RenderBipedCitizen(EntityRendererProvider.Context context) {
        super(context, new CitizenModel(context.m_174023_(ModelLayers.f_171162_)), 0.5f);
        this.m_115326_((RenderLayer)new CitizenArmorLayer(this, new HumanoidModel(context.m_174023_(ModelLayers.f_171164_)), new HumanoidModel(context.m_174023_(ModelLayers.f_171165_)), context.m_266367_(), context.m_174027_()));
        super.m_115326_((RenderLayer)new ItemInHandLayer((RenderLayerParent)this, context.m_234598_()));
        ModModelTypeInitializer.init(context);
    }

    public void render(@NotNull AbstractEntityCitizen citizen, float limbSwing, float partialTicks, @NotNull PoseStack matrixStack, @NotNull MultiBufferSource renderTypeBuffer, int light) {
        this.setupMainModelFrom(citizen);
        CitizenModel citizenModel = (CitizenModel)this.f_115290_;
        citizenModel.f_102816_ = RenderUtils.getArmPose((Mob)citizen, InteractionHand.MAIN_HAND);
        citizenModel.f_102815_ = RenderUtils.getArmPose((Mob)citizen, InteractionHand.OFF_HAND);
        if (isItGhostTime) {
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.3f);
            super.m_7392_((Mob)citizen, limbSwing, partialTicks, matrixStack, renderTypeBuffer, light);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
        } else {
            super.m_7392_((Mob)citizen, limbSwing, partialTicks, matrixStack, renderTypeBuffer, light);
        }
    }

    private void setupMainModelFrom(@NotNull AbstractEntityCitizen citizen) {
        IModelType modelType = IModelTypeRegistry.getInstance().getModelType(citizen.getModelType());
        Object object = this.f_115290_ = citizen.isFemale() ? modelType.getFemaleModel() : modelType.getMaleModel();
        if (this.f_115290_ == null) {
            Object object2 = this.f_115290_ = citizen.isFemale() ? modelType.getFemaleModel() : modelType.getMaleModel();
        }
        if (citizen.getCitizenDataView() != null && citizen.getCitizenDataView().getCustomTexture() != null) {
            this.f_115290_ = IModelTypeRegistry.getInstance().getModelType(ModModelTypes.CUSTOM_ID).getMaleModel();
        }
        ((CitizenModel)this.f_115290_).f_102610_ = citizen.m_6162_();
        ((CitizenModel)this.f_115290_).f_102609_ = citizen.m_20202_() != null;
        ((CitizenModel)this.f_115290_).f_102608_ = citizen.f_20921_;
    }

    protected void renderNameTag(@NotNull AbstractEntityCitizen entityIn, @NotNull Component str, @NotNull PoseStack matrixStack, @NotNull MultiBufferSource buffer, int packedLight) {
        double distance;
        super.m_7649_((Entity)entityIn, str, matrixStack, buffer, packedLight);
        if (entityIn.getCitizenDataView() != null && entityIn.getCitizenDataView().hasVisibleInteractions() && (distance = this.f_114476_.m_114378_(entityIn.m_20185_(), entityIn.m_20186_(), entityIn.m_20189_())) <= 4096.0) {
            double y = entityIn.m_278726_() + 0.3f;
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.0, y, 0.0);
            matrixStack.m_252781_(this.f_114476_.m_253208_());
            matrixStack.m_85841_(-0.025f, -0.025f, 0.025f);
            Matrix4f pose = matrixStack.m_85850_().m_252922_();
            VertexConsumer r = buffer.m_6299_(RenderTypes.worldEntityIcon(entityIn.getCitizenDataView().getInteractionIcon()));
            r.m_252986_(pose, -5.0f, 0.0f, 0.0f).m_7421_(0.0f, 0.0f).m_5752_();
            r.m_252986_(pose, -5.0f, 10.0f, 0.0f).m_7421_(0.0f, 1.0f).m_5752_();
            r.m_252986_(pose, 5.0f, 10.0f, 0.0f).m_7421_(1.0f, 1.0f).m_5752_();
            r.m_252986_(pose, 5.0f, 0.0f, 0.0f).m_7421_(1.0f, 0.0f).m_5752_();
            matrixStack.m_85849_();
        }
    }

    @NotNull
    public ResourceLocation getTextureLocation(AbstractEntityCitizen entity) {
        if (entity.getCitizenDataView() != null && entity.getCitizenDataView().getCustomTexture() != null) {
            return entity.getCitizenDataView().getCustomTexture();
        }
        return entity.getTexture();
    }
}

