/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import com.minecolonies.api.advancements.AdvancementTriggers;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.compatibility.Compatibility;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.happiness.ExpirationBasedHappinessModifier;
import com.minecolonies.api.entity.citizen.happiness.StaticHappinessSupplier;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.items.CheckedNbtKey;
import com.minecolonies.api.items.IMinecoloniesFoodItem;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.util.FoodUtils;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.core.items.ItemBowlFood;
import com.minecolonies.core.util.AdvancementUtils;
import com.minecolonies.core.util.FurnaceRecipes;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.HoneyBottleItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BrewingStandBlockEntity;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.Tags;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ItemStackUtils {
    private static final Pattern TEMPLATE_PATH_PATTERN = Pattern.compile("\\[PATH(?::([^=]*)=([^]]*))?]");
    private static final Map<Item, Integer> VANILLA_ARMOR_DISTRIBUTION = Map.ofEntries(Map.entry(Items.f_42407_, 1), Map.entry(Items.f_42408_, 1), Map.entry(Items.f_42462_, 1), Map.entry(Items.f_42463_, 1), Map.entry(Items.f_42476_, 1), Map.entry(Items.f_42477_, 1), Map.entry(Items.f_42478_, 1), Map.entry(Items.f_42479_, 1), Map.entry(Items.f_42464_, 2), Map.entry(Items.f_42465_, 2), Map.entry(Items.f_42466_, 2), Map.entry(Items.f_42467_, 2), Map.entry(Items.f_42468_, 3), Map.entry(Items.f_42469_, 3), Map.entry(Items.f_42470_, 3), Map.entry(Items.f_42471_, 3), Map.entry(Items.f_42472_, 4), Map.entry(Items.f_42473_, 4), Map.entry(Items.f_42474_, 4), Map.entry(Items.f_42475_, 4), Map.entry(Items.f_42480_, 5), Map.entry(Items.f_42481_, 5), Map.entry(Items.f_42482_, 5), Map.entry(Items.f_42483_, 5));
    private static final Map<EquipmentSlot, List<Item>> VANILLA_ARMOR_MAPPING = Map.ofEntries(Map.entry(EquipmentSlot.HEAD, List.of(Items.f_42407_, Items.f_42464_, Items.f_42468_, Items.f_42472_)), Map.entry(EquipmentSlot.CHEST, List.of(Items.f_42408_, Items.f_42465_, Items.f_42469_, Items.f_42473_)), Map.entry(EquipmentSlot.LEGS, List.of(Items.f_42462_, Items.f_42466_, Items.f_42470_, Items.f_42474_)), Map.entry(EquipmentSlot.FEET, List.of(Items.f_42463_, Items.f_42467_, Items.f_42471_, Items.f_42475_)));
    public static final ItemStack EMPTY = ItemStack.f_41583_;
    @NotNull
    public static final Predicate<ItemStack> EMPTY_PREDICATE = ItemStackUtils::isEmpty;
    @NotNull
    public static final Predicate<ItemStack> NOT_EMPTY_PREDICATE = EMPTY_PREDICATE.negate();
    private static final String NBT_TAG_ENCHANT_ID = "id";
    private static final String NBT_TAG_ENCHANT_LEVEL = "lvl";
    private static final int FORTUNE_ENCHANT_ID = 35;
    private static final int SILK_TOUCH_ENCHANT_ID = 33;
    public static HashMap<Item, Set<CheckedNbtKey>> CHECKED_NBT_KEYS = new HashMap();
    public static final Predicate<ItemStack> ISFOOD = stack -> {
        FoodProperties foodProperties = stack.m_41614_() ? stack.getFoodProperties(null) : null;
        return ItemStackUtils.isNotEmpty(stack) && foodProperties != null && foodProperties.m_38744_() > 0 && foodProperties.m_38745_() > 0.0f && !stack.m_204117_(ModTags.excludedFood);
    };
    public static Predicate<ItemStack> IS_SMELTABLE = itemStack -> !ItemStackUtils.isEmpty(FurnaceRecipes.getInstance().getSmeltingResult((ItemStack)itemStack));
    public static Predicate<ItemStack> ISCOOKABLE = itemStack -> ISFOOD.test(FurnaceRecipes.getInstance().getSmeltingResult((ItemStack)itemStack));
    public static final Predicate<ItemStack> IS_COMPOST = stack -> !stack.m_41619_() && stack.m_41720_() == ModItems.compost;

    private ItemStackUtils() {
    }

    public static List<ItemStorage> getListOfStackForEntity(Entity entity, Entity placer) {
        if (entity != null) {
            ArrayList<ItemStorage> request = new ArrayList<ItemStorage>();
            if (entity instanceof ItemFrame) {
                ItemStack stack2 = ((ItemFrame)entity).m_31822_();
                if (!ItemStackUtils.isEmpty(stack2)) {
                    ItemStackUtils.setSize(stack2, 1);
                    request.add(new ItemStorage(stack2));
                }
                request.add(new ItemStorage(new ItemStack((ItemLike)Items.f_42617_, 1)));
            } else if (entity instanceof ArmorStand) {
                request.add(new ItemStorage(entity.getPickedResult((HitResult)new EntityHitResult(placer))));
                entity.m_6168_().forEach(item -> request.add(new ItemStorage((ItemStack)item)));
                entity.m_6167_().forEach(item -> request.add(new ItemStorage((ItemStack)item)));
            }
            return request.stream().filter(stack -> !stack.getItemStack().m_41619_()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static boolean hasEquipmentLevel(@Nullable ItemStack stack, EquipmentTypeEntry equipmentType, int minimalLevel, int maximumLevel) {
        if (ItemStackUtils.isEmpty(stack)) {
            return false;
        }
        return equipmentType.checkIsEquipment(stack) && ItemStackUtils.verifyEquipmentLevel(stack, equipmentType.getMiningLevel(stack), minimalLevel, maximumLevel);
    }

    public static boolean isEmpty(@Nullable ItemStack stack) {
        return stack == null || stack.m_41619_();
    }

    public static boolean isNotEmpty(@Nullable ItemStack stack) {
        return !ItemStackUtils.isEmpty(stack);
    }

    public static boolean verifyEquipmentLevel(@NotNull ItemStack itemStack, int equipmentLevel, int minimalLevel, int maximumLevel) {
        if (equipmentLevel < minimalLevel) {
            return false;
        }
        return equipmentLevel + ItemStackUtils.getMaxEnchantmentLevel(itemStack) <= maximumLevel;
    }

    public static int getMaxEnchantmentLevel(ItemStack itemStack) {
        ListTag ListNBT;
        if (itemStack == null) {
            return 0;
        }
        short maxLevel = 0;
        if (itemStack != null && (ListNBT = itemStack.m_41785_()) != null) {
            for (int j = 0; j < ListNBT.size(); ++j) {
                short level = ListNBT.m_128728_(j).m_128448_(NBT_TAG_ENCHANT_LEVEL);
                maxLevel = level > maxLevel ? level : maxLevel;
            }
        }
        return Math.max(maxLevel - 1, 0);
    }

    public static int getArmorLevel(ItemStack itemStack) {
        Integer value = VANILLA_ARMOR_DISTRIBUTION.get(itemStack.m_41720_());
        if (value != null) {
            return value;
        }
        EquipmentSlot targetEquipmentSlot = LivingEntity.m_147233_((ItemStack)itemStack);
        List<Item> armorItems = VANILLA_ARMOR_MAPPING.get(targetEquipmentSlot);
        if (armorItems == null) {
            return 5;
        }
        double targetArmorLevel = ItemStackUtils.getArmorValue(itemStack);
        for (Item armorItem : armorItems) {
            double armorValue = ItemStackUtils.getArmorValue(armorItem.m_7968_());
            if (!(targetArmorLevel <= armorValue)) continue;
            return VANILLA_ARMOR_DISTRIBUTION.get(armorItem);
        }
        return 5;
    }

    private static double getArmorValue(ItemStack itemStack) {
        double armor = ItemStackUtils.getItemStackAttributeValue(itemStack, Attributes.f_22284_);
        double toughness = ItemStackUtils.getItemStackAttributeValue(itemStack, Attributes.f_22285_);
        return armor + toughness * 4.0;
    }

    public static boolean isBetterEquipment(ItemStack stack1, ItemStack stack2) {
        for (EquipmentTypeEntry equipmentType : ModEquipmentTypes.getRegistry()) {
            if (!equipmentType.checkIsEquipment(stack1) || !equipmentType.checkIsEquipment(stack2) || equipmentType.getMiningLevel(stack1) <= equipmentType.getMiningLevel(stack2)) continue;
            return true;
        }
        return false;
    }

    public static int getFortuneOf(@Nullable ItemStack tool) {
        if (tool == null) {
            return 0;
        }
        int fortune = 0;
        if (tool.m_41793_()) {
            ListTag t = tool.m_41785_();
            for (int i = 0; i < t.size(); ++i) {
                short id = t.m_128728_(i).m_128448_(NBT_TAG_ENCHANT_ID);
                if (id != 35) continue;
                fortune = t.m_128728_(i).m_128448_(NBT_TAG_ENCHANT_LEVEL);
            }
        }
        return fortune;
    }

    public static boolean doesItemServeAsWeapon(@NotNull ItemStack stack) {
        return stack.m_41720_() instanceof SwordItem || stack.m_41720_() instanceof DiggerItem || Compatibility.isTinkersWeapon(stack);
    }

    public static MutableComponent swapArmorGrade(int toolGrade) {
        if (toolGrade >= 0 && toolGrade <= 4) {
            return Component.m_237115_((String)("com.minecolonies.coremod.armorlevel." + toolGrade));
        }
        return Component.m_237115_((String)"com.minecolonies.coremod.armorlevel.etc");
    }

    public static MutableComponent swapToolGrade(int toolGrade) {
        if (toolGrade >= 0 && toolGrade <= 4) {
            return Component.m_237115_((String)("com.minecolonies.coremod.toollevel." + toolGrade));
        }
        return Component.m_237115_((String)"com.minecolonies.coremod.toollevel.etc");
    }

    @NotNull
    public static Boolean areItemStacksMergable(ItemStack existingStack, ItemStack mergingStack) {
        if (!ItemStackUtils.compareItemStacksIgnoreStackSize(existingStack, mergingStack).booleanValue()) {
            return false;
        }
        return existingStack.m_41741_() >= ItemStackUtils.getSize(existingStack) + ItemStackUtils.getSize(mergingStack);
    }

    @NotNull
    public static Boolean compareItemStacksIgnoreStackSize(ItemStack itemStack1, ItemStack itemStack2) {
        return ItemStackUtils.compareItemStacksIgnoreStackSize(itemStack1, itemStack2, true, true);
    }

    public static int getSize(@NotNull ItemStack stack) {
        return stack.m_41613_();
    }

    public static int getDurability(@NotNull ItemStack stack) {
        if (ItemStackUtils.isEmpty(stack)) {
            return 0;
        }
        return stack.m_41776_() - stack.m_41773_();
    }

    public static boolean compareItemStacksIgnoreStackSize(ItemStack itemStack1, ItemStack itemStack2, boolean matchDamage, boolean matchNBT) {
        return ItemStackUtils.compareItemStacksIgnoreStackSize(itemStack1, itemStack2, matchDamage, matchNBT, false);
    }

    public static boolean compareItemStacksIgnoreStackSize(ItemStack itemStack1, ItemStack itemStack2, boolean matchDamage, boolean matchNBT, boolean min) {
        return ItemStackUtils.compareItemStacksIgnoreStackSize(itemStack1, itemStack2, matchDamage, matchNBT, false, false);
    }

    public static boolean compareItemStacksIgnoreStackSize(ItemStack itemStack1, ItemStack itemStack2, boolean matchDamage, boolean matchNBT, boolean min, boolean matchNBTExactly) {
        if (ItemStackUtils.isEmpty(itemStack1) && ItemStackUtils.isEmpty(itemStack2)) {
            return true;
        }
        if (ItemStackUtils.isEmpty(itemStack1) != ItemStackUtils.isEmpty(itemStack2)) {
            return false;
        }
        if (!(itemStack1.m_41720_() != itemStack2.m_41720_() || matchDamage && itemStack1.m_41773_() != itemStack2.m_41773_())) {
            if (!matchNBT) {
                return true;
            }
            if (min && itemStack1.m_41613_() > itemStack2.m_41613_()) {
                return false;
            }
            if (itemStack1.m_41782_() || itemStack2.m_41782_()) {
                if (matchNBTExactly) {
                    return Objects.equals(itemStack1.m_41783_(), itemStack2.m_41783_());
                }
                Set checkedKeys = CHECKED_NBT_KEYS.getOrDefault(itemStack1.m_41720_(), null);
                if (checkedKeys == null) {
                    return itemStack1.m_41782_() && itemStack2.m_41782_() && itemStack1.m_41783_().equals((Object)itemStack2.m_41783_());
                }
                if (itemStack1.m_41782_() != itemStack2.m_41782_() && !checkedKeys.isEmpty()) {
                    return false;
                }
                if (checkedKeys.isEmpty()) {
                    return true;
                }
                CompoundTag nbt1 = itemStack1.m_41783_();
                CompoundTag nbt2 = itemStack2.m_41783_();
                for (CheckedNbtKey key : checkedKeys) {
                    if (key.matches(nbt1, nbt2)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static boolean compareItemStackListIgnoreStackSize(List<ItemStack> stacks, ItemStack stack) {
        return ItemStackUtils.compareItemStackListIgnoreStackSize(stacks, stack, true, true);
    }

    public static boolean compareItemStackListIgnoreStackSize(List<ItemStack> stacks, ItemStack stack, boolean matchDamage, boolean matchNBT) {
        for (ItemStack tempStack : stacks) {
            if (!ItemStackUtils.compareItemStacksIgnoreStackSize(tempStack, stack, matchDamage, matchNBT)) continue;
            return true;
        }
        return false;
    }

    public static void setSize(@NotNull ItemStack stack, int size) {
        stack.m_41764_(size);
    }

    public static void changeSize(@NotNull ItemStack stack, int amount) {
        stack.m_41764_(stack.m_41613_() + amount);
    }

    @NotNull
    public static ItemStack deserializeFromNBT(@NotNull CompoundTag compound) {
        return ItemStack.m_41712_((CompoundTag)compound);
    }

    public static boolean isStackSapling(@Nullable ItemStack stack) {
        if (ItemStackUtils.isEmpty(stack)) {
            return false;
        }
        return stack.m_204117_(ItemTags.f_13180_) || stack.m_204117_(Tags.Items.MUSHROOMS) || stack.m_204117_(ModTags.fungi) || Compatibility.isDynamicTreeSapling(stack);
    }

    public static boolean hasSmeltableInFurnaceAndNoFuel(FurnaceBlockEntity entity) {
        return !ItemStackUtils.isEmpty(entity.m_8020_(0)) && ItemStackUtils.isEmpty(entity.m_8020_(1));
    }

    public static boolean hasNeitherFuelNorSmeltAble(FurnaceBlockEntity entity) {
        return ItemStackUtils.isEmpty(entity.m_8020_(0)) && ItemStackUtils.isEmpty(entity.m_8020_(1));
    }

    public static boolean hasFuelInFurnaceAndNoSmeltable(FurnaceBlockEntity entity) {
        return ItemStackUtils.isEmpty(entity.m_8020_(0)) && !ItemStackUtils.isEmpty(entity.m_8020_(1));
    }

    public static boolean hasBrewableAndNoFuel(BrewingStandBlockEntity entity) {
        return !ItemStackUtils.isEmpty(entity.m_8020_(3)) && ItemStackUtils.isEmpty(entity.m_8020_(4));
    }

    public static boolean hasNeitherFuelNorBrewable(BrewingStandBlockEntity entity) {
        return ItemStackUtils.isEmpty(entity.m_8020_(3)) && ItemStackUtils.isEmpty(entity.m_8020_(4));
    }

    public static boolean hasFuelAndNoBrewable(BrewingStandBlockEntity entity) {
        return ItemStackUtils.isEmpty(entity.m_8020_(3)) && !ItemStackUtils.isEmpty(entity.m_8020_(4));
    }

    public static ItemStack idToItemStack(String itemData) {
        String itemId = itemData;
        int tagIndex = itemId.indexOf("{");
        String tag = tagIndex > 0 ? itemId.substring(tagIndex) : null;
        itemId = tagIndex > 0 ? itemId.substring(0, tagIndex) : itemId;
        String[] split = itemId.split(":");
        if (split.length != 2) {
            if (split.length == 1) {
                String[] tempArray = new String[]{"minecraft", split[0]};
                split = tempArray;
            } else {
                Log.getLogger().error("Unable to parse item definition: " + itemData);
            }
        }
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(split[0], split[1]));
        ItemStack stack = new ItemStack((ItemLike)item);
        if (tag != null) {
            try {
                stack.m_41751_(TagParser.m_129359_((String)tag));
            }
            catch (CommandSyntaxException e1) {
                Log.getLogger().error("Unable to parse item definition: " + itemData);
            }
        }
        if (stack.m_41619_()) {
            Log.getLogger().warn("Parsed item definition returned empty: " + itemData);
        }
        return stack;
    }

    @NotNull
    public static Tuple<Boolean, String> parseIdTemplate(@Nullable String value, @NotNull ResourceLocation baseItemId) {
        if (value == null) {
            return new Tuple<Boolean, Object>(false, null);
        }
        int nbtIndex = value.indexOf(123);
        String itemId = nbtIndex < 0 ? value : value.substring(0, nbtIndex);
        itemId = itemId.replace("[NS]", baseItemId.m_135827_());
        itemId = TEMPLATE_PATH_PATTERN.matcher(itemId).replaceAll(m -> {
            if (m.group(1) != null && m.group(2) != null) {
                return baseItemId.m_135815_().replace(m.group(1), m.group(2));
            }
            return baseItemId.m_135815_();
        });
        return new Tuple<Boolean, CallSite>(ForgeRegistries.ITEMS.containsKey(new ResourceLocation(itemId)), (CallSite)((Object)(itemId + (nbtIndex >= 0 ? value.substring(nbtIndex) : ""))));
    }

    public static boolean hasTag(@NotNull ItemStack stack) {
        return stack.m_41783_() != null && stack.m_41783_().m_128440_() > (stack.m_41763_() ? 1 : 0);
    }

    public static Set<ItemStack> allItemsPlusInventory(@NotNull Player player) {
        HashSet<ItemStorage> allItems = new HashSet<ItemStorage>(IColonyManager.getInstance().getCompatibilityManager().getSetOfAllItems());
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (stack.m_41619_()) continue;
            ItemStack pristine = stack.m_41777_();
            pristine.m_41764_(1);
            if (stack.m_41763_() && stack.m_41768_()) {
                pristine.m_41721_(0);
            }
            allItems.add(new ItemStorage(pristine, true));
        }
        return allItems.stream().map(ItemStorage::getItemStack).collect(Collectors.toSet());
    }

    public static void consumeFood(ItemStack foodStack, AbstractEntityCitizen citizen, Inventory inventory) {
        IColony citizenColony;
        IMinecoloniesFoodItem foodItem;
        Item item;
        ICitizenData citizenData = citizen.getCitizenData();
        double satIncrease = FoodUtils.getFoodValue(foodStack, citizen);
        citizenData.increaseSaturation(satIncrease);
        ItemStack itemUseReturn = foodStack.m_41671_(citizen.m_9236_(), (LivingEntity)citizen);
        if (foodStack.m_41720_() instanceof HoneyBottleItem) {
            itemUseReturn = new ItemStack((ItemLike)Items.f_42590_);
        } else if (foodStack.m_41720_() instanceof ItemBowlFood) {
            itemUseReturn = new ItemStack((ItemLike)Items.f_42399_);
        }
        if (!itemUseReturn.m_41619_() && itemUseReturn.m_41720_() != foodStack.m_41720_()) {
            if (citizenData.getInventory().isFull() || inventory != null && !inventory.m_36054_(itemUseReturn)) {
                InventoryUtils.spawnItemStack(citizen.f_19853_, citizen.m_20185_(), citizen.m_20186_(), citizen.m_20189_(), itemUseReturn);
            } else {
                InventoryUtils.addItemStackToItemHandler((IItemHandler)citizenData.getInventory(), itemUseReturn);
            }
        }
        if ((item = foodStack.m_41720_()) instanceof IMinecoloniesFoodItem && (foodItem = (IMinecoloniesFoodItem)item).getTier() >= 3) {
            citizen.getCitizenData().getCitizenHappinessHandler().addModifier(new ExpirationBasedHappinessModifier("greatfood", 2.0, new StaticHappinessSupplier(2.0), 5));
        }
        if ((citizenColony = citizen.getCitizenColonyHandler().getColonyOrRegister()) != null) {
            AdvancementUtils.TriggerAdvancementPlayersForColony(citizenColony, playerMP -> AdvancementTriggers.CITIZEN_EAT_FOOD.trigger((ServerPlayer)playerMP, foodStack));
        }
        citizenData.markDirty(60);
    }

    public static double getItemStackAttributeValue(ItemStack itemStack, Attribute attribute) {
        try {
            AttributeInstance instance = new AttributeInstance(attribute, f -> {});
            itemStack.m_41638_(LivingEntity.m_147233_((ItemStack)itemStack)).get((Object)attribute).forEach(arg_0 -> ((AttributeInstance)instance).m_22118_(arg_0));
            return instance.m_22135_();
        }
        catch (Exception e) {
            Log.getLogger().warn("Could not get attribute value for '{}' on item '{}'", (Object)attribute.m_22087_(), (Object)itemStack.m_41778_(), (Object)e);
            return 0.0;
        }
    }
}

