/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.client.gui;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.silentchaos512.utils.Anchor;

public abstract class DebugRenderOverlay {
    protected static final String SPLITTER = "=";
    private static final int DEFAULT_UPDATE_FREQUENCY = 10;
    private static final int DEFAULT_SPLIT_WIDTH = 100;
    private static final int LINE_HEIGHT = 10;
    private List<String> debugText = new ArrayList<String>();
    private int textWidth;
    private int textHeight;
    @Deprecated
    private int startX = 3;
    @Deprecated
    private int startY = 3;
    private int ticksPassed = 0;

    protected DebugRenderOverlay() {
        MinecraftForge.EVENT_BUS.addListener(this::renderTick);
        MinecraftForge.EVENT_BUS.addListener(this::clientTick);
    }

    @Deprecated
    protected DebugRenderOverlay(int startX, int startY) {
        this();
        this.startX = startX;
        this.startY = startY;
    }

    @Nonnull
    public abstract List<String> getDebugText();

    public abstract float getTextScale();

    public Anchor getAnchorPoint() {
        return Anchor.TOP_LEFT;
    }

    public int getMarginSize() {
        return 3;
    }

    @Nonnegative
    public int getUpdateFrequency() {
        return 10;
    }

    @Nonnegative
    public int getSplitWidth() {
        return 100;
    }

    public abstract boolean isHidden();

    protected void drawLine(GuiGraphics graphics, Font font, String line, int x, int y, int color) {
        String[] array = line.split(SPLITTER);
        if (array.length == 2) {
            graphics.m_280488_(font, array[0].trim(), x, y, color);
            graphics.m_280488_(font, array[1].trim(), x + this.getSplitWidth(), y, color);
        } else {
            graphics.m_280488_(font, line, x, y, color);
        }
    }

    @Deprecated
    public int getStartX() {
        return this.startX;
    }

    @Deprecated
    public int getStartY() {
        return this.startY;
    }

    public void renderTick(RenderGuiOverlayEvent.Post event) {
        Minecraft mc = Minecraft.m_91087_();
        if (this.isHidden() || this.debugText.isEmpty() || mc.m_91104_() || mc.f_91066_.f_92063_ || event.getOverlay() != VanillaGuiOverlay.CHAT_PANEL.type()) {
            return;
        }
        float scale = this.getTextScale();
        if (scale <= 0.0f) {
            return;
        }
        Font font = mc.f_91062_;
        PoseStack matrix = event.getGuiGraphics().m_280168_();
        matrix.m_85836_();
        matrix.m_85841_(scale, scale, 1.0f);
        Window mainWindow = mc.m_91268_();
        int x = (int)((float)this.getAnchorPoint().getX(mainWindow.m_85445_(), this.textWidth, this.getMarginSize()) / this.getTextScale());
        int y = (int)((float)this.getAnchorPoint().getY(mainWindow.m_85446_(), this.textHeight, this.getMarginSize()) / this.getTextScale());
        for (String line : this.debugText) {
            this.drawLine(event.getGuiGraphics(), font, line, x, y, 0xFFFFFF);
            y += 10;
        }
        matrix.m_85849_();
    }

    public void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        if (this.getUpdateFrequency() == 0 || ++this.ticksPassed % this.getUpdateFrequency() == 0) {
            this.debugText = this.getDebugText();
            Font font = Minecraft.m_91087_().f_91062_;
            this.textWidth = 0;
            this.textHeight = 10 * this.debugText.size();
            for (String line : this.debugText) {
                String[] array = line.split(SPLITTER);
                if (array.length == 2) {
                    int width = this.getSplitWidth() + font.m_92895_(array[1]);
                    this.textWidth = Math.max(this.textWidth, width);
                    continue;
                }
                this.textWidth = Math.max(this.textWidth, font.m_92895_(line));
            }
        }
    }
}

