/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.common.blockentities;

import com.direwolf20.laserio.client.particles.fluidparticle.FluidFlowParticleData;
import com.direwolf20.laserio.client.particles.itemparticle.ItemFlowParticleData;
import com.direwolf20.laserio.common.blockentities.basebe.BaseLaserBE;
import com.direwolf20.laserio.common.blocks.LaserNode;
import com.direwolf20.laserio.common.containers.LaserNodeContainer;
import com.direwolf20.laserio.common.events.ServerTickHandler;
import com.direwolf20.laserio.common.items.cards.BaseCard;
import com.direwolf20.laserio.common.items.cards.CardEnergy;
import com.direwolf20.laserio.common.items.cards.CardFluid;
import com.direwolf20.laserio.common.items.cards.CardItem;
import com.direwolf20.laserio.common.items.cards.CardRedstone;
import com.direwolf20.laserio.common.items.filters.FilterBasic;
import com.direwolf20.laserio.common.items.filters.FilterCount;
import com.direwolf20.laserio.common.items.filters.FilterMod;
import com.direwolf20.laserio.common.items.filters.FilterTag;
import com.direwolf20.laserio.common.items.upgrades.OverclockerNode;
import com.direwolf20.laserio.setup.Registration;
import com.direwolf20.laserio.util.BaseCardCache;
import com.direwolf20.laserio.util.CardRender;
import com.direwolf20.laserio.util.DimBlockPos;
import com.direwolf20.laserio.util.ExtractorCardCache;
import com.direwolf20.laserio.util.FluidStackKey;
import com.direwolf20.laserio.util.InserterCardCache;
import com.direwolf20.laserio.util.ItemHandlerUtil;
import com.direwolf20.laserio.util.ItemStackKey;
import com.direwolf20.laserio.util.MiscTools;
import com.direwolf20.laserio.util.NodeSideCache;
import com.direwolf20.laserio.util.ParticleData;
import com.direwolf20.laserio.util.ParticleDataFluid;
import com.direwolf20.laserio.util.ParticleRenderData;
import com.direwolf20.laserio.util.ParticleRenderDataFluid;
import com.direwolf20.laserio.util.SensorCardCache;
import com.direwolf20.laserio.util.StockerCardCache;
import com.direwolf20.laserio.util.TransferResult;
import com.direwolf20.laserio.util.WeakConsumerWrapper;
import it.unimi.dsi.fastutil.bytes.Byte2BooleanMap;
import it.unimi.dsi.fastutil.bytes.Byte2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.bytes.Byte2ByteMap;
import it.unimi.dsi.fastutil.bytes.Byte2ByteOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.joml.Vector3f;

public class LaserNodeBE
extends BaseLaserBE {
    private static final Vector3f[] offsets = new Vector3f[]{new Vector3f(0.65f, 0.65f, 0.5f), new Vector3f(0.5f, 0.65f, 0.5f), new Vector3f(0.35f, 0.65f, 0.5f), new Vector3f(0.65f, 0.5f, 0.5f), new Vector3f(0.5f, 0.5f, 0.5f), new Vector3f(0.35f, 0.5f, 0.5f), new Vector3f(0.65f, 0.35f, 0.5f), new Vector3f(0.5f, 0.35f, 0.5f), new Vector3f(0.35f, 0.35f, 0.5f)};
    public final NodeSideCache[] nodeSideCaches = new NodeSideCache[6];
    private final IItemHandler EMPTY = new ItemStackHandler(0);
    public Map<ExtractorCardCache, Integer> roundRobinMap = new Object2IntOpenHashMap();
    private final Map<SideConnection, LazyOptional<IItemHandler>> facingHandlerItem = new HashMap<SideConnection, LazyOptional<IItemHandler>>();
    private final Map<SideConnection, NonNullConsumer<LazyOptional<IItemHandler>>> connectionInvalidatorItem = new HashMap<SideConnection, NonNullConsumer<LazyOptional<IItemHandler>>>();
    private final Map<SideConnection, LazyOptional<IFluidHandler>> facingHandlerFluid = new HashMap<SideConnection, LazyOptional<IFluidHandler>>();
    private final Map<SideConnection, NonNullConsumer<LazyOptional<IFluidHandler>>> connectionInvalidatorFluid = new HashMap<SideConnection, NonNullConsumer<LazyOptional<IFluidHandler>>>();
    private final Map<SideConnection, LazyOptional<IEnergyStorage>> facingHandlerEnergy = new HashMap<SideConnection, LazyOptional<IEnergyStorage>>();
    private final Map<SideConnection, NonNullConsumer<LazyOptional<IEnergyStorage>>> connectionInvalidatorEnergy = new HashMap<SideConnection, NonNullConsumer<LazyOptional<IEnergyStorage>>>();
    private final Set<DimBlockPos> otherNodesInNetwork = new HashSet<DimBlockPos>();
    private final List<InserterCardCache> inserterNodes = new CopyOnWriteArrayList<InserterCardCache>();
    private final HashMap<ExtractorCardCache, HashMap<ItemStackKey, List<InserterCardCache>>> inserterCache = new HashMap();
    private final HashMap<ExtractorCardCache, HashMap<FluidStackKey, List<InserterCardCache>>> inserterCacheFluid = new HashMap();
    private final HashMap<ExtractorCardCache, List<InserterCardCache>> channelOnlyCache = new HashMap();
    private final List<ParticleRenderData> particleRenderData = new ArrayList<ParticleRenderData>();
    private final List<ParticleRenderDataFluid> particleRenderDataFluids = new ArrayList<ParticleRenderDataFluid>();
    private final Random random = new Random();
    private final Map<StockerRequest, StockerSource> stockerDestinationCache = new HashMap<StockerRequest, StockerSource>();
    public boolean rendersChecked = false;
    public List<CardRender> cardRenders = new ArrayList<CardRender>();
    public Byte2ByteMap redstoneNetwork = new Byte2ByteOpenHashMap();
    public Byte2ByteMap myRedstoneIn = new Byte2ByteOpenHashMap();
    public Byte2ByteMap myRedstoneOut = new Byte2ByteOpenHashMap();
    public Byte2BooleanMap redstoneCardSides = new Byte2BooleanOpenHashMap();
    public boolean redstoneChecked = false;
    public boolean redstoneRefreshed = false;
    public boolean firstTimeNodeLoaded = true;
    private boolean discoveredNodes = false;

    public LaserNodeBE(BlockPos pos, BlockState state) {
        super((BlockEntityType)Registration.LaserNode_BE.get(), pos, state);
        for (Direction direction : Direction.values()) {
            int j = direction.ordinal();
            com.direwolf20.laserio.common.containers.customhandler.LaserNodeItemHandler tempHandler = new com.direwolf20.laserio.common.containers.customhandler.LaserNodeItemHandler(LaserNodeContainer.SLOTS, this);
            this.nodeSideCaches[j] = new NodeSideCache(tempHandler, (LazyOptional<com.direwolf20.laserio.common.containers.customhandler.LaserNodeItemHandler>)LazyOptional.of(() -> tempHandler), 0, new LaserEnergyStorage(direction));
        }
    }

    public void setOtherNodesInNetwork(Set<DimBlockPos> otherNodesInNetwork) {
        this.otherNodesInNetwork.clear();
        for (DimBlockPos pos : otherNodesInNetwork) {
            this.otherNodesInNetwork.add(new DimBlockPos(pos.getLevel(this.f_58857_.m_7654_()), this.getRelativePos(pos.blockPos)));
        }
        this.refreshAllInvNodes();
    }

    public void updateOverclockers() {
        for (Direction direction : Direction.values()) {
            int slot = 9;
            NodeSideCache nodeSideCache = this.nodeSideCaches[direction.ordinal()];
            ItemStack overclockerStack = nodeSideCache.itemHandler.getStackInSlot(slot);
            if (overclockerStack.m_41619_()) {
                nodeSideCache.overClocker = 0;
            }
            if (!(overclockerStack.m_41720_() instanceof OverclockerNode)) continue;
            nodeSideCache.overClocker = overclockerStack.m_41613_();
        }
    }

    public void findMyExtractors() {
        for (Direction direction : Direction.values()) {
            NodeSideCache nodeSideCache = this.nodeSideCaches[direction.ordinal()];
            nodeSideCache.extractorCardCaches.clear();
            for (int slot = 0; slot < 9; ++slot) {
                ItemStack card = nodeSideCache.itemHandler.getStackInSlot(slot);
                if (!(card.m_41720_() instanceof BaseCard) || card.m_41720_() instanceof CardRedstone) continue;
                if (BaseCard.getNamedTransferMode(card).equals((Object)BaseCard.TransferMode.EXTRACT)) {
                    nodeSideCache.extractorCardCaches.add(new ExtractorCardCache(direction, card, slot, this));
                }
                if (BaseCard.getNamedTransferMode(card).equals((Object)BaseCard.TransferMode.STOCK)) {
                    nodeSideCache.extractorCardCaches.add(new StockerCardCache(direction, card, slot, this));
                }
                if (!BaseCard.getNamedTransferMode(card).equals((Object)BaseCard.TransferMode.SENSOR)) continue;
                nodeSideCache.extractorCardCaches.add(new SensorCardCache(direction, card, slot, this));
            }
        }
    }

    public void extract() {
        for (Direction direction : Direction.values()) {
            NodeSideCache nodeSideCache = this.nodeSideCaches[direction.ordinal()];
            int countCardsHandled = 0;
            for (ExtractorCardCache extractorCardCache : nodeSideCache.extractorCardCaches) {
                if (extractorCardCache instanceof SensorCardCache || extractorCardCache.decrementSleep() != 0 || !extractorCardCache.enabled || countCardsHandled > nodeSideCache.overClocker) continue;
                if (extractorCardCache instanceof StockerCardCache) {
                    StockerCardCache stockerCardCache = (StockerCardCache)extractorCardCache;
                    if (extractorCardCache.cardType.equals((Object)BaseCard.CardType.ITEM)) {
                        if (this.stockItems(stockerCardCache)) {
                            ++countCardsHandled;
                        }
                    } else if (extractorCardCache.cardType.equals((Object)BaseCard.CardType.FLUID)) {
                        if (this.stockFluids(stockerCardCache)) {
                            ++countCardsHandled;
                        }
                    } else if (extractorCardCache.cardType.equals((Object)BaseCard.CardType.ENERGY) && this.stockEnergy(stockerCardCache)) {
                        ++countCardsHandled;
                    }
                } else if (extractorCardCache.cardType.equals((Object)BaseCard.CardType.ITEM)) {
                    if (this.sendItems(extractorCardCache)) {
                        ++countCardsHandled;
                    }
                } else if (extractorCardCache.cardType.equals((Object)BaseCard.CardType.FLUID)) {
                    if (this.sendFluids(extractorCardCache)) {
                        ++countCardsHandled;
                    }
                } else if (extractorCardCache.cardType.equals((Object)BaseCard.CardType.ENERGY) && this.sendEnergy(extractorCardCache)) {
                    ++countCardsHandled;
                }
                if (extractorCardCache.remainingSleep > 0) continue;
                extractorCardCache.remainingSleep = extractorCardCache.tickSpeed;
            }
        }
    }

    public void sense() {
        for (Direction direction : Direction.values()) {
            NodeSideCache nodeSideCache = this.nodeSideCaches[direction.ordinal()];
            int countCardsHandled = 0;
            for (ExtractorCardCache extractorCardCache : nodeSideCache.extractorCardCaches) {
                if (!(extractorCardCache instanceof SensorCardCache) || extractorCardCache.decrementSleep() != 0 || !extractorCardCache.enabled || countCardsHandled > nodeSideCache.overClocker) continue;
                if (extractorCardCache instanceof SensorCardCache) {
                    SensorCardCache sensorCardCache = (SensorCardCache)extractorCardCache;
                    if (extractorCardCache.cardType.equals((Object)BaseCard.CardType.ITEM)) {
                        if (this.senseItems(sensorCardCache)) {
                            ++countCardsHandled;
                        }
                    } else if (extractorCardCache.cardType.equals((Object)BaseCard.CardType.FLUID)) {
                        if (this.senseFluids(sensorCardCache)) {
                            ++countCardsHandled;
                        }
                    } else if (extractorCardCache.cardType.equals((Object)BaseCard.CardType.ENERGY) && this.senseEnergy(sensorCardCache)) {
                        ++countCardsHandled;
                    }
                }
                if (extractorCardCache.remainingSleep > 0) continue;
                extractorCardCache.remainingSleep = extractorCardCache.tickSpeed;
            }
        }
    }

    public void tickClient() {
        this.drawParticlesClient();
        this.particleRenderData.clear();
        this.particleRenderDataFluids.clear();
    }

    public void tickServer() {
        if (!this.discoveredNodes) {
            this.discoverAllNodes();
            this.findMyExtractors();
            this.updateOverclockers();
            this.discoveredNodes = true;
        }
        this.sense();
        if (!this.redstoneChecked) {
            this.populateThisRedstoneNetwork(true);
            this.redstoneChecked = true;
        }
        if (!this.redstoneRefreshed) {
            this.refreshRedstoneNetwork();
            this.redstoneRefreshed = true;
        }
        this.extract();
    }

    public void populateThisRedstoneNetwork(boolean notifyOthers) {
        Byte2ByteOpenHashMap myRedstoneInTemp = new Byte2ByteOpenHashMap();
        boolean updated = false;
        for (Direction direction : Direction.values()) {
            NodeSideCache nodeSideCache = this.nodeSideCaches[direction.ordinal()];
            for (int slot = 0; slot < 9; ++slot) {
                int redstoneStrength;
                ItemStack card = nodeSideCache.itemHandler.getStackInSlot(slot);
                if (!(card.m_41720_() instanceof CardRedstone) || BaseCard.getTransferMode(card) != 0 || (redstoneStrength = this.f_58857_.m_277185_(this.m_58899_().m_121945_(direction), direction)) <= 0) continue;
                byte redstoneChannel = BaseCard.getRedstoneChannel(card);
                if (myRedstoneInTemp.containsKey(redstoneChannel)) {
                    byte existingRedstoneStrength = myRedstoneInTemp.get(redstoneChannel);
                    if (redstoneStrength <= existingRedstoneStrength) continue;
                    myRedstoneInTemp.put(redstoneChannel, (byte)redstoneStrength);
                    continue;
                }
                myRedstoneInTemp.put(redstoneChannel, (byte)redstoneStrength);
            }
            for (Map.Entry entry : nodeSideCache.myRedstoneFromSensors.byte2ByteEntrySet()) {
                myRedstoneInTemp.put((Byte)entry.getKey(), (Byte)entry.getValue());
            }
        }
        if (!myRedstoneInTemp.equals(this.myRedstoneIn)) {
            updated = true;
            this.myRedstoneIn = new Byte2ByteOpenHashMap((Byte2ByteMap)myRedstoneInTemp);
        }
        if (updated && notifyOthers) {
            this.notifyOtherNodesOfChange();
        }
    }

    public void refreshRedstoneNetwork() {
        this.redstoneNetwork.clear();
        for (DimBlockPos pos : this.otherNodesInNetwork) {
            LaserNodeBE laserNodeBE = this.getNodeAt(new DimBlockPos(pos.getLevel(this.f_58857_.m_7654_()), this.getWorldPos(pos.blockPos)));
            if (laserNodeBE == null) continue;
            for (Map.Entry entry : laserNodeBE.myRedstoneIn.byte2ByteEntrySet()) {
                this.updateRedstoneNetwork((Byte)entry.getKey(), (Byte)entry.getValue());
            }
        }
        this.updateRedstoneOutputs();
        this.refreshCardsRedstone();
    }

    public void refreshCardsRedstone() {
        boolean inserterUpdated = false;
        boolean extractorUpdated = false;
        for (InserterCardCache inserterCardCache : this.inserterNodes) {
            if (!inserterCardCache.be.m_58899_().equals((Object)this.m_58899_())) continue;
            int tempEnabled = inserterCardCache.enabled ? 1 : 0;
            inserterCardCache.setEnabled();
            if (tempEnabled == inserterCardCache.enabled) continue;
            inserterUpdated = true;
        }
        for (Direction direction : Direction.values()) {
            NodeSideCache nodeSideCache = this.nodeSideCaches[direction.ordinal()];
            nodeSideCache.invalidateEnergy();
            for (ExtractorCardCache extractorCardCache : nodeSideCache.extractorCardCaches) {
                boolean tempEnabled = extractorCardCache.enabled;
                extractorCardCache.setEnabled();
                if (tempEnabled == extractorCardCache.enabled) continue;
                extractorUpdated = true;
            }
        }
        this.markDirtyClient();
        if (inserterUpdated) {
            for (DimBlockPos pos : this.otherNodesInNetwork) {
                LaserNodeBE node = this.getNodeAt(new DimBlockPos(pos.getLevel(this.f_58857_.m_7654_()), this.getWorldPos(pos.blockPos)));
                if (node == null) continue;
                node.checkInvNode(new DimBlockPos(this.f_58857_, this.m_58899_()), true);
            }
        }
    }

    public byte getRedstoneChannelStrength(byte channel) {
        if (this.redstoneNetwork.containsKey(channel)) {
            return this.redstoneNetwork.get(channel);
        }
        return 0;
    }

    public void updateRedstoneNetwork(byte redstoneChannel, byte redstoneStrength) {
        if (this.redstoneNetwork.containsKey(redstoneChannel)) {
            byte existingRedstoneStrength = this.redstoneNetwork.get(redstoneChannel);
            if (redstoneStrength > existingRedstoneStrength) {
                this.redstoneNetwork.put(redstoneChannel, redstoneStrength);
            }
        } else {
            this.redstoneNetwork.put(redstoneChannel, redstoneStrength);
        }
    }

    public boolean getRedstoneSideStrong(Direction direction) {
        byte side = (byte)direction.ordinal();
        if (!this.myRedstoneOut.containsKey(side)) {
            return false;
        }
        byte redstoneOut = this.myRedstoneOut.get(side);
        return redstoneOut > 15;
    }

    public int getRedstoneSide(Direction direction) {
        byte side = (byte)direction.ordinal();
        if (!this.myRedstoneOut.containsKey(side)) {
            return 0;
        }
        int redstoneOut = this.myRedstoneOut.get(side);
        return redstoneOut > 15 ? redstoneOut - 15 : redstoneOut;
    }

    public void updateRedstoneOutputs() {
        Byte2ByteOpenHashMap myRedstoneOutTemp = new Byte2ByteOpenHashMap();
        this.redstoneCardSides.clear();
        for (Direction direction : Direction.values()) {
            byte side = (byte)direction.ordinal();
            NodeSideCache nodeSideCache = this.nodeSideCaches[direction.ordinal()];
            for (int slot = 0; slot < 9; ++slot) {
                ItemStack card = nodeSideCache.itemHandler.getStackInSlot(slot);
                if (card.m_41720_() instanceof CardRedstone && BaseCard.getTransferMode(card) == 1) {
                    byte redstoneStrength;
                    this.redstoneCardSides.put((byte)direction.ordinal(), true);
                    byte cardChannel = BaseCard.getRedstoneChannel(card);
                    if (!this.redstoneNetwork.containsKey(cardChannel) || (redstoneStrength = this.redstoneNetwork.get(cardChannel)) <= 0) continue;
                    if (CardRedstone.getStrong(card)) {
                        redstoneStrength = (byte)(redstoneStrength + 15);
                    }
                    if (myRedstoneOutTemp.containsKey(side)) {
                        byte existingRedstoneStrength = myRedstoneOutTemp.get(side);
                        if (redstoneStrength <= existingRedstoneStrength) continue;
                        myRedstoneOutTemp.put(side, redstoneStrength);
                        continue;
                    }
                    myRedstoneOutTemp.put(side, redstoneStrength);
                    continue;
                }
                if (!(card.m_41720_() instanceof CardRedstone) || BaseCard.getTransferMode(card) != 0) continue;
                this.redstoneCardSides.put((byte)direction.ordinal(), true);
            }
            if (!this.firstTimeNodeLoaded && Objects.equals(myRedstoneOutTemp.get(side), this.myRedstoneOut.get(side))) continue;
            if (myRedstoneOutTemp.containsKey(side)) {
                this.myRedstoneOut.put(side, myRedstoneOutTemp.get(side));
            } else {
                this.myRedstoneOut.remove(side);
            }
            this.f_58857_.m_46586_(this.m_58899_().m_121945_(direction), this.m_58900_().m_60734_(), this.m_58899_());
            this.f_58857_.m_46590_(this.m_58899_().m_121945_(direction), this.m_58900_().m_60734_(), direction.m_122424_());
        }
        BlockState state = this.m_58900_();
        state.m_60701_((LevelAccessor)this.f_58857_, this.m_58899_(), 3);
        if (this.firstTimeNodeLoaded) {
            this.firstTimeNodeLoaded = false;
        }
    }

    public void sortInserters() {
        this.inserterNodes.sort(Comparator.comparingDouble(InserterCardCache::getDistance));
        this.inserterNodes.sort(Comparator.comparingInt(InserterCardCache::getPriority).reversed());
    }

    public List<InserterCardCache> getPossibleInserters(ExtractorCardCache extractorCardCache, ItemStack stack) {
        ItemStackKey key = new ItemStackKey(stack, true);
        if (this.inserterCache.containsKey(extractorCardCache)) {
            if (this.inserterCache.get(extractorCardCache).containsKey(key)) {
                return this.inserterCache.get(extractorCardCache).get(key);
            }
            List<InserterCardCache> nodes = this.inserterNodes.stream().filter(p -> p.channel == extractorCardCache.channel && p.enabled && p.isStackValidForCard(stack) && p.cardType.equals((Object)extractorCardCache.cardType) && (!p.relativePos.equals(BlockPos.f_121853_) || !p.direction.equals((Object)extractorCardCache.direction) || p.sneaky != extractorCardCache.sneaky)).toList();
            this.inserterCache.get(extractorCardCache).put(key, nodes);
            return nodes;
        }
        List<InserterCardCache> nodes = this.inserterNodes.stream().filter(p -> p.channel == extractorCardCache.channel && p.enabled && p.isStackValidForCard(stack) && p.cardType.equals((Object)extractorCardCache.cardType) && (!p.relativePos.equals(BlockPos.f_121853_) || !p.direction.equals((Object)extractorCardCache.direction) || p.sneaky != extractorCardCache.sneaky)).toList();
        HashMap<ItemStackKey, List<InserterCardCache>> tempMap = new HashMap<ItemStackKey, List<InserterCardCache>>();
        tempMap.put(key, nodes);
        this.inserterCache.put(extractorCardCache, tempMap);
        return nodes;
    }

    public List<InserterCardCache> getPossibleInserters(ExtractorCardCache extractorCardCache, FluidStack stack) {
        FluidStackKey key = new FluidStackKey(stack, true);
        if (this.inserterCacheFluid.containsKey(extractorCardCache)) {
            if (this.inserterCacheFluid.get(extractorCardCache).containsKey(key)) {
                return this.inserterCacheFluid.get(extractorCardCache).get(key);
            }
            List<InserterCardCache> nodes = this.inserterNodes.stream().filter(p -> p.channel == extractorCardCache.channel && p.enabled && p.isStackValidForCard(stack) && p.cardType.equals((Object)extractorCardCache.cardType) && (!p.relativePos.equals(BlockPos.f_121853_) || !p.direction.equals((Object)extractorCardCache.direction))).toList();
            this.inserterCacheFluid.get(extractorCardCache).put(key, nodes);
            return nodes;
        }
        List<InserterCardCache> nodes = this.inserterNodes.stream().filter(p -> p.channel == extractorCardCache.channel && p.enabled && p.isStackValidForCard(stack) && p.cardType.equals((Object)extractorCardCache.cardType) && (!p.relativePos.equals(BlockPos.f_121853_) || !p.direction.equals((Object)extractorCardCache.direction))).toList();
        HashMap<FluidStackKey, List<InserterCardCache>> tempMap = new HashMap<FluidStackKey, List<InserterCardCache>>();
        tempMap.put(key, nodes);
        this.inserterCacheFluid.put(extractorCardCache, tempMap);
        return nodes;
    }

    public List<InserterCardCache> getChannelMatchInserters(ExtractorCardCache extractorCardCache) {
        if (this.channelOnlyCache.containsKey(extractorCardCache)) {
            return this.channelOnlyCache.get(extractorCardCache);
        }
        List<InserterCardCache> nodes = this.inserterNodes.stream().filter(p -> p.channel == extractorCardCache.channel && p.enabled && (!p.relativePos.equals(BlockPos.f_121853_) || !p.direction.equals((Object)extractorCardCache.direction) || !p.cardType.equals((Object)extractorCardCache.cardType))).toList();
        this.channelOnlyCache.put(extractorCardCache, nodes);
        return nodes;
    }

    public boolean chunksLoaded(DimBlockPos nodePos, BlockPos destinationPos) {
        assert (nodePos.getLevel(this.f_58857_.m_7654_()) != null);
        if (!nodePos.getLevel(this.f_58857_.m_7654_()).m_46749_(nodePos.blockPos)) {
            return false;
        }
        return nodePos.getLevel(this.f_58857_.m_7654_()).m_46749_(destinationPos);
    }

    public int getNextRR(ExtractorCardCache extractorCardCache, List<InserterCardCache> inserterCardCaches) {
        int currentRR;
        int nextRR = this.roundRobinMap.containsKey(extractorCardCache) ? ((currentRR = this.roundRobinMap.get(extractorCardCache).intValue()) + 1 >= inserterCardCaches.size() ? 0 : currentRR + 1) : 0;
        this.roundRobinMap.put(extractorCardCache, nextRR);
        return nextRR;
    }

    public int getRR(ExtractorCardCache extractorCardCache) {
        if (this.roundRobinMap.containsKey(extractorCardCache)) {
            return this.roundRobinMap.get(extractorCardCache);
        }
        this.roundRobinMap.put(extractorCardCache, 0);
        return 0;
    }

    public List<InserterCardCache> applyRR(ExtractorCardCache extractorCardCache, List<InserterCardCache> inserterCardCaches, int nextRR) {
        ArrayList<List<InserterCardCache>> lists = new ArrayList<List<InserterCardCache>>(inserterCardCaches.stream().collect(Collectors.partitioningBy(s -> inserterCardCaches.indexOf(s) >= nextRR)).values());
        ((List)lists.get(1)).addAll((Collection)lists.get(0));
        return (List)lists.get(1);
    }

    public boolean extractItem(ExtractorCardCache extractorCardCache, IItemHandler fromInventory, ItemStack extractStack) {
        TransferResult extractResults = ItemHandlerUtil.extractItemWithSlots(this, fromInventory, extractStack, extractStack.m_41613_(), true, true, extractorCardCache);
        int amtNeeded = extractResults.getTotalItemCounts();
        boolean exactMode = extractorCardCache.exact;
        if (amtNeeded != extractorCardCache.extractAmt && exactMode) {
            return false;
        }
        extractStack.m_41764_(amtNeeded);
        TransferResult insertResults = new TransferResult();
        List<InserterCardCache> inserterCardCaches = this.getPossibleInserters(extractorCardCache, extractStack);
        int roundRobin = -1;
        if (extractorCardCache.roundRobin != 0) {
            roundRobin = this.getRR(extractorCardCache);
            inserterCardCaches = this.applyRR(extractorCardCache, inserterCardCaches, roundRobin);
        }
        int amtStillNeeded = amtNeeded;
        for (InserterCardCache inserterCardCache : inserterCardCaches) {
            LaserNodeItemHandler laserNodeItemHandler = this.getLaserNodeHandlerItem(inserterCardCache);
            if (laserNodeItemHandler == null) continue;
            TransferResult thisResult = ItemHandlerUtil.insertItemWithSlots(laserNodeItemHandler.be, laserNodeItemHandler.handler, extractStack, 0, true, extractorCardCache.isCompareNBT, true, inserterCardCache);
            if (extractorCardCache.roundRobin == 2 && thisResult.getTotalItemCounts() < amtStillNeeded) {
                return false;
            }
            if (thisResult.results.isEmpty()) {
                this.getNextRR(extractorCardCache, inserterCardCaches);
                continue;
            }
            insertResults.addResult(thisResult);
            insertResults.remainingStack = ItemStack.f_41583_;
            int amtFit = thisResult.getTotalItemCounts();
            if ((amtStillNeeded -= amtFit) == 0) break;
            extractStack.m_41764_(amtStillNeeded);
        }
        if (amtStillNeeded == amtNeeded || amtStillNeeded != 0 && exactMode) {
            return false;
        }
        extractStack.m_41764_(amtNeeded - amtStillNeeded);
        for (TransferResult.Result result : insertResults.results) {
            ItemStack tempStack = extractStack.m_41620_(result.itemStack.m_41613_());
            ItemStack returnedStack = result.insertHandler.insertItem(result.insertSlot, tempStack, true);
            if (!returnedStack.m_41619_()) break;
            int amtToExtract = tempStack.m_41613_();
            for (TransferResult.Result extractResult : extractResults.results) {
                int amtToExtractThis = Math.min(amtToExtract, extractResult.itemStack.m_41613_());
                ItemStack extractedStack = extractResult.extractHandler.extractItem(extractResult.extractSlot, amtToExtractThis, false);
                if (extractResult.itemStack.m_41613_() == extractedStack.m_41613_()) {
                    extractResults.results.remove(extractResult);
                } else {
                    extractResult.itemStack.m_41620_(extractedStack.m_41613_());
                }
                if ((amtToExtract -= extractedStack.m_41613_()) != 0) continue;
                break;
            }
            result.insertHandler.insertItem(result.insertSlot, tempStack, false);
            if (result.inserterCardCache == null) continue;
            this.drawParticles(tempStack, extractorCardCache.direction, this, result.toBE, result.inserterCardCache.direction, extractorCardCache.cardSlot, result.inserterCardCache.cardSlot);
        }
        if (extractorCardCache.roundRobin != 0) {
            this.getNextRR(extractorCardCache, inserterCardCaches);
        }
        return true;
    }

    public boolean updateRedstoneFromSensor(boolean filterMatched, byte redstoneChannel, NodeSideCache nodeSideCache) {
        byte newRedstoneStrength;
        byte currentRedstoneFromNetwork = nodeSideCache.myRedstoneFromSensors.get(redstoneChannel);
        byte by = newRedstoneStrength = filterMatched ? (byte)15 : 0;
        if (newRedstoneStrength == 0) {
            nodeSideCache.myRedstoneFromSensors.remove(redstoneChannel);
        } else {
            nodeSideCache.myRedstoneFromSensors.put(redstoneChannel, newRedstoneStrength);
        }
        return currentRedstoneFromNetwork != newRedstoneStrength;
    }

    public boolean senseItems(SensorCardCache sensorCardCache) {
        BlockPos adjacentPos = this.m_58899_().m_121945_(sensorCardCache.direction);
        assert (this.f_58857_ != null);
        if (!this.f_58857_.m_46749_(adjacentPos)) {
            return false;
        }
        ItemStack filter = sensorCardCache.filterCard;
        boolean andMode = BaseCard.getAnd(sensorCardCache.cardItem);
        boolean filterMatched = false;
        NodeSideCache nodeSideCache = this.nodeSideCaches[sensorCardCache.direction.ordinal()];
        if (filter.m_41619_()) {
            if (this.updateRedstoneFromSensor(false, sensorCardCache.redstoneChannel, nodeSideCache)) {
                this.rendersChecked = false;
                this.clearCachedInventories();
                this.redstoneChecked = false;
            }
            return false;
        }
        IItemHandler adjacentInventory = (IItemHandler)this.getAttachedInventory(sensorCardCache.direction, sensorCardCache.sneaky).orElse((Object)this.EMPTY);
        ItemHandlerUtil.InventoryCounts inventoryCounts = new ItemHandlerUtil.InventoryCounts(adjacentInventory, sensorCardCache.isCompareNBT);
        if (filter.m_41720_() instanceof FilterMod) {
            List filteredItemsListOriginal = sensorCardCache.filteredItems;
            ArrayList filteredItemsList = new ArrayList(filteredItemsListOriginal);
            List itemStacksInChest = inventoryCounts.getItemCounts().values().stream().toList();
            block0: for (ItemStack stack : itemStacksInChest) {
                for (ItemStack testStack : filteredItemsListOriginal) {
                    if (!stack.m_41720_().getCreatorModId(stack).equals(testStack.m_41720_().getCreatorModId(testStack))) continue;
                    filteredItemsList.remove(testStack);
                    if (andMode) continue;
                    break block0;
                }
            }
            filterMatched = andMode ? filteredItemsList.size() == 0 : filteredItemsList.size() < filteredItemsListOriginal.size();
        } else if (filter.m_41720_() instanceof FilterBasic) {
            List filteredItemsList = sensorCardCache.filteredItems;
            boolean allMatched = true;
            for (ItemStack itemStack : filteredItemsList) {
                int amtHad = inventoryCounts.getCount(itemStack);
                if (amtHad > 0) {
                    if (andMode) continue;
                    filterMatched = true;
                    break;
                }
                if (!andMode) continue;
                allMatched = false;
                break;
            }
            if (andMode && !filteredItemsList.isEmpty()) {
                filterMatched = allMatched;
            }
        } else if (filter.m_41720_() instanceof FilterCount) {
            List filteredItemsList = sensorCardCache.filteredItems;
            boolean allMatched = true;
            for (ItemStack itemStack : filteredItemsList) {
                int amtHad = inventoryCounts.getCount(itemStack);
                if (amtHad < itemStack.m_41613_() || sensorCardCache.exact && amtHad > itemStack.m_41613_()) {
                    if (!andMode) continue;
                    allMatched = false;
                    break;
                }
                if (andMode) continue;
                filterMatched = true;
                break;
            }
            if (andMode && !filteredItemsList.isEmpty()) {
                filterMatched = allMatched;
            }
        } else if (filter.m_41720_() instanceof FilterTag) {
            List tags = sensorCardCache.filterTags;
            int tagsToMatch = tags.size();
            List itemStacksInChest = inventoryCounts.getItemCounts().values().stream().toList();
            block4: for (ItemStack itemStack : itemStacksInChest) {
                for (TagKey tagKey : itemStack.m_41720_().m_204114_().m_203616_().toList()) {
                    String itemTag = tagKey.f_203868_().toString().toLowerCase(Locale.ROOT);
                    if (!tags.contains(itemTag)) continue;
                    tags.remove(itemTag);
                    if (andMode) continue;
                    break block4;
                }
            }
            if (andMode) {
                filterMatched = tags.size() == 0;
            } else {
                boolean bl = filterMatched = tags.size() < tagsToMatch;
            }
        }
        if (this.updateRedstoneFromSensor(filterMatched, sensorCardCache.redstoneChannel, nodeSideCache)) {
            this.rendersChecked = false;
            this.clearCachedInventories();
            this.redstoneChecked = false;
        }
        return true;
    }

    public boolean senseFluids(SensorCardCache sensorCardCache) {
        BlockPos adjacentPos = this.m_58899_().m_121945_(sensorCardCache.direction);
        assert (this.f_58857_ != null);
        if (!this.f_58857_.m_46749_(adjacentPos)) {
            return false;
        }
        NodeSideCache nodeSideCache = this.nodeSideCaches[sensorCardCache.direction.ordinal()];
        Optional adjacentTankOptional = this.getAttachedFluidTank(sensorCardCache.direction, sensorCardCache.sneaky).resolve();
        if (adjacentTankOptional.isEmpty()) {
            if (this.updateRedstoneFromSensor(false, sensorCardCache.redstoneChannel, nodeSideCache)) {
                this.rendersChecked = false;
                this.clearCachedInventories();
                this.redstoneChecked = false;
            }
            return false;
        }
        IFluidHandler adacentTank = (IFluidHandler)adjacentTankOptional.get();
        ItemStack filter = sensorCardCache.filterCard;
        boolean andMode = BaseCard.getAnd(sensorCardCache.cardItem);
        boolean filterMatched = false;
        if (filter.m_41619_()) {
            if (this.updateRedstoneFromSensor(false, sensorCardCache.redstoneChannel, nodeSideCache)) {
                this.rendersChecked = false;
                this.clearCachedInventories();
                this.redstoneChecked = false;
            }
            return false;
        }
        if (filter.m_41720_() instanceof FilterBasic) {
            List<FluidStack> filteredFluids = sensorCardCache.getFilteredFluids();
            ArrayList<FluidStack> filteredFluidsOriginal = new ArrayList<FluidStack>(filteredFluids);
            block0: for (FluidStack fluidStack : filteredFluidsOriginal) {
                for (int tank = 0; tank < adacentTank.getTanks(); ++tank) {
                    FluidStack stackInTank = adacentTank.getFluidInTank(tank);
                    if (!stackInTank.isFluidEqual(fluidStack)) continue;
                    filteredFluids.remove(fluidStack);
                    if (!andMode) break block0;
                }
            }
            filterMatched = andMode ? filteredFluids.size() == 0 : filteredFluids.size() < filteredFluidsOriginal.size();
        } else if (filter.m_41720_() instanceof FilterCount) {
            List<FluidStack> filteredFluids = sensorCardCache.getFilteredFluids();
            ArrayList<FluidStack> filteredFluidsOriginal = new ArrayList<FluidStack>(filteredFluids);
            block2: for (FluidStack fluidStack : filteredFluidsOriginal) {
                int desiredAmt = sensorCardCache.getFilterAmt(fluidStack);
                for (int tank = 0; tank < adacentTank.getTanks(); ++tank) {
                    int amtHad;
                    FluidStack stackInTank = adacentTank.getFluidInTank(tank);
                    if (!stackInTank.isFluidEqual(fluidStack) || (amtHad = stackInTank.getAmount()) < desiredAmt || sensorCardCache.exact && amtHad > desiredAmt) continue;
                    filteredFluids.remove(fluidStack);
                    if (!andMode) break block2;
                }
            }
            filterMatched = andMode ? filteredFluids.size() == 0 : filteredFluids.size() < filteredFluidsOriginal.size();
        } else if (filter.m_41720_() instanceof FilterTag) {
            List<String> tags = sensorCardCache.getFilterTags();
            int tagsToMatch = tags.size();
            block4: for (int tank = 0; tank < adacentTank.getTanks(); ++tank) {
                FluidStack stackInTank = adacentTank.getFluidInTank(tank);
                for (TagKey tagKey : stackInTank.getFluid().m_205069_().m_203616_().toList()) {
                    String fluidTag = tagKey.f_203868_().toString().toLowerCase(Locale.ROOT);
                    if (!tags.contains(fluidTag)) continue;
                    tags.remove(fluidTag);
                    if (andMode) continue;
                    break block4;
                }
            }
            if (andMode) {
                filterMatched = tags.size() == 0;
            } else {
                boolean bl = filterMatched = tags.size() < tagsToMatch;
            }
        }
        if (this.updateRedstoneFromSensor(filterMatched, sensorCardCache.redstoneChannel, nodeSideCache)) {
            this.rendersChecked = false;
            this.clearCachedInventories();
            this.redstoneChecked = false;
        }
        return true;
    }

    public boolean senseEnergy(SensorCardCache sensorCardCache) {
        BlockPos adjacentPos = this.m_58899_().m_121945_(sensorCardCache.direction);
        assert (this.f_58857_ != null);
        if (!this.f_58857_.m_46749_(adjacentPos)) {
            return false;
        }
        Optional adjacentEnergyOptional = this.getAttachedEnergyTank(sensorCardCache.direction, sensorCardCache.sneaky).resolve();
        NodeSideCache nodeSideCache = this.nodeSideCaches[sensorCardCache.direction.ordinal()];
        if (adjacentEnergyOptional.isEmpty()) {
            if (this.updateRedstoneFromSensor(false, sensorCardCache.redstoneChannel, nodeSideCache)) {
                this.rendersChecked = false;
                this.clearCachedInventories();
                this.redstoneChecked = false;
            }
            return false;
        }
        IEnergyStorage adjacentEnergy = (IEnergyStorage)adjacentEnergyOptional.get();
        boolean filterMatched = false;
        int desired = (int)((float)adjacentEnergy.getMaxEnergyStored() * ((float)sensorCardCache.insertLimit / 100.0f));
        int amtHad = adjacentEnergy.getEnergyStored();
        filterMatched = amtHad >= desired && (!sensorCardCache.exact || amtHad <= desired);
        if (this.updateRedstoneFromSensor(filterMatched, sensorCardCache.redstoneChannel, nodeSideCache)) {
            this.rendersChecked = false;
            this.clearCachedInventories();
            this.redstoneChecked = false;
        }
        return true;
    }

    public boolean sendItems(ExtractorCardCache extractorCardCache) {
        BlockPos adjacentPos = this.m_58899_().m_121945_(extractorCardCache.direction);
        assert (this.f_58857_ != null);
        if (!this.f_58857_.m_46749_(adjacentPos)) {
            return false;
        }
        IItemHandler adjacentInventory = (IItemHandler)this.getAttachedInventory(extractorCardCache.direction, extractorCardCache.sneaky).orElse((Object)this.EMPTY);
        ItemHandlerUtil.InventoryCounts inventoryCounts = new ItemHandlerUtil.InventoryCounts();
        if (extractorCardCache.filterCard.m_41720_() instanceof FilterCount) {
            inventoryCounts = new ItemHandlerUtil.InventoryCounts(adjacentInventory, extractorCardCache.isCompareNBT);
        }
        for (int slot = 0; slot < adjacentInventory.getSlots(); ++slot) {
            ItemStack stackInSlot = adjacentInventory.getStackInSlot(slot);
            if (stackInSlot.m_41619_() || !extractorCardCache.isStackValidForCard(stackInSlot)) continue;
            ItemStack extractStack = stackInSlot.m_41777_();
            extractStack.m_41764_(extractorCardCache.extractAmt);
            if (extractorCardCache.filterCard.m_41720_() instanceof FilterCount) {
                int amtInInv;
                int amtAllowedToRemove;
                int filterCount = extractorCardCache.getFilterAmt(extractStack);
                if (filterCount <= 0 || (amtAllowedToRemove = (amtInInv = inventoryCounts.getCount(extractStack)) - filterCount) <= 0) continue;
                int amtRemaining = Math.min(extractStack.m_41613_(), amtAllowedToRemove);
                extractStack.m_41764_(amtRemaining);
            }
            if (!this.extractItem(extractorCardCache, adjacentInventory, extractStack)) continue;
            return true;
        }
        return false;
    }

    public boolean extractFluidStack(ExtractorCardCache extractorCardCache, IFluidHandler fromInventory, FluidStack extractStack) {
        int totalAmtNeeded = extractStack.getAmount();
        int amtToExtract = extractStack.getAmount();
        List<InserterCardCache> inserterCardCaches = this.getPossibleInserters(extractorCardCache, extractStack);
        int roundRobin = -1;
        boolean foundAnything = false;
        if (extractorCardCache.roundRobin != 0) {
            roundRobin = this.getRR(extractorCardCache);
            inserterCardCaches = this.applyRR(extractorCardCache, inserterCardCaches, roundRobin);
        }
        for (InserterCardCache inserterCardCache : inserterCardCaches) {
            LaserNodeFluidHandler laserNodeFluidHandler = this.getLaserNodeHandlerFluid(inserterCardCache);
            if (laserNodeFluidHandler == null) continue;
            IFluidHandler handler = laserNodeFluidHandler.handler;
            if (inserterCardCache.filterCard.m_41720_() instanceof FilterCount) {
                int filterCount = inserterCardCache.getFilterAmt(extractStack);
                for (int tank = 0; tank < handler.getTanks(); ++tank) {
                    int currentAmt;
                    int neededAmt;
                    FluidStack fluidStack = handler.getFluidInTank(tank);
                    if (!fluidStack.isEmpty() && !fluidStack.isFluidEqual(extractStack) || (neededAmt = filterCount - (currentAmt = fluidStack.getAmount())) >= extractStack.getAmount()) continue;
                    amtToExtract = neededAmt;
                    break;
                }
            }
            if (amtToExtract == 0) {
                amtToExtract = totalAmtNeeded;
                continue;
            }
            extractStack.setAmount(amtToExtract);
            int amtFit = handler.fill(extractStack, IFluidHandler.FluidAction.SIMULATE);
            if (amtFit == 0) {
                if (extractorCardCache.roundRobin == 2) {
                    return false;
                }
                if (extractorCardCache.roundRobin == 0) continue;
                this.getNextRR(extractorCardCache, inserterCardCaches);
                continue;
            }
            extractStack.setAmount(amtFit);
            FluidStack drainedStack = fromInventory.drain(extractStack, IFluidHandler.FluidAction.EXECUTE);
            if (drainedStack.isEmpty()) continue;
            foundAnything = true;
            handler.fill(drainedStack, IFluidHandler.FluidAction.EXECUTE);
            this.drawParticlesFluid(drainedStack, extractorCardCache.direction, extractorCardCache.be, inserterCardCache.be, inserterCardCache.direction, extractorCardCache.cardSlot, inserterCardCache.cardSlot);
            amtToExtract = totalAmtNeeded -= drainedStack.getAmount();
            if (extractorCardCache.roundRobin != 0) {
                this.getNextRR(extractorCardCache, inserterCardCaches);
            }
            if (totalAmtNeeded != 0) continue;
            return true;
        }
        return foundAnything;
    }

    public boolean extractFluidStackExact(ExtractorCardCache extractorCardCache, IFluidHandler fromInventory, FluidStack extractStack) {
        int totalAmtNeeded = extractStack.getAmount();
        int amtToExtract = extractStack.getAmount();
        FluidStack testDrain = fromInventory.drain(extractStack, IFluidHandler.FluidAction.SIMULATE);
        if (testDrain.getAmount() < totalAmtNeeded) {
            return false;
        }
        List<InserterCardCache> inserterCardCaches = this.getPossibleInserters(extractorCardCache, extractStack);
        int roundRobin = -1;
        if (extractorCardCache.roundRobin != 0) {
            roundRobin = this.getRR(extractorCardCache);
            inserterCardCaches = this.applyRR(extractorCardCache, inserterCardCaches, roundRobin);
        }
        Object2IntOpenHashMap insertHandlers = new Object2IntOpenHashMap();
        for (InserterCardCache inserterCardCache : inserterCardCaches) {
            LaserNodeFluidHandler laserNodeFluidHandler = this.getLaserNodeHandlerFluid(inserterCardCache);
            if (laserNodeFluidHandler == null) continue;
            IFluidHandler handler = laserNodeFluidHandler.handler;
            if (inserterCardCache.filterCard.m_41720_() instanceof FilterCount) {
                int filterCount = inserterCardCache.getFilterAmt(extractStack);
                for (int tank = 0; tank < handler.getTanks(); ++tank) {
                    int currentAmt;
                    int neededAmt;
                    FluidStack fluidStack = handler.getFluidInTank(tank);
                    if (!fluidStack.isEmpty() && !fluidStack.isFluidEqual(extractStack) || (neededAmt = filterCount - (currentAmt = fluidStack.getAmount())) >= totalAmtNeeded) continue;
                    amtToExtract = neededAmt;
                    break;
                }
            }
            if (amtToExtract == 0) {
                amtToExtract = totalAmtNeeded;
                continue;
            }
            extractStack.setAmount(amtToExtract);
            int amtFit = handler.fill(extractStack, IFluidHandler.FluidAction.SIMULATE);
            if (amtFit == 0) {
                if (extractorCardCache.roundRobin == 2) {
                    return false;
                }
                if (extractorCardCache.roundRobin == 0) continue;
                this.getNextRR(extractorCardCache, inserterCardCaches);
                continue;
            }
            extractStack.setAmount(amtFit);
            FluidStack drainedStack = fromInventory.drain(extractStack, IFluidHandler.FluidAction.SIMULATE);
            if (drainedStack.isEmpty()) continue;
            insertHandlers.put(inserterCardCache, drainedStack.getAmount());
            amtToExtract = totalAmtNeeded -= drainedStack.getAmount();
            if (extractorCardCache.roundRobin != 0) {
                this.getNextRR(extractorCardCache, inserterCardCaches);
            }
            if (totalAmtNeeded != 0) continue;
            break;
        }
        if (totalAmtNeeded > 0) {
            return false;
        }
        for (Map.Entry entry : insertHandlers.entrySet()) {
            InserterCardCache inserterCardCache = (InserterCardCache)entry.getKey();
            LaserNodeFluidHandler laserNodeFluidHandler = this.getLaserNodeHandlerFluid(inserterCardCache);
            IFluidHandler handler = laserNodeFluidHandler.handler;
            extractStack.setAmount(((Integer)entry.getValue()).intValue());
            FluidStack drainedStack = fromInventory.drain(extractStack, IFluidHandler.FluidAction.EXECUTE);
            handler.fill(drainedStack, IFluidHandler.FluidAction.EXECUTE);
            this.drawParticlesFluid(drainedStack, extractorCardCache.direction, extractorCardCache.be, inserterCardCache.be, inserterCardCache.direction, extractorCardCache.cardSlot, inserterCardCache.cardSlot);
        }
        return true;
    }

    public boolean sendFluids(ExtractorCardCache extractorCardCache) {
        BlockPos adjacentPos = this.m_58899_().m_121945_(extractorCardCache.direction);
        assert (this.f_58857_ != null);
        if (!this.f_58857_.m_46749_(adjacentPos)) {
            return false;
        }
        LazyOptional<IFluidHandler> adjacentTankOptional = this.getAttachedFluidTank(extractorCardCache.direction, extractorCardCache.sneaky);
        if (!adjacentTankOptional.isPresent()) {
            return false;
        }
        IFluidHandler adjacentTank = (IFluidHandler)adjacentTankOptional.resolve().get();
        for (int tank = 0; tank < adjacentTank.getTanks(); ++tank) {
            FluidStack fluidStack = adjacentTank.getFluidInTank(tank);
            if (fluidStack.isEmpty() || !extractorCardCache.isStackValidForCard(fluidStack)) continue;
            FluidStack extractStack = fluidStack.copy();
            extractStack.setAmount(extractorCardCache.extractAmt);
            if (extractorCardCache.filterCard.m_41720_() instanceof FilterCount) {
                int amtInInv;
                int amtAllowedToRemove;
                int filterCount = extractorCardCache.getFilterAmt(extractStack);
                if (filterCount <= 0 || (amtAllowedToRemove = (amtInInv = fluidStack.getAmount()) - filterCount) <= 0) continue;
                int amtRemaining = Math.min(extractStack.getAmount(), amtAllowedToRemove);
                extractStack.setAmount(amtRemaining);
            }
            if (!(extractorCardCache.exact ? this.extractFluidStackExact(extractorCardCache, adjacentTank, extractStack) : this.extractFluidStack(extractorCardCache, adjacentTank, extractStack))) continue;
            return true;
        }
        return false;
    }

    public int receiveEnergy(Direction direction, int receiveAmt, boolean simulate) {
        int totalAmtNeeded = receiveAmt;
        int totalAmtSent = 0;
        NodeSideCache nodeSideCache = this.nodeSideCaches[direction.ordinal()];
        int countCardsHandled = 0;
        for (ExtractorCardCache extractorCardCache : nodeSideCache.extractorCardCaches) {
            if (!extractorCardCache.enabled) continue;
            if (countCardsHandled > nodeSideCache.overClocker) {
                return totalAmtSent;
            }
            if (extractorCardCache instanceof StockerCardCache || !extractorCardCache.cardType.equals((Object)BaseCard.CardType.ENERGY)) continue;
            int amtSent = this.sendReceivedEnergy(extractorCardCache, totalAmtNeeded, simulate);
            if (amtSent > 0) {
                ++countCardsHandled;
            }
            totalAmtSent += amtSent;
            if ((totalAmtNeeded -= amtSent) > 0) continue;
            break;
        }
        return totalAmtSent;
    }

    public int sendReceivedEnergy(ExtractorCardCache extractorCardCache, int receiveAmt, boolean simulate) {
        int totalAmtNeeded = Math.min(extractorCardCache.extractAmt, receiveAmt);
        int totalFit = 0;
        List<InserterCardCache> inserterCardCaches = this.getChannelMatchInserters(extractorCardCache);
        int roundRobin = -1;
        if (extractorCardCache.roundRobin != 0) {
            roundRobin = this.getRR(extractorCardCache);
            inserterCardCaches = this.applyRR(extractorCardCache, inserterCardCaches, roundRobin);
        }
        for (InserterCardCache inserterCardCache : inserterCardCaches) {
            BlockEntity targetBE;
            LaserNodeEnergyHandler laserNodeEnergyHandler = this.getLaserNodeHandlerEnergy(inserterCardCache);
            if (laserNodeEnergyHandler == null || (targetBE = this.f_58857_.m_7702_(laserNodeEnergyHandler.be.m_58899_().m_121945_(inserterCardCache.direction))) instanceof LaserNodeBE) continue;
            IEnergyStorage energyStorage = laserNodeEnergyHandler.handler;
            int desired = inserterCardCache.insertLimit != 100 ? (int)((float)energyStorage.getMaxEnergyStored() * ((float)inserterCardCache.insertLimit / 100.0f)) - energyStorage.getEnergyStored() : receiveAmt;
            if (desired <= 0) continue;
            int amtToTry = Math.min(desired, totalAmtNeeded);
            int amtFit = energyStorage.receiveEnergy(amtToTry, true);
            if (amtFit == 0) {
                if (extractorCardCache.roundRobin == 2) {
                    return totalFit;
                }
                if (extractorCardCache.roundRobin == 0) continue;
                this.getNextRR(extractorCardCache, inserterCardCaches);
                continue;
            }
            totalAmtNeeded -= amtFit;
            totalFit += amtFit;
            if (!simulate) {
                energyStorage.receiveEnergy(amtFit, false);
            }
            if (extractorCardCache.roundRobin != 0) {
                this.getNextRR(extractorCardCache, inserterCardCaches);
            }
            if (totalAmtNeeded != 0) continue;
            return totalFit;
        }
        return totalFit;
    }

    public boolean extractEnergy(ExtractorCardCache extractorCardCache, IEnergyStorage fromEnergyTank, int extractAmt) {
        int totalAmtNeeded = extractAmt;
        List<InserterCardCache> inserterCardCaches = this.getChannelMatchInserters(extractorCardCache);
        int roundRobin = -1;
        boolean foundAnything = false;
        if (extractorCardCache.roundRobin != 0) {
            roundRobin = this.getRR(extractorCardCache);
            inserterCardCaches = this.applyRR(extractorCardCache, inserterCardCaches, roundRobin);
        }
        for (InserterCardCache inserterCardCache : inserterCardCaches) {
            LaserNodeEnergyHandler laserNodeEnergyHandler = this.getLaserNodeHandlerEnergy(inserterCardCache);
            if (laserNodeEnergyHandler == null) continue;
            IEnergyStorage energyStorage = laserNodeEnergyHandler.handler;
            int desired = inserterCardCache.insertLimit != 100 ? (int)((float)energyStorage.getMaxEnergyStored() * ((float)inserterCardCache.insertLimit / 100.0f)) - energyStorage.getEnergyStored() : extractAmt;
            if (desired <= 0) continue;
            int amtToTry = Math.min(desired, totalAmtNeeded);
            int amtFit = energyStorage.receiveEnergy(amtToTry, true);
            if (amtFit == 0) {
                if (extractorCardCache.roundRobin == 2) {
                    return false;
                }
                if (extractorCardCache.roundRobin == 0) continue;
                this.getNextRR(extractorCardCache, inserterCardCaches);
                continue;
            }
            int amtDrained = fromEnergyTank.extractEnergy(amtFit, false);
            if (amtDrained == 0) continue;
            foundAnything = true;
            energyStorage.receiveEnergy(amtDrained, false);
            totalAmtNeeded -= amtDrained;
            if (extractorCardCache.roundRobin != 0) {
                this.getNextRR(extractorCardCache, inserterCardCaches);
            }
            if (totalAmtNeeded != 0) continue;
            return true;
        }
        return foundAnything;
    }

    public boolean extractEnergyExact(ExtractorCardCache extractorCardCache, IEnergyStorage fromEnergyTank, int extractAmt) {
        int totalAmtNeeded = extractAmt;
        List<InserterCardCache> inserterCardCaches = this.getChannelMatchInserters(extractorCardCache);
        int roundRobin = -1;
        if (extractorCardCache.roundRobin != 0) {
            roundRobin = this.getRR(extractorCardCache);
            inserterCardCaches = this.applyRR(extractorCardCache, inserterCardCaches, roundRobin);
        }
        Object2IntOpenHashMap insertHandlers = new Object2IntOpenHashMap();
        for (InserterCardCache inserterCardCache : inserterCardCaches) {
            LaserNodeEnergyHandler laserNodeEnergyHandler = this.getLaserNodeHandlerEnergy(inserterCardCache);
            if (laserNodeEnergyHandler == null) continue;
            IEnergyStorage energyStorage = laserNodeEnergyHandler.handler;
            int desired = inserterCardCache.insertLimit != 100 ? (int)((float)energyStorage.getMaxEnergyStored() * ((float)inserterCardCache.insertLimit / 100.0f)) - energyStorage.getEnergyStored() : extractAmt;
            if (desired <= 0) continue;
            int amtToTry = Math.min(desired, totalAmtNeeded);
            int amtFit = energyStorage.receiveEnergy(amtToTry, true);
            if (amtFit == 0) {
                if (extractorCardCache.roundRobin == 2) {
                    return false;
                }
                if (extractorCardCache.roundRobin == 0) continue;
                this.getNextRR(extractorCardCache, inserterCardCaches);
                continue;
            }
            int amtDrained = fromEnergyTank.extractEnergy(amtFit, true);
            if (amtDrained == 0) continue;
            insertHandlers.put(inserterCardCache, amtDrained);
            totalAmtNeeded -= amtDrained;
            if (extractorCardCache.roundRobin != 0) {
                this.getNextRR(extractorCardCache, inserterCardCaches);
            }
            if (totalAmtNeeded != 0) continue;
            break;
        }
        if (totalAmtNeeded > 0) {
            return false;
        }
        for (Map.Entry entry : insertHandlers.entrySet()) {
            InserterCardCache inserterCardCache = (InserterCardCache)entry.getKey();
            LaserNodeEnergyHandler laserNodeEnergyHandler = this.getLaserNodeHandlerEnergy(inserterCardCache);
            IEnergyStorage energyStorage = laserNodeEnergyHandler.handler;
            int actualRemoved = fromEnergyTank.extractEnergy(((Integer)entry.getValue()).intValue(), false);
            energyStorage.receiveEnergy(actualRemoved, false);
        }
        return true;
    }

    public boolean sendEnergy(ExtractorCardCache extractorCardCache) {
        BlockPos adjacentPos = this.m_58899_().m_121945_(extractorCardCache.direction);
        assert (this.f_58857_ != null);
        if (!this.f_58857_.m_46749_(adjacentPos)) {
            return false;
        }
        Optional adjacentEnergyOptional = this.getAttachedEnergyTank(extractorCardCache.direction, extractorCardCache.sneaky).resolve();
        if (adjacentEnergyOptional.isEmpty()) {
            return false;
        }
        IEnergyStorage adjacentEnergy = (IEnergyStorage)adjacentEnergyOptional.get();
        int desired = (int)((float)adjacentEnergy.getMaxEnergyStored() * ((float)extractorCardCache.extractLimit / 100.0f));
        int extractAmt = Math.min(extractorCardCache.extractAmt, adjacentEnergy.getEnergyStored() - desired);
        if (extractAmt <= 0) {
            return false;
        }
        if (extractorCardCache.exact) {
            return this.extractEnergyExact(extractorCardCache, adjacentEnergy, extractAmt);
        }
        return this.extractEnergy(extractorCardCache, adjacentEnergy, extractAmt);
    }

    public boolean canAnyItemFiltersFit(IItemHandler adjacentInventory, StockerCardCache stockerCardCache) {
        for (ItemStack stack : stockerCardCache.getFilteredItems()) {
            int amountFit = this.testInsertToInventory(adjacentInventory, stack.m_41620_(1));
            if (amountFit <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean canAnyFluidFiltersFit(IFluidHandler adjacentTank, StockerCardCache stockerCardCache) {
        for (FluidStack fluidStack : stockerCardCache.getFilteredFluids()) {
            int amtFit = adjacentTank.fill(fluidStack, IFluidHandler.FluidAction.SIMULATE);
            if (amtFit <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean canFluidFitInTank(IFluidHandler handler, FluidStack fluidStack) {
        return handler.fill(fluidStack, IFluidHandler.FluidAction.SIMULATE) > 0;
    }

    public boolean regulateItemStocker(StockerCardCache stockerCardCache, IItemHandler stockerInventory) {
        ItemHandlerUtil.InventoryCounts stockerInventoryCount = new ItemHandlerUtil.InventoryCounts(stockerInventory, stockerCardCache.isCompareNBT);
        List<ItemStack> filteredItemsList = stockerCardCache.getFilteredItems();
        for (ItemStack itemStack : filteredItemsList) {
            int amtHad = stockerInventoryCount.getCount(itemStack);
            if (amtHad <= itemStack.m_41613_()) continue;
            ItemStack extractStack = itemStack.m_41777_();
            extractStack.m_41764_(Math.min(amtHad - itemStack.m_41613_(), stockerCardCache.extractAmt));
            if (!this.extractItem(stockerCardCache, stockerInventory, extractStack)) continue;
            return true;
        }
        return false;
    }

    public boolean regulateFluidStocker(StockerCardCache stockerCardCache, IFluidHandler stockerTank) {
        List<FluidStack> filteredFluidsList = stockerCardCache.getFilteredFluids();
        for (FluidStack fluidStack : filteredFluidsList) {
            int desiredAmt = stockerCardCache.getFilterAmt(fluidStack);
            int amtHad = 0;
            for (int tank = 0; tank < stockerTank.getTanks(); ++tank) {
                FluidStack stackInTank = stockerTank.getFluidInTank(tank);
                if (!stackInTank.isFluidEqual(fluidStack)) continue;
                amtHad += stackInTank.getAmount();
            }
            if (amtHad <= desiredAmt) continue;
            fluidStack.setAmount(Math.min(amtHad - desiredAmt, stockerCardCache.extractAmt));
            if (!this.extractFluidStack(stockerCardCache, stockerTank, fluidStack)) continue;
            return true;
        }
        return false;
    }

    public boolean regulateEnergyStocker(StockerCardCache stockerCardCache, IEnergyStorage stockerTank) {
        int desired = (int)((float)stockerTank.getMaxEnergyStored() * ((float)stockerCardCache.insertLimit / 100.0f));
        if (desired >= stockerTank.getEnergyStored()) {
            return false;
        }
        int overFlow = Math.min(stockerCardCache.extractAmt, stockerTank.getEnergyStored() - desired);
        return this.extractEnergy(stockerCardCache, stockerTank, overFlow);
    }

    public boolean stockEnergy(StockerCardCache stockerCardCache) {
        BlockPos adjacentPos = this.m_58899_().m_121945_(stockerCardCache.direction);
        assert (this.f_58857_ != null);
        if (!this.f_58857_.m_46749_(adjacentPos)) {
            return false;
        }
        Optional adjacentEnergyOptional = this.getAttachedEnergyTank(stockerCardCache.direction, stockerCardCache.sneaky).resolve();
        if (adjacentEnergyOptional.isEmpty()) {
            return false;
        }
        IEnergyStorage adjacentEnergy = (IEnergyStorage)adjacentEnergyOptional.get();
        if (stockerCardCache.regulate && this.regulateEnergyStocker(stockerCardCache, adjacentEnergy)) {
            return true;
        }
        int desired = (int)((float)adjacentEnergy.getMaxEnergyStored() * ((float)stockerCardCache.insertLimit / 100.0f));
        if (adjacentEnergy.getEnergyStored() >= desired) {
            return false;
        }
        return this.findEnergyForStocker(stockerCardCache, adjacentEnergy);
    }

    public boolean stockFluids(StockerCardCache stockerCardCache) {
        BlockPos adjacentPos = this.m_58899_().m_121945_(stockerCardCache.direction);
        assert (this.f_58857_ != null);
        if (!this.f_58857_.m_46749_(adjacentPos)) {
            return false;
        }
        Optional adjacentTankOptional = this.getAttachedFluidTank(stockerCardCache.direction, stockerCardCache.sneaky).resolve();
        if (adjacentTankOptional.isEmpty()) {
            return false;
        }
        IFluidHandler adacentTank = (IFluidHandler)adjacentTankOptional.get();
        ItemStack filter = stockerCardCache.filterCard;
        if (filter.m_41619_() || !stockerCardCache.isAllowList) {
            return false;
        }
        if (filter.m_41720_() instanceof FilterBasic || filter.m_41720_() instanceof FilterCount) {
            if (stockerCardCache.regulate && filter.m_41720_() instanceof FilterCount && this.regulateFluidStocker(stockerCardCache, adacentTank)) {
                return true;
            }
            if (!this.canAnyFluidFiltersFit(adacentTank, stockerCardCache)) {
                return false;
            }
            boolean foundItems = this.findFluidStackForStocker(stockerCardCache, adacentTank);
            if (foundItems) {
                return true;
            }
        } else if (filter.m_41720_() instanceof FilterTag) {
            // empty if block
        }
        return false;
    }

    public boolean stockItems(StockerCardCache stockerCardCache) {
        BlockPos adjacentPos = this.m_58899_().m_121945_(stockerCardCache.direction);
        assert (this.f_58857_ != null);
        if (!this.f_58857_.m_46749_(adjacentPos)) {
            return false;
        }
        IItemHandler adjacentInventory = (IItemHandler)this.getAttachedInventory(stockerCardCache.direction, stockerCardCache.sneaky).orElse((Object)this.EMPTY);
        ItemStack filter = stockerCardCache.filterCard;
        if (filter.m_41619_() || !stockerCardCache.isAllowList) {
            return false;
        }
        if (filter.m_41720_() instanceof FilterBasic || filter.m_41720_() instanceof FilterCount) {
            if (stockerCardCache.regulate && filter.m_41720_() instanceof FilterCount && this.regulateItemStocker(stockerCardCache, adjacentInventory)) {
                return true;
            }
            if (!this.canAnyItemFiltersFit(adjacentInventory, stockerCardCache)) {
                return false;
            }
            boolean foundItems = this.findItemStackForStocker(stockerCardCache, adjacentInventory);
            if (foundItems) {
                return true;
            }
        } else if (filter.m_41720_() instanceof FilterTag) {
            // empty if block
        }
        return false;
    }

    public ItemStack getStackAtStockerCachePosition(StockerSource checkSource) {
        LaserNodeItemHandler laserNodeItemHandler = this.getLaserNodeHandlerItem(checkSource.inserterCardCache);
        if (laserNodeItemHandler == null) {
            return ItemStack.f_41583_;
        }
        return laserNodeItemHandler.handler.getStackInSlot(checkSource.slot);
    }

    public TransferResult tryStockerCacheCount(StockerCardCache stockerCardCache, ItemStack itemStack, IItemHandler stockerInventory) {
        int lastSlot;
        int origItemsWanted;
        TransferResult extractResult = new TransferResult();
        ItemStackKey itemStackKey = new ItemStackKey(itemStack, stockerCardCache.isCompareNBT);
        StockerRequest stockerRequest = new StockerRequest(stockerCardCache, itemStackKey);
        if (!this.stockerDestinationCache.containsKey(stockerRequest)) {
            return extractResult;
        }
        int itemsStillNeeded = origItemsWanted = itemStack.m_41613_();
        StockerSource checkSource = this.stockerDestinationCache.get(stockerRequest);
        ItemStack stackInSlot = this.getStackAtStockerCachePosition(checkSource);
        if (stackInSlot == null) {
            return extractResult;
        }
        LaserNodeItemHandler laserNodeItemHandler = this.getLaserNodeHandlerItem(checkSource.inserterCardCache);
        if (laserNodeItemHandler == null) {
            return extractResult;
        }
        ItemStackKey stackInSlotKey = new ItemStackKey(stackInSlot, stockerCardCache.isCompareNBT);
        if (stackInSlot.m_41619_()) {
            this.stockerDestinationCache.remove(stockerRequest);
        }
        if (stackInSlotKey.equals(itemStackKey)) {
            int extractAmt = Math.min(itemsStillNeeded, stackInSlot.m_41613_());
            ItemStack extractedItemStack = laserNodeItemHandler.handler.extractItem(checkSource.slot, extractAmt, true);
            itemsStillNeeded -= extractedItemStack.m_41613_();
            if (stackInSlot.m_41613_() - extractedItemStack.m_41613_() == 0) {
                this.stockerDestinationCache.remove(stockerRequest);
            }
            if (itemsStillNeeded == 0) {
                extractResult.addResult(new TransferResult.Result(laserNodeItemHandler.handler, checkSource.slot, checkSource.inserterCardCache, extractedItemStack, laserNodeItemHandler.be, true));
                extractResult.addOtherCard(stockerInventory, -1, stockerCardCache, stockerCardCache.be);
                return extractResult;
            }
        }
        extractResult = ItemHandlerUtil.extractItemWithSlots(laserNodeItemHandler.be, laserNodeItemHandler.handler, itemStack, origItemsWanted, true, stockerCardCache.isCompareNBT, checkSource.inserterCardCache);
        extractResult.addOtherCard(stockerInventory, -1, stockerCardCache, stockerCardCache.be);
        if (!extractResult.results.isEmpty() && laserNodeItemHandler.handler.getStackInSlot(lastSlot = extractResult.results.get((int)(extractResult.results.size() - 1)).extractSlot).m_41613_() - extractResult.results.get((int)(extractResult.results.size() - 1)).itemStack.m_41613_() != 0) {
            this.stockerDestinationCache.put(new StockerRequest(stockerCardCache, itemStackKey), new StockerSource(checkSource.inserterCardCache, lastSlot));
        }
        return extractResult;
    }

    public boolean findEnergyForStocker(StockerCardCache stockerCardCache, IEnergyStorage toEnergyTank) {
        int desired = (int)((float)toEnergyTank.getMaxEnergyStored() * ((float)stockerCardCache.insertLimit / 100.0f));
        int extractAmt = Math.min(stockerCardCache.extractAmt, desired - toEnergyTank.getEnergyStored());
        List<InserterCardCache> inserterCardCaches = this.getChannelMatchInserters(stockerCardCache);
        Object2IntOpenHashMap insertHandlers = new Object2IntOpenHashMap();
        for (InserterCardCache inserterCardCache : inserterCardCaches) {
            IEnergyStorage energyStorage;
            int amtRemoved;
            LaserNodeEnergyHandler laserNodeEnergyHandler = this.getLaserNodeHandlerEnergy(inserterCardCache);
            if (laserNodeEnergyHandler == null || (amtRemoved = (energyStorage = laserNodeEnergyHandler.handler).extractEnergy(extractAmt, true)) == 0) continue;
            int amtInserted = toEnergyTank.receiveEnergy(amtRemoved, true);
            if (amtInserted == 0) {
                return false;
            }
            insertHandlers.put(inserterCardCache, amtInserted);
            if ((extractAmt -= amtInserted) != 0) continue;
            break;
        }
        if (stockerCardCache.exact && extractAmt > 0 || insertHandlers.isEmpty()) {
            return false;
        }
        for (Map.Entry entry : insertHandlers.entrySet()) {
            InserterCardCache inserterCardCache = (InserterCardCache)entry.getKey();
            LaserNodeEnergyHandler laserNodeEnergyHandler = this.getLaserNodeHandlerEnergy(inserterCardCache);
            IEnergyStorage energyStorage = laserNodeEnergyHandler.handler;
            int actualRemoved = energyStorage.extractEnergy(((Integer)entry.getValue()).intValue(), false);
            toEnergyTank.receiveEnergy(actualRemoved, false);
        }
        return false;
    }

    public boolean findFluidStackForStocker(StockerCardCache stockerCardCache, IFluidHandler stockerTank) {
        boolean isCount = stockerCardCache.filterCard.m_41720_() instanceof FilterCount;
        int extractAmt = stockerCardCache.extractAmt;
        CopyOnWriteArrayList<FluidStack> filteredFluidsList = new CopyOnWriteArrayList<FluidStack>(stockerCardCache.getFilteredFluids());
        filteredFluidsList.removeIf(fluidStack -> !this.canFluidFitInTank(stockerTank, (FluidStack)fluidStack));
        if (filteredFluidsList.isEmpty()) {
            return false;
        }
        if (isCount) {
            for (FluidStack fluidStack2 : filteredFluidsList) {
                for (int tank = 0; tank < stockerTank.getTanks(); ++tank) {
                    int n;
                    FluidStack tankStack = stockerTank.getFluidInTank(tank);
                    if (!tankStack.isEmpty() && !tankStack.isFluidEqual(fluidStack2)) continue;
                    int filterAmt = stockerCardCache.getFilterAmt(fluidStack2);
                    int amtNeeded = filterAmt - (n = tankStack.getAmount());
                    if (amtNeeded <= 0) {
                        filteredFluidsList.remove(fluidStack2);
                        continue;
                    }
                    fluidStack2.setAmount(Math.min(amtNeeded, extractAmt));
                }
            }
        }
        if (filteredFluidsList.isEmpty()) {
            return false;
        }
        for (FluidStack fluidStack2 : filteredFluidsList) {
            HashMap<InserterCardCache, FluidStack> insertHandlers = new HashMap<InserterCardCache, FluidStack>();
            if (!isCount) {
                fluidStack2.setAmount(extractAmt);
            }
            int amtNeeded = fluidStack2.getAmount();
            for (InserterCardCache inserterCardCache : this.getChannelMatchInserters(stockerCardCache)) {
                LaserNodeFluidHandler laserNodeFluidHandler;
                if (!inserterCardCache.isStackValidForCard(fluidStack2) || (laserNodeFluidHandler = this.getLaserNodeHandlerFluid(inserterCardCache)) == null) continue;
                fluidStack2.setAmount(amtNeeded);
                IFluidHandler handler = laserNodeFluidHandler.handler();
                FluidStack extractStack = handler.drain(fluidStack2, IFluidHandler.FluidAction.SIMULATE);
                if (extractStack.isEmpty()) continue;
                insertHandlers.put(inserterCardCache, extractStack);
                if ((amtNeeded -= extractStack.getAmount()) != 0) continue;
                break;
            }
            if (insertHandlers.isEmpty() || stockerCardCache.exact && amtNeeded != 0) continue;
            for (Map.Entry entry : insertHandlers.entrySet()) {
                InserterCardCache inserterCardCache = (InserterCardCache)entry.getKey();
                FluidStack insertStack = (FluidStack)entry.getValue();
                LaserNodeFluidHandler laserNodeFluidHandler = this.getLaserNodeHandlerFluid(inserterCardCache);
                IFluidHandler handler = laserNodeFluidHandler.handler;
                int amtFit = stockerTank.fill(insertStack, IFluidHandler.FluidAction.SIMULATE);
                insertStack.setAmount(amtFit);
                FluidStack drainedStack = handler.drain(insertStack, IFluidHandler.FluidAction.EXECUTE);
                stockerTank.fill(drainedStack, IFluidHandler.FluidAction.EXECUTE);
                this.drawParticlesFluid(drainedStack, inserterCardCache.direction, inserterCardCache.be, stockerCardCache.be, stockerCardCache.direction, inserterCardCache.cardSlot, stockerCardCache.cardSlot);
            }
            return true;
        }
        return false;
    }

    public boolean findItemStackForStocker(StockerCardCache stockerCardCache, IItemHandler stockerInventory) {
        boolean isCount = stockerCardCache.filterCard.m_41720_() instanceof FilterCount;
        int extractAmt = stockerCardCache.extractAmt;
        List<ItemStack> filteredItemsList = stockerCardCache.getFilteredItems();
        if (isCount) {
            ItemHandlerUtil.InventoryCounts stockerInventoryCount = new ItemHandlerUtil.InventoryCounts(stockerInventory, stockerCardCache.isCompareNBT);
            ArrayList<ItemStack> tempList = new ArrayList<ItemStack>(filteredItemsList);
            for (ItemStack itemStack : filteredItemsList) {
                int amtHad = stockerInventoryCount.getCount(itemStack);
                if (amtHad >= itemStack.m_41613_()) {
                    tempList.remove(itemStack);
                    continue;
                }
                itemStack.m_41764_(Math.min(itemStack.m_41613_() - amtHad, extractAmt));
            }
            filteredItemsList = tempList;
        }
        if (filteredItemsList.isEmpty()) {
            return false;
        }
        HashMap<InserterCardCache, ItemHandlerUtil.InventoryCounts> stockerInvCaches = new HashMap<InserterCardCache, ItemHandlerUtil.InventoryCounts>();
        for (ItemStack itemStack : filteredItemsList) {
            Object insertedStack;
            if (!isCount) {
                itemStack.m_41764_(extractAmt);
            }
            int origCountNeeded = itemStack.m_41613_();
            TransferResult transferResult = this.tryStockerCacheCount(stockerCardCache, itemStack, stockerInventory);
            if (transferResult.getTotalItemCounts() == origCountNeeded) {
                itemStack.m_41764_(transferResult.getTotalItemCounts());
                insertedStack = ItemHandlerHelper.insertItem((IItemHandler)stockerInventory, (ItemStack)itemStack, (boolean)true);
                int totalInserted = transferResult.getTotalItemCounts() - insertedStack.m_41613_();
                if (totalInserted < transferResult.getTotalItemCounts()) {
                    if (totalInserted == 0 || stockerCardCache.exact) break;
                    for (TransferResult.Result result : transferResult.results) {
                        if (result.itemStack.m_41613_() > totalInserted) {
                            if (totalInserted <= 0) {
                                transferResult.results.remove(result);
                            } else {
                                result.itemStack.m_41764_(totalInserted);
                            }
                        }
                        totalInserted -= result.itemStack.m_41613_();
                    }
                }
                transferResult.doIt();
                return true;
            }
            itemStack.m_41764_(origCountNeeded - transferResult.getTotalItemCounts());
            for (InserterCardCache inserterCardCache : this.getChannelMatchInserters(stockerCardCache)) {
                ItemHandlerUtil.InventoryCounts inventoryCounts;
                LaserNodeItemHandler laserNodeItemHandler;
                if (!inserterCardCache.isStackValidForCard(itemStack) || transferResult.getTotalItemCounts() != 0 && inserterCardCache.equals(transferResult.results.get((int)0).extractorCardCache) || (laserNodeItemHandler = this.getLaserNodeHandlerItem(inserterCardCache)) == null) continue;
                if (stockerInvCaches.containsKey(inserterCardCache)) {
                    inventoryCounts = (ItemHandlerUtil.InventoryCounts)stockerInvCaches.get(inserterCardCache);
                } else {
                    inventoryCounts = new ItemHandlerUtil.InventoryCounts(laserNodeItemHandler.handler, stockerCardCache.isCompareNBT);
                    stockerInvCaches.put(inserterCardCache, inventoryCounts);
                }
                if (inventoryCounts.getCount(itemStack) == 0) continue;
                transferResult.addResult(ItemHandlerUtil.extractItemWithSlots(laserNodeItemHandler.be, laserNodeItemHandler.handler, itemStack, itemStack.m_41613_(), true, stockerCardCache.isCompareNBT, inserterCardCache));
                transferResult.addOtherCard(stockerInventory, -1, stockerCardCache, stockerCardCache.be);
                if (transferResult.getTotalItemCounts() == origCountNeeded) {
                    itemStack.m_41764_(transferResult.getTotalItemCounts());
                    ItemStack insertedStack2 = ItemHandlerHelper.insertItem((IItemHandler)stockerInventory, (ItemStack)itemStack, (boolean)true);
                    int totalInserted = transferResult.getTotalItemCounts() - insertedStack2.m_41613_();
                    if (totalInserted < transferResult.getTotalItemCounts()) {
                        if (totalInserted == 0 || stockerCardCache.exact) break;
                        for (TransferResult.Result result : transferResult.results) {
                            if (result.itemStack.m_41613_() > totalInserted) {
                                if (totalInserted <= 0) {
                                    transferResult.results.remove(result);
                                } else {
                                    result.itemStack.m_41764_(totalInserted);
                                }
                            }
                            totalInserted -= result.itemStack.m_41613_();
                        }
                    }
                    transferResult.doIt();
                    int lastSlot = transferResult.results.get((int)(transferResult.results.size() - 1)).extractSlot;
                    if (!laserNodeItemHandler.handler.getStackInSlot(lastSlot).m_41619_()) {
                        this.stockerDestinationCache.put(new StockerRequest(stockerCardCache, new ItemStackKey(itemStack, stockerCardCache.isCompareNBT)), new StockerSource(inserterCardCache, lastSlot));
                    }
                    return true;
                }
                itemStack.m_41764_(origCountNeeded - transferResult.getTotalItemCounts());
            }
            if (stockerCardCache.exact || transferResult.getTotalItemCounts() <= 0) continue;
            itemStack.m_41764_(transferResult.getTotalItemCounts());
            insertedStack = ItemHandlerHelper.insertItem((IItemHandler)stockerInventory, (ItemStack)itemStack, (boolean)true);
            int totalInserted = transferResult.getTotalItemCounts() - insertedStack.m_41613_();
            if (totalInserted < transferResult.getTotalItemCounts()) {
                if (totalInserted == 0) break;
                for (TransferResult.Result result : transferResult.results) {
                    if (result.itemStack.m_41613_() > totalInserted) {
                        if (totalInserted <= 0) {
                            transferResult.results.remove(result);
                        } else {
                            result.itemStack.m_41764_(totalInserted);
                        }
                    }
                    totalInserted -= result.itemStack.m_41613_();
                }
            }
            transferResult.doIt();
            return true;
        }
        return false;
    }

    public int testInsertToInventory(IItemHandler destitemHandler, ItemStack stack) {
        ItemStack tempStack = ItemHandlerHelper.insertItem((IItemHandler)destitemHandler, (ItemStack)stack, (boolean)true);
        int remainder = tempStack.m_41613_();
        return stack.m_41613_() - remainder;
    }

    public void drawParticlesClient() {
        double d5;
        double d3;
        double d1;
        int i;
        Object data;
        Vector3f insertOffset;
        Vector3f extractOffset;
        VoxelShape voxelShape;
        int count;
        int maxPart;
        int minPart;
        int max;
        int min;
        float randomSpread;
        BlockState targetState;
        Direction direction;
        BlockPos fromPos;
        BlockPos toPos;
        if (this.particleRenderData.isEmpty() && this.particleRenderDataFluids.isEmpty()) {
            return;
        }
        ClientLevel clientLevel = (ClientLevel)this.f_58857_;
        for (ParticleRenderData particleRenderData : this.particleRenderData) {
            ItemStack itemStack = new ItemStack((ItemLike)Item.m_41445_((int)particleRenderData.item), (int)particleRenderData.itemCount);
            toPos = particleRenderData.toPos;
            fromPos = particleRenderData.fromPos;
            direction = Direction.values()[particleRenderData.direction];
            targetState = this.f_58857_.m_8055_(toPos);
            randomSpread = 0.01f;
            min = 1;
            max = 64;
            minPart = 32;
            maxPart = 64;
            count = (maxPart - minPart) * (itemStack.m_41613_() - min) / (max - min) + minPart;
            if (targetState.m_60734_() instanceof LaserNode) {
                targetState = this.f_58857_.m_8055_(fromPos);
                voxelShape = targetState.m_60808_((BlockGetter)this.f_58857_, fromPos);
                extractOffset = MiscTools.findOffset(direction, particleRenderData.position, offsets);
                insertOffset = CardRender.shapeOffset(extractOffset, voxelShape, fromPos, toPos, direction, this.f_58857_, targetState);
                data = new ItemFlowParticleData(itemStack, (float)toPos.m_123341_() + extractOffset.x(), (float)toPos.m_123342_() + extractOffset.y(), (float)toPos.m_123343_() + extractOffset.z(), 10);
                for (i = 0; i < count; ++i) {
                    d1 = this.random.nextGaussian() * (double)randomSpread;
                    d3 = this.random.nextGaussian() * (double)randomSpread;
                    d5 = this.random.nextGaussian() * (double)randomSpread;
                    clientLevel.m_7106_((ParticleOptions)data, (double)((float)toPos.m_123341_() + insertOffset.x()) + d1, (double)((float)toPos.m_123342_() + insertOffset.y()) + d3, (double)((float)toPos.m_123343_() + insertOffset.z()) + d5, 0.0, 0.0, 0.0);
                }
                continue;
            }
            voxelShape = targetState.m_60808_((BlockGetter)this.f_58857_, toPos);
            extractOffset = MiscTools.findOffset(direction, particleRenderData.position, offsets);
            insertOffset = CardRender.shapeOffset(extractOffset, voxelShape, fromPos, toPos, direction, this.f_58857_, targetState);
            data = new ItemFlowParticleData(itemStack, (float)fromPos.m_123341_() + insertOffset.x(), (float)fromPos.m_123342_() + insertOffset.y(), (float)fromPos.m_123343_() + insertOffset.z(), 10);
            for (i = 0; i < count; ++i) {
                d1 = this.random.nextGaussian() * (double)randomSpread;
                d3 = this.random.nextGaussian() * (double)randomSpread;
                d5 = this.random.nextGaussian() * (double)randomSpread;
                clientLevel.m_7106_((ParticleOptions)data, (double)((float)fromPos.m_123341_() + extractOffset.x()) + d1, (double)((float)fromPos.m_123342_() + extractOffset.y()) + d3, (double)((float)fromPos.m_123343_() + extractOffset.z()) + d5, 0.0, 0.0, 0.0);
            }
        }
        for (ParticleRenderDataFluid particleRenderDataFluid : this.particleRenderDataFluids) {
            FluidStack fluidStack = particleRenderDataFluid.fluidStack;
            if (fluidStack.isEmpty()) continue;
            toPos = particleRenderDataFluid.toPos;
            fromPos = particleRenderDataFluid.fromPos;
            direction = Direction.values()[particleRenderDataFluid.direction];
            targetState = this.f_58857_.m_8055_(toPos);
            randomSpread = 0.01f;
            min = 100;
            max = 8000;
            minPart = 8;
            maxPart = 64;
            count = (maxPart - minPart) * (fluidStack.getAmount() - min) / (max - min) + minPart;
            if (targetState.m_60734_() instanceof LaserNode) {
                targetState = this.f_58857_.m_8055_(fromPos);
                voxelShape = targetState.m_60808_((BlockGetter)this.f_58857_, toPos);
                extractOffset = MiscTools.findOffset(direction, particleRenderDataFluid.position, offsets);
                insertOffset = CardRender.shapeOffset(extractOffset, voxelShape, fromPos, toPos, direction, this.f_58857_, targetState);
                data = new FluidFlowParticleData(fluidStack, (float)toPos.m_123341_() + extractOffset.x(), (float)toPos.m_123342_() + extractOffset.y(), (float)toPos.m_123343_() + extractOffset.z(), 10);
                for (i = 0; i < count; ++i) {
                    d1 = this.random.nextGaussian() * (double)randomSpread;
                    d3 = this.random.nextGaussian() * (double)randomSpread;
                    d5 = this.random.nextGaussian() * (double)randomSpread;
                    clientLevel.m_7106_((ParticleOptions)data, (double)((float)toPos.m_123341_() + insertOffset.x()) + d1, (double)((float)toPos.m_123342_() + insertOffset.y()) + d3, (double)((float)toPos.m_123343_() + insertOffset.z()) + d5, 0.0, 0.0, 0.0);
                }
                continue;
            }
            voxelShape = targetState.m_60808_((BlockGetter)this.f_58857_, toPos);
            extractOffset = MiscTools.findOffset(direction, particleRenderDataFluid.position, offsets);
            insertOffset = CardRender.shapeOffset(extractOffset, voxelShape, fromPos, toPos, direction, this.f_58857_, targetState);
            data = new FluidFlowParticleData(fluidStack, (float)fromPos.m_123341_() + insertOffset.x(), (float)fromPos.m_123342_() + insertOffset.y(), (float)fromPos.m_123343_() + insertOffset.z(), 10);
            for (i = 0; i < count; ++i) {
                d1 = this.random.nextGaussian() * (double)randomSpread;
                d3 = this.random.nextGaussian() * (double)randomSpread;
                d5 = this.random.nextGaussian() * (double)randomSpread;
                clientLevel.m_7106_((ParticleOptions)data, (double)((float)fromPos.m_123341_() + extractOffset.x()) + d1, (double)((float)fromPos.m_123342_() + extractOffset.y()) + d3, (double)((float)fromPos.m_123343_() + extractOffset.z()) + d5, 0.0, 0.0, 0.0);
            }
        }
    }

    public void addParticleData(ParticleRenderData particleRenderData) {
        this.particleRenderData.add(particleRenderData);
    }

    public void addParticleDataFluid(ParticleRenderDataFluid particleRenderData) {
        this.particleRenderDataFluids.add(particleRenderData);
    }

    public void drawParticles(ItemStack itemStack, Direction fromDirection, LaserNodeBE sourceBE, LaserNodeBE destinationBE, Direction destinationDirection, int extractPosition, int insertPosition) {
        this.drawParticles(itemStack, itemStack.m_41613_(), fromDirection, sourceBE, destinationBE, destinationDirection, extractPosition, insertPosition);
    }

    public void drawParticlesFluid(FluidStack fluidStack, Direction fromDirection, LaserNodeBE sourceBE, LaserNodeBE destinationBE, Direction destinationDirection, int extractPosition, int insertPosition) {
        ServerTickHandler.addToListFluid(new ParticleDataFluid(fluidStack, new DimBlockPos(sourceBE.f_58857_, sourceBE.m_58899_()), (byte)fromDirection.ordinal(), new DimBlockPos(destinationBE.f_58857_, destinationBE.m_58899_()), (byte)destinationDirection.ordinal(), (byte)extractPosition, (byte)insertPosition));
    }

    public void drawParticles(ItemStack itemStack, int amount, Direction fromDirection, LaserNodeBE sourceBE, LaserNodeBE destinationBE, Direction destinationDirection, int extractPosition, int insertPosition) {
        ServerTickHandler.addToList(new ParticleData(Item.m_41393_((Item)itemStack.m_41720_()), (byte)amount, new DimBlockPos(sourceBE.f_58857_, sourceBE.m_58899_()), (byte)fromDirection.ordinal(), new DimBlockPos(destinationBE.f_58857_, destinationBE.m_58899_()), (byte)destinationDirection.ordinal(), (byte)extractPosition, (byte)insertPosition));
    }

    public void updateThisNode() {
        this.m_6596_();
        for (Direction direction : Direction.values()) {
            NodeSideCache nodeSideCache = this.nodeSideCaches[direction.ordinal()];
            nodeSideCache.myRedstoneFromSensors.clear();
        }
        this.redstoneChecked = false;
        this.notifyOtherNodesOfChange();
        this.markDirtyClient();
        this.findMyExtractors();
        this.updateOverclockers();
        Arrays.stream(this.nodeSideCaches).forEach(NodeSideCache::invalidateEnergy);
    }

    public void notifyOtherNodesOfChange() {
        for (DimBlockPos pos : this.otherNodesInNetwork) {
            LaserNodeBE node = this.getNodeAt(new DimBlockPos(pos.getLevel(this.f_58857_.m_7654_()), this.getWorldPos(pos.blockPos)));
            if (node == null) continue;
            node.checkInvNode(new DimBlockPos(this.f_58857_, this.m_58899_()), true);
            node.redstoneRefreshed = false;
        }
    }

    public void refreshAllInvNodes() {
        this.inserterNodes.clear();
        this.inserterCache.clear();
        this.inserterCacheFluid.clear();
        this.channelOnlyCache.clear();
        this.stockerDestinationCache.clear();
        this.redstoneNetwork.clear();
        for (DimBlockPos pos : this.otherNodesInNetwork) {
            this.checkInvNode(new DimBlockPos(pos.getLevel(this.f_58857_.m_7654_()), this.getWorldPos(pos.blockPos)), false);
        }
        this.redstoneRefreshed = false;
        this.sortInserters();
    }

    public void checkInvNode(DimBlockPos pos, boolean sortInserters) {
        LaserNodeBE be = this.getNodeAt(pos);
        DimBlockPos relativePos = new DimBlockPos(be.f_58857_, this.getRelativePos(pos.blockPos));
        this.inserterNodes.removeIf(p -> p.relativePos.equals(relativePos));
        this.inserterCache.clear();
        this.inserterCacheFluid.clear();
        this.channelOnlyCache.clear();
        this.stockerDestinationCache.clear();
        if (be == null) {
            return;
        }
        for (Direction direction : Direction.values()) {
            NodeSideCache nodeSideCache = be.nodeSideCaches[direction.ordinal()];
            for (int slot = 0; slot < 9; ++slot) {
                ItemStack card = nodeSideCache.itemHandler.getStackInSlot(slot);
                if (!(card.m_41720_() instanceof BaseCard) || card.m_41720_() instanceof CardRedstone || !BaseCard.getNamedTransferMode(card).equals((Object)BaseCard.TransferMode.INSERT)) continue;
                this.inserterNodes.add(new InserterCardCache(relativePos, direction, card, be, slot));
            }
        }
        if (sortInserters) {
            this.sortInserters();
        }
    }

    public LaserNodeItemHandler getLaserNodeHandlerItem(InserterCardCache inserterCardCache) {
        if (!inserterCardCache.cardType.equals((Object)BaseCard.CardType.ITEM)) {
            return null;
        }
        DimBlockPos nodeWorldPos = new DimBlockPos(inserterCardCache.relativePos.getLevel(this.f_58857_.m_7654_()), this.getWorldPos(inserterCardCache.relativePos.blockPos));
        if (!this.chunksLoaded(nodeWorldPos, nodeWorldPos.blockPos.m_121945_(inserterCardCache.direction))) {
            return null;
        }
        LaserNodeBE be = this.getNodeAt(new DimBlockPos(inserterCardCache.relativePos.getLevel(this.f_58857_.m_7654_()), this.getWorldPos(inserterCardCache.relativePos.blockPos)));
        if (be == null) {
            return null;
        }
        IItemHandler handler = (IItemHandler)be.getAttachedInventory(inserterCardCache.direction, inserterCardCache.sneaky).orElse((Object)this.EMPTY);
        if (handler.getSlots() == 0) {
            return null;
        }
        return new LaserNodeItemHandler(be, handler);
    }

    public LazyOptional<IItemHandler> getAttachedInventory(Direction direction, Byte sneakySide) {
        LazyOptional handler;
        SideConnection sideConnection;
        LazyOptional<IItemHandler> testHandler;
        Direction inventorySide = direction.m_122424_();
        if (sneakySide != -1) {
            inventorySide = Direction.values()[sneakySide];
        }
        if ((testHandler = this.facingHandlerItem.get(sideConnection = new SideConnection(direction, inventorySide))) != null && testHandler.isPresent()) {
            return testHandler;
        }
        assert (this.f_58857_ != null);
        BlockEntity be = this.f_58857_.m_7702_(this.m_58899_().m_121945_(direction));
        if (be != null && (handler = be.getCapability(ForgeCapabilities.ITEM_HANDLER, inventorySide)).isPresent()) {
            handler.addListener(this.getInvalidatorItem(sideConnection));
            this.facingHandlerItem.put(sideConnection, (LazyOptional<IItemHandler>)handler);
            return handler;
        }
        this.facingHandlerItem.remove(sideConnection);
        return LazyOptional.empty();
    }

    public LazyOptional<IItemHandler> getAttachedInventoryNoCache(Direction direction, Byte sneakySide) {
        LazyOptional handler;
        Direction inventorySide = direction.m_122424_();
        if (sneakySide != -1) {
            inventorySide = Direction.values()[sneakySide];
        }
        assert (this.f_58857_ != null);
        BlockEntity be = this.f_58857_.m_7702_(this.m_58899_().m_121945_(direction));
        if (be != null && (handler = be.getCapability(ForgeCapabilities.ITEM_HANDLER, inventorySide)).isPresent()) {
            return handler;
        }
        return LazyOptional.empty();
    }

    private NonNullConsumer<LazyOptional<IItemHandler>> getInvalidatorItem(SideConnection sideConnection) {
        return this.connectionInvalidatorItem.computeIfAbsent(sideConnection, c -> new WeakConsumerWrapper<LaserNodeBE, LazyOptional>(this, (te, handler) -> {
            if (te.facingHandlerItem.get(sideConnection) == handler) {
                te.clearCachedInventories(sideConnection);
            }
        }));
    }

    public LaserNodeFluidHandler getLaserNodeHandlerFluid(InserterCardCache inserterCardCache) {
        if (!inserterCardCache.cardType.equals((Object)BaseCard.CardType.FLUID)) {
            return null;
        }
        DimBlockPos nodeWorldPos = new DimBlockPos(inserterCardCache.relativePos.getLevel(this.f_58857_.m_7654_()), this.getWorldPos(inserterCardCache.relativePos.blockPos));
        if (!this.chunksLoaded(nodeWorldPos, nodeWorldPos.blockPos.m_121945_(inserterCardCache.direction))) {
            return null;
        }
        LaserNodeBE be = this.getNodeAt(new DimBlockPos(inserterCardCache.relativePos.getLevel(this.f_58857_.m_7654_()), this.getWorldPos(inserterCardCache.relativePos.blockPos)));
        if (be == null) {
            return null;
        }
        LazyOptional<IFluidHandler> fluidhandler = be.getAttachedFluidTank(inserterCardCache.direction, inserterCardCache.sneaky);
        if (!fluidhandler.isPresent()) {
            return null;
        }
        IFluidHandler handler = (IFluidHandler)fluidhandler.resolve().get();
        if (handler.getTanks() == 0) {
            return null;
        }
        return new LaserNodeFluidHandler(be, handler);
    }

    public LazyOptional<IFluidHandler> getAttachedFluidTank(Direction direction, Byte sneakySide) {
        LazyOptional handler;
        SideConnection sideConnection;
        LazyOptional<IFluidHandler> testHandler;
        Direction inventorySide = direction.m_122424_();
        if (sneakySide != -1) {
            inventorySide = Direction.values()[sneakySide];
        }
        if ((testHandler = this.facingHandlerFluid.get(sideConnection = new SideConnection(direction, inventorySide))) != null && testHandler.isPresent()) {
            return testHandler;
        }
        assert (this.f_58857_ != null);
        BlockEntity be = this.f_58857_.m_7702_(this.m_58899_().m_121945_(direction));
        if (be != null && (handler = be.getCapability(ForgeCapabilities.FLUID_HANDLER, inventorySide)).isPresent()) {
            handler.addListener(this.getInvalidatorFluid(sideConnection));
            this.facingHandlerFluid.put(sideConnection, (LazyOptional<IFluidHandler>)handler);
            return handler;
        }
        this.facingHandlerFluid.remove(sideConnection);
        return LazyOptional.empty();
    }

    public LazyOptional<IFluidHandler> getAttachedFluidTankNoCache(Direction direction, Byte sneakySide) {
        LazyOptional handler;
        Direction inventorySide = direction.m_122424_();
        if (sneakySide != -1) {
            inventorySide = Direction.values()[sneakySide];
        }
        assert (this.f_58857_ != null);
        BlockEntity be = this.f_58857_.m_7702_(this.m_58899_().m_121945_(direction));
        if (be != null && (handler = be.getCapability(ForgeCapabilities.FLUID_HANDLER, inventorySide)).isPresent()) {
            return handler;
        }
        return LazyOptional.empty();
    }

    public LaserNodeEnergyHandler getLaserNodeHandlerEnergy(InserterCardCache inserterCardCache) {
        if (!inserterCardCache.cardType.equals((Object)BaseCard.CardType.ENERGY)) {
            return null;
        }
        DimBlockPos nodeWorldPos = new DimBlockPos(inserterCardCache.relativePos.getLevel(this.f_58857_.m_7654_()), this.getWorldPos(inserterCardCache.relativePos.blockPos));
        if (!this.chunksLoaded(nodeWorldPos, nodeWorldPos.blockPos.m_121945_(inserterCardCache.direction))) {
            return null;
        }
        LaserNodeBE be = this.getNodeAt(new DimBlockPos(inserterCardCache.relativePos.getLevel(this.f_58857_.m_7654_()), this.getWorldPos(inserterCardCache.relativePos.blockPos)));
        if (be == null) {
            return null;
        }
        Optional energyhandler = be.getAttachedEnergyTank(inserterCardCache.direction, inserterCardCache.sneaky).resolve();
        if (energyhandler.isEmpty()) {
            return null;
        }
        IEnergyStorage energyTank = (IEnergyStorage)energyhandler.get();
        return new LaserNodeEnergyHandler(be, energyTank);
    }

    public LazyOptional<IEnergyStorage> getAttachedEnergyTank(Direction direction, Byte sneakySide) {
        LazyOptional handler;
        SideConnection sideConnection;
        LazyOptional<IEnergyStorage> testHandler;
        Direction inventorySide = direction.m_122424_();
        if (sneakySide != -1) {
            inventorySide = Direction.values()[sneakySide];
        }
        if ((testHandler = this.facingHandlerEnergy.get(sideConnection = new SideConnection(direction, inventorySide))) != null && testHandler.isPresent()) {
            return testHandler;
        }
        assert (this.f_58857_ != null);
        BlockEntity be = this.f_58857_.m_7702_(this.m_58899_().m_121945_(direction));
        if (be != null && (handler = be.getCapability(ForgeCapabilities.ENERGY, inventorySide)).isPresent()) {
            handler.addListener(this.getInvalidatorEnergy(sideConnection));
            this.facingHandlerEnergy.put(sideConnection, (LazyOptional<IEnergyStorage>)handler);
            return handler;
        }
        this.facingHandlerFluid.remove(sideConnection);
        return LazyOptional.empty();
    }

    public LazyOptional<IEnergyStorage> getAttachedEnergyTankNoCache(Direction direction, Byte sneakySide) {
        LazyOptional handler;
        Direction inventorySide = direction.m_122424_();
        if (sneakySide != -1) {
            inventorySide = Direction.values()[sneakySide];
        }
        assert (this.f_58857_ != null);
        BlockEntity be = this.f_58857_.m_7702_(this.m_58899_().m_121945_(direction));
        if (be != null && (handler = be.getCapability(ForgeCapabilities.ENERGY, inventorySide)).isPresent()) {
            return handler;
        }
        return LazyOptional.empty();
    }

    private NonNullConsumer<LazyOptional<IFluidHandler>> getInvalidatorFluid(SideConnection sideConnection) {
        return this.connectionInvalidatorFluid.computeIfAbsent(sideConnection, c -> new WeakConsumerWrapper<LaserNodeBE, LazyOptional>(this, (te, handler) -> {
            if (te.facingHandlerFluid.get(sideConnection) == handler) {
                te.clearCachedInventories(sideConnection);
            }
        }));
    }

    private NonNullConsumer<LazyOptional<IEnergyStorage>> getInvalidatorEnergy(SideConnection sideConnection) {
        return this.connectionInvalidatorEnergy.computeIfAbsent(sideConnection, c -> new WeakConsumerWrapper<LaserNodeBE, LazyOptional>(this, (te, handler) -> {
            if (te.facingHandlerEnergy.get(sideConnection) == handler) {
                te.clearCachedInventories(sideConnection);
            }
        }));
    }

    public void clearCachedInventories(SideConnection sideConnection) {
        this.stockerDestinationCache.clear();
        this.facingHandlerItem.remove(sideConnection);
        this.facingHandlerFluid.remove(sideConnection);
        this.facingHandlerEnergy.remove(sideConnection);
    }

    public void clearCachedInventories() {
        this.stockerDestinationCache.clear();
        this.facingHandlerItem.clear();
        this.facingHandlerFluid.clear();
        this.facingHandlerEnergy.clear();
        this.markDirtyClient();
    }

    public void populateRenderList() {
        if (this.f_58857_ == null || !this.f_58857_.f_46443_) {
            return;
        }
        this.cardRenders.clear();
        this.redstoneCardSides.clear();
        for (Direction direction : Direction.values()) {
            IItemHandler h = (IItemHandler)this.getCapability(ForgeCapabilities.ITEM_HANDLER, direction).orElse((Object)new ItemStackHandler(0));
            for (int slot = 0; slot < h.getSlots(); ++slot) {
                byte strength;
                ItemStack card = h.getStackInSlot(slot);
                if (!(card.m_41720_() instanceof BaseCard)) continue;
                int redstoneMode = BaseCard.getRedstoneMode(card);
                if (card.m_41720_() instanceof CardRedstone) {
                    redstoneMode = 2;
                }
                byte redstoneChannel = BaseCard.getRedstoneChannel(card);
                boolean enabled = redstoneMode == 0 || BaseCard.getNamedTransferMode(card).equals((Object)BaseCard.TransferMode.SENSOR) ? true : ((strength = this.getRedstoneChannelStrength(redstoneChannel)) > 0 && redstoneMode == 1 ? false : strength != 0 || redstoneMode != 2);
                if (card.m_41720_() instanceof CardItem) {
                    if (this.getAttachedInventoryNoCache(direction, BaseCard.getSneaky(card)).equals((Object)LazyOptional.empty())) continue;
                    this.cardRenders.add(new CardRender(direction, slot, card, this.m_58899_(), this.f_58857_, enabled));
                    continue;
                }
                if (card.m_41720_() instanceof CardFluid) {
                    if (this.getAttachedFluidTankNoCache(direction, BaseCard.getSneaky(card)).equals((Object)LazyOptional.empty())) continue;
                    this.cardRenders.add(new CardRender(direction, slot, card, this.m_58899_(), this.f_58857_, enabled));
                    continue;
                }
                if (card.m_41720_() instanceof CardEnergy) {
                    Optional lazyEnergyStorage = this.getAttachedEnergyTankNoCache(direction, BaseCard.getSneaky(card)).resolve();
                    if (lazyEnergyStorage.isEmpty()) continue;
                    this.cardRenders.add(new CardRender(direction, slot, card, this.m_58899_(), this.f_58857_, enabled));
                    continue;
                }
                if (!(card.m_41720_() instanceof CardRedstone)) continue;
                this.redstoneCardSides.put((byte)direction.ordinal(), true);
                this.cardRenders.add(new CardRender(direction, slot, card, this.m_58899_(), this.f_58857_, enabled));
            }
        }
        BlockState state = this.m_58900_();
        this.f_58857_.m_46672_(this.m_58899_(), this.m_58900_().m_60734_());
        state.m_60701_((LevelAccessor)this.f_58857_, this.m_58899_(), 3);
        this.rendersChecked = true;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER && side != null) {
            return this.nodeSideCaches[side.ordinal()].handlerLazyOptional.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            if (side == null) {
                return LazyOptional.empty();
            }
            NodeSideCache nodeSideCache = this.nodeSideCaches[side.ordinal()];
            for (int slot = 0; slot < 9; ++slot) {
                ItemStack card = nodeSideCache.itemHandler.getStackInSlot(slot);
                if (!(card.m_41720_() instanceof CardEnergy)) continue;
                BaseCardCache baseCardCache = new BaseCardCache(side, card, slot, this);
                if (!baseCardCache.enabled) continue;
                return this.nodeSideCaches[side.ordinal()].laserEnergyStorage.cast();
            }
            return LazyOptional.empty();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        ListTag redstoneNetworkTag = new ListTag();
        for (Map.Entry entry : this.redstoneNetwork.byte2ByteEntrySet()) {
            CompoundTag comp = new CompoundTag();
            comp.m_128344_("channel", ((Byte)entry.getKey()).byteValue());
            comp.m_128344_("strength", ((Byte)entry.getValue()).byteValue());
            redstoneNetworkTag.add((Object)comp);
        }
        tag.m_128365_("redstoneNetworkTag", (Tag)redstoneNetworkTag);
        return tag;
    }

    @Override
    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag tag = pkt.m_131708_();
        this.m_142466_(tag);
        this.redstoneNetwork.clear();
        ListTag redstoneNetworkTag = tag.m_128437_("redstoneNetworkTag", 10);
        for (int i = 0; i < redstoneNetworkTag.size(); ++i) {
            byte channel = redstoneNetworkTag.m_128728_(i).m_128445_("channel");
            byte strength = redstoneNetworkTag.m_128728_(i).m_128445_("strength");
            this.redstoneNetwork.put(channel, strength);
        }
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        for (int i = 0; i < Direction.values().length; ++i) {
            NodeSideCache nodeSideCache = this.nodeSideCaches[i];
            if (!tag.m_128441_("Inventory" + i)) continue;
            nodeSideCache.itemHandler.deserializeNBT(tag.m_128469_("Inventory" + i));
            if (nodeSideCache.itemHandler.getSlots() >= LaserNodeContainer.SLOTS) continue;
            nodeSideCache.itemHandler.reSize(LaserNodeContainer.SLOTS);
        }
        super.m_142466_(tag);
        this.rendersChecked = false;
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        for (int i = 0; i < Direction.values().length; ++i) {
            NodeSideCache nodeSideCache = this.nodeSideCaches[i];
            tag.m_128365_("Inventory" + i, (Tag)nodeSideCache.itemHandler.serializeNBT());
        }
    }

    @Override
    public void m_7651_() {
        super.m_7651_();
        Arrays.stream(this.nodeSideCaches).forEach(e -> e.handlerLazyOptional.invalidate());
        Arrays.stream(this.nodeSideCaches).forEach(e -> e.laserEnergyStorage.invalidate());
    }

    public class LaserEnergyStorage
    implements IEnergyStorage {
        private final Direction facing;

        public LaserEnergyStorage(Direction facing) {
            this.facing = facing;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return LaserNodeBE.this.receiveEnergy(this.facing, maxReceive, simulate);
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int getEnergyStored() {
            return 0;
        }

        public int getMaxEnergyStored() {
            return 0;
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return true;
        }
    }

    private record LaserNodeItemHandler(LaserNodeBE be, IItemHandler handler) {
    }

    private record LaserNodeFluidHandler(LaserNodeBE be, IFluidHandler handler) {
    }

    private record LaserNodeEnergyHandler(LaserNodeBE be, IEnergyStorage handler) {
    }

    private record StockerSource(InserterCardCache inserterCardCache, int slot) {
    }

    private record StockerRequest(StockerCardCache stockerCardCache, ItemStackKey itemStackKey) {
    }

    private record SideConnection(Direction nodeSide, Direction sneakySide) {
    }
}

