/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.entity.custom.vessel.barge;

import dev.murad.shipping.entity.custom.TrainInventoryProvider;
import dev.murad.shipping.entity.custom.vessel.barge.AbstractBargeEntity;
import dev.murad.shipping.setup.ModEntityTypes;
import dev.murad.shipping.setup.ModItems;
import dev.murad.shipping.util.InventoryUtils;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.items.ItemStackHandler;

public class VacuumBargeEntity
extends AbstractBargeEntity {
    private static final int ITEM_CHECK_DELAY = 20;
    private static final double PICK_RADIUS = 10.0;
    private static final double PICK_HEIGHT = 4.0;
    private int itemCheckDelay = 0;

    public VacuumBargeEntity(EntityType<? extends VacuumBargeEntity> type, Level world) {
        super((EntityType<? extends AbstractBargeEntity>)type, world);
    }

    public VacuumBargeEntity(Level worldIn, double x, double y, double z) {
        super((EntityType<? extends AbstractBargeEntity>)((EntityType)ModEntityTypes.VACUUM_BARGE.get()), worldIn, x, y, z);
    }

    @Override
    protected void doInteract(Player player) {
        int size = this.getConnectedInventories().size();
        player.m_5661_((Component)(switch (size) {
            case 0 -> Component.m_237115_((String)"global.littlelogistics.no_connected_inventory_barge");
            default -> Component.m_237110_((String)"global.littlelogistics.connected_inventory", (Object[])new Object[]{size});
        }), false);
    }

    @Override
    public void m_142687_(Entity.RemovalReason r) {
        super.m_142687_(r);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (this.itemCheckDelay > 0) {
            --this.itemCheckDelay;
            return;
        }
        ServerLevel level = (ServerLevel)this.m_9236_();
        level.m_8767_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_(), this.m_20186_() + 0.85, this.m_20189_(), 6, 0.1, 0.1, 0.1, 0.0);
        AABB searchBox = new AABB(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_20185_(), this.m_20186_(), this.m_20189_()).m_82377_(10.0, 2.0, 10.0);
        List items = this.m_9236_().m_6443_(ItemEntity.class, searchBox, e -> e.m_20280_((Entity)this) < 100.0);
        if (!items.isEmpty()) {
            List<TrainInventoryProvider> inventoryProviders = this.getConnectedInventories();
            for (ItemEntity item : items) {
                ItemStack initial = item.m_32055_();
                ItemStack leftOver = initial.m_41777_();
                for (TrainInventoryProvider provider : inventoryProviders) {
                    if (leftOver.m_41619_()) break;
                    Optional<ItemStackHandler> itemHandler = provider.getTrainInventoryHandler();
                    if (!itemHandler.isPresent()) continue;
                    leftOver = InventoryUtils.moveItemStackIntoHandler(itemHandler.get(), leftOver);
                }
                item.m_32045_(leftOver);
                if (initial.equals(leftOver)) continue;
                level.m_8767_((ParticleOptions)ParticleTypes.f_123760_, item.m_20185_(), item.m_20186_(), item.m_20189_(), 15, 0.2, 0.2, 0.2, 0.0);
            }
        }
        this.itemCheckDelay = 20;
    }

    @Override
    public Item getDropItem() {
        return (Item)ModItems.VACUUM_BARGE.get();
    }
}

