/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.entity.custom.train;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import dev.murad.shipping.ShippingConfig;
import dev.murad.shipping.capability.StallingCapability;
import dev.murad.shipping.entity.Colorable;
import dev.murad.shipping.entity.custom.train.locomotive.AbstractLocomotiveEntity;
import dev.murad.shipping.setup.ModItems;
import dev.murad.shipping.util.LinkableEntity;
import dev.murad.shipping.util.LinkingHandler;
import dev.murad.shipping.util.RailHelper;
import dev.murad.shipping.util.Train;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import lombok.NonNull;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.extensions.IForgeAbstractMinecart;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractTrainCarEntity
extends AbstractMinecart
implements IForgeAbstractMinecart,
LinkableEntity<AbstractTrainCarEntity>,
Colorable {
    public static final EntityDataAccessor<Integer> COLOR_DATA = SynchedEntityData.m_135353_(AbstractTrainCarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> DOMINANT_ID = SynchedEntityData.m_135353_(AbstractTrainCarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> DOMINATED_ID = SynchedEntityData.m_135353_(AbstractTrainCarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected final LinkingHandler<AbstractTrainCarEntity> linkingHandler = new LinkingHandler<AbstractTrainCarEntity>(this, AbstractTrainCarEntity.class, DOMINANT_ID, DOMINATED_ID);
    protected static double TRAIN_SPEED = (Double)ShippingConfig.Server.TRAIN_MAX_SPEED.get();
    protected final RailHelper railHelper;
    private boolean frozen = false;
    private static final Map<RailShape, Pair<Vec3i, Vec3i>> EXITS = (Map)Util.m_137469_((Object)Maps.newEnumMap(RailShape.class), enumMap -> {
        Vec3i west = Direction.WEST.m_122436_();
        Vec3i east = Direction.EAST.m_122436_();
        Vec3i north = Direction.NORTH.m_122436_();
        Vec3i south = Direction.SOUTH.m_122436_();
        Vec3i westUnder = west.m_7495_();
        Vec3i eastUnder = east.m_7495_();
        Vec3i northUnder = north.m_7495_();
        Vec3i southUnder = south.m_7495_();
        enumMap.put(RailShape.NORTH_SOUTH, Pair.of((Object)north, (Object)south));
        enumMap.put(RailShape.EAST_WEST, Pair.of((Object)west, (Object)east));
        enumMap.put(RailShape.ASCENDING_EAST, Pair.of((Object)westUnder, (Object)east));
        enumMap.put(RailShape.ASCENDING_WEST, Pair.of((Object)west, (Object)eastUnder));
        enumMap.put(RailShape.ASCENDING_NORTH, Pair.of((Object)north, (Object)southUnder));
        enumMap.put(RailShape.ASCENDING_SOUTH, Pair.of((Object)northUnder, (Object)south));
        enumMap.put(RailShape.SOUTH_EAST, Pair.of((Object)south, (Object)east));
        enumMap.put(RailShape.SOUTH_WEST, Pair.of((Object)south, (Object)west));
        enumMap.put(RailShape.NORTH_WEST, Pair.of((Object)north, (Object)west));
        enumMap.put(RailShape.NORTH_EAST, Pair.of((Object)north, (Object)east));
    });

    private static Pair<Vec3i, Vec3i> m_38125_(RailShape pShape) {
        return EXITS.get(pShape);
    }

    public AbstractTrainCarEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
        this.linkingHandler.train = new Train<AbstractTrainCarEntity>(this);
        this.railHelper = new RailHelper(this);
        this.resetAttributes();
    }

    public AbstractTrainCarEntity(EntityType<?> entityType, Level level, double x, double y, double z) {
        super(entityType, level, x, y, z);
        BlockPos pos = BlockPos.m_274561_((double)x, (double)y, (double)z);
        BlockState state = this.m_9236_().m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof BaseRailBlock) {
            BaseRailBlock railBlock = (BaseRailBlock)block;
            RailShape railshape = railBlock.getRailDirection(state, (BlockGetter)this.m_9236_(), pos, (AbstractMinecart)this);
            Vec3i exit = (Vec3i)RailHelper.EXITS.get(railshape).getFirst();
            this.m_146922_(RailHelper.directionFromVelocity(new Vec3((double)exit.m_123341_(), (double)exit.m_123342_(), (double)exit.m_123343_())).m_122435_());
        }
        this.linkingHandler.train = new Train<AbstractTrainCarEntity>(this);
        this.railHelper = new RailHelper(this);
        this.resetAttributes();
    }

    private void resetAttributes() {
        this.m_20340_(true);
    }

    protected Optional<RailShape> getRailShape() {
        for (BlockPos pos : Arrays.asList(this.m_20097_().m_7494_(), this.m_20097_())) {
            BlockState state = this.m_9236_().m_8055_(pos);
            Block block = state.m_60734_();
            if (!(block instanceof BaseRailBlock)) continue;
            BaseRailBlock railBlock = (BaseRailBlock)block;
            return Optional.of(this.railHelper.getShape(pos));
        }
        return Optional.empty();
    }

    public boolean m_5829_() {
        return super.m_5829_();
    }

    @NotNull
    public Item m_213728_() {
        return this.m_142340_().m_41720_();
    }

    @Override
    @Nullable
    public Integer getColor() {
        int color = (Integer)this.m_20088_().m_135370_(COLOR_DATA);
        return color == -1 ? null : Integer.valueOf(color);
    }

    @Override
    public void setColor(Integer color) {
        if (color == null) {
            color = -1;
        }
        this.m_20088_().m_135381_(COLOR_DATA, (Object)color);
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        InteractionResult ret = super.m_6096_(player, hand);
        if (ret.m_19077_()) {
            return ret;
        }
        DyeColor color = DyeColor.getColor((ItemStack)player.m_21120_(hand));
        if (color != null) {
            if (!this.m_9236_().f_46443_) {
                this.m_20088_().m_135381_(COLOR_DATA, (Object)color.m_41060_());
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return InteractionResult.PASS;
    }

    protected void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128425_("Color", 3)) {
            this.setColor(compound.m_128451_("Color"));
        }
        this.linkingHandler.readAdditionalSaveData(compound);
    }

    protected void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        Integer color = this.getColor();
        if (color != null) {
            compound.m_128405_("Color", color.intValue());
        }
        this.linkingHandler.addAdditionalSaveData(compound);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DOMINANT_ID, (Object)-1);
        this.m_20088_().m_135372_(DOMINATED_ID, (Object)-1);
        this.m_20088_().m_135372_(COLOR_DATA, (Object)-1);
    }

    public void m_7350_(@NotNull EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (this.linkingHandler != null) {
            this.linkingHandler.onSyncedDataUpdated(key);
        }
    }

    public void m_8119_() {
        this.linkingHandler.tickLoad();
        this.tickYRot();
        float yrot = this.m_146908_();
        this.tickVanilla();
        this.m_146922_(yrot);
        if (!this.m_9236_().f_46443_) {
            this.doChainMath();
        }
    }

    public float getMaxCartSpeedOnRail() {
        return (float)((Double)ShippingConfig.Server.TRAIN_MAX_SPEED.get() * 1.0);
    }

    protected void enforceMaxVelocity(double maxSpeed) {
        Vec3 vel = this.m_20184_();
        Vec3 normal = vel.m_82541_();
        if (Math.abs(vel.f_82479_) > maxSpeed) {
            this.m_20334_(normal.f_82479_ * maxSpeed, vel.f_82480_, vel.f_82481_);
            vel = this.m_20184_();
        }
        if (Math.abs(vel.f_82481_) > maxSpeed) {
            this.m_20334_(vel.f_82479_, vel.f_82480_, normal.f_82481_ * maxSpeed);
        }
    }

    public void m_7334_(Entity pEntity) {
        if (!this.m_9236_().f_46443_) {
            double d1;
            double d0;
            double d2;
            LivingEntity l;
            if (pEntity instanceof LivingEntity && (l = (LivingEntity)pEntity).m_20202_() == null) {
                this.getCapability(StallingCapability.STALLING_CAPABILITY).ifPresent(StallingCapability::stall);
            }
            if (!(pEntity.f_19794_ || this.f_19794_ || this.m_20363_(pEntity) && !this.getLeader().isPresent() || !((d2 = (d0 = pEntity.m_20185_() - this.m_20185_()) * d0 + (d1 = pEntity.m_20189_() - this.m_20189_()) * d1) >= (double)1.0E-4f))) {
                d2 = Math.sqrt(d2);
                d0 /= d2;
                d1 /= d2;
                double d3 = 1.0 / d2;
                if (d3 > 1.0) {
                    d3 = 1.0;
                }
                d0 *= d3;
                d1 *= d3;
                d0 *= (double)0.1f;
                d1 *= (double)0.1f;
                d0 *= 0.5;
                d1 *= 0.5;
                if (pEntity instanceof AbstractMinecart) {
                    Vec3 vec31;
                    double d5;
                    double d4 = pEntity.m_20185_() - this.m_20185_();
                    Vec3 vec3 = new Vec3(d4, 0.0, d5 = pEntity.m_20189_() - this.m_20189_()).m_82541_();
                    double d6 = Math.abs(vec3.m_82526_(vec31 = new Vec3((double)Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))), 0.0, (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)))).m_82541_()));
                    if (d6 < (double)0.8f) {
                        return;
                    }
                    Vec3 vec32 = this.m_20184_();
                    Vec3 vec33 = pEntity.m_20184_();
                    if (((AbstractMinecart)pEntity).isPoweredCart() && !this.isPoweredCart()) {
                        this.m_20256_(vec32.m_82542_(0.2, 1.0, 0.2));
                        this.m_5997_(vec33.f_82479_ - d0, 0.0, vec33.f_82481_ - d1);
                        pEntity.m_20256_(vec33.m_82542_(0.95, 1.0, 0.95));
                    } else if (!((AbstractMinecart)pEntity).isPoweredCart() && this.isPoweredCart()) {
                        pEntity.m_20256_(vec33.m_82542_(0.2, 1.0, 0.2));
                        pEntity.m_5997_(vec32.f_82479_ + d0, 0.0, vec32.f_82481_ + d1);
                        this.m_20256_(vec32.m_82542_(0.95, 1.0, 0.95));
                    } else {
                        double d7 = (vec33.f_82479_ + vec32.f_82479_) / 2.0;
                        double d8 = (vec33.f_82481_ + vec32.f_82481_) / 2.0;
                        this.m_20256_(vec32.m_82542_(0.2, 1.0, 0.2));
                        this.m_5997_(d7 - d0, 0.0, d8 - d1);
                        pEntity.m_20256_(vec33.m_82542_(0.2, 1.0, 0.2));
                        pEntity.m_5997_(d7 + d0, 0.0, d8 + d1);
                    }
                } else {
                    this.m_5997_(-d0, 0.0, -d1);
                    pEntity.m_5997_(d0 / 4.0, 0.0, d1 / 4.0);
                }
            }
        }
    }

    public BlockPos m_20097_() {
        Vec3 position = this.m_20182_();
        int i = Mth.m_14107_((double)position.f_82479_);
        int j = Mth.m_14107_((double)(position.f_82480_ - (double)0.2f));
        int k = Mth.m_14107_((double)position.f_82481_);
        BlockPos blockpos = new BlockPos(i, j, k);
        if (this.m_9236_().m_46859_(blockpos)) {
            BlockPos blockpos1 = blockpos.m_7495_();
            BlockState blockstate = this.m_9236_().m_8055_(blockpos1);
            if (blockstate.collisionExtendsVertically((BlockGetter)this.m_9236_(), blockpos1, (Entity)this)) {
                return blockpos1;
            }
        }
        return blockpos;
    }

    protected void tickYRot() {
        this.m_146922_(this.computeYaw());
    }

    public float computeYaw() {
        float yrot = this.m_146908_();
        Optional<RailShape> railShape = this.getRailShape();
        if (this.linkingHandler.follower.isPresent() && railShape.isPresent()) {
            Direction yaw;
            Optional<Vec3i> directionOpt;
            Optional<Pair<Direction, Integer>> r = this.railHelper.traverseBi(this.m_20097_().m_7494_(), RailHelper.samePositionPredicate((AbstractTrainCarEntity)this.linkingHandler.follower.get()), 5, this);
            if (r.isPresent() && (directionOpt = RailHelper.getDirectionToOtherExit(yaw = this.yawHelper(r.get(), (Entity)this.linkingHandler.follower.get()), railShape.get())).isPresent()) {
                Vec3i direction = directionOpt.get();
                return (float)(Mth.m_14136_((double)direction.m_123343_(), (double)direction.m_123341_()) * 180.0 / Math.PI) + 90.0f;
            }
        } else if (this.linkingHandler.leader.isPresent() && railShape.isPresent()) {
            Direction hordir;
            Optional<Vec3i> directionOpt;
            Optional<Pair<Direction, Integer>> r = this.railHelper.traverseBi(this.m_20097_().m_7494_(), RailHelper.samePositionPredicate((AbstractTrainCarEntity)this.linkingHandler.leader.get()), 5, this);
            if (r.isPresent() && (directionOpt = RailHelper.getDirectionToOtherExit(hordir = this.yawHelper(r.get(), (Entity)this.linkingHandler.leader.get()), railShape.get())).isPresent()) {
                Vec3i direction = directionOpt.get();
                return (float)(Mth.m_14136_((double)(-direction.m_123343_()), (double)(-direction.m_123341_())) * 180.0 / Math.PI) + 90.0f;
            }
        } else {
            double d3;
            double d1 = this.f_19854_ - this.m_20185_();
            if (d1 * d1 + (d3 = this.f_19856_ - this.m_20189_()) * d3 > 0.001) {
                return (float)(Mth.m_14136_((double)d3, (double)d1) * 180.0 / Math.PI) + 90.0f;
            }
        }
        return yrot;
    }

    private Direction yawHelper(Pair<Direction, Integer> r, Entity e) {
        Direction hordir = null;
        if ((Integer)r.getSecond() == 0) {
            Vec3 dirvec = new Vec3(e.f_19854_ - this.f_19854_, 0.0, e.f_19856_ - this.f_19856_);
            hordir = Direction.m_122378_((int)((int)dirvec.m_82541_().f_82479_), (int)0, (int)((int)dirvec.m_82541_().f_82481_));
        }
        if (hordir == null) {
            hordir = (Direction)r.getFirst();
        }
        return hordir;
    }

    public boolean m_6673_(DamageSource pSource) {
        if (((List)ShippingConfig.Server.TRAIN_EXEMPT_DAMAGE_SOURCES.get()).contains(pSource.m_19385_())) {
            return true;
        }
        return super.m_6673_(pSource);
    }

    @Nullable
    public Vec3 m_38096_(double pX, double pY, double pZ, double pOffset) {
        BlockState blockstate;
        int i = Mth.m_14107_((double)pX);
        int j = Mth.m_14107_((double)pY);
        int k = Mth.m_14107_((double)pZ);
        if (this.m_9236_().m_8055_(new BlockPos(i, j - 1, k)).m_204336_(BlockTags.f_13034_)) {
            --j;
        }
        if (BaseRailBlock.m_49416_((BlockState)(blockstate = this.m_9236_().m_8055_(new BlockPos(i, j, k))))) {
            RailShape railshape = ((BaseRailBlock)blockstate.m_60734_()).getRailDirection(blockstate, (BlockGetter)this.m_9236_(), new BlockPos(i, j, k), (AbstractMinecart)this);
            pY = j;
            if (railshape.m_61745_()) {
                pY = j + 1;
            }
            Pair<Vec3i, Vec3i> pair = AbstractTrainCarEntity.m_38125_(railshape);
            Vec3i exit1 = (Vec3i)pair.getFirst();
            Vec3i exit2 = (Vec3i)pair.getSecond();
            double yawX = -Math.sin(Math.toRadians(this.m_146908_()));
            double yawZ = Math.cos(Math.toRadians(this.m_146908_()));
            Vec3 vec3 = new Vec3(yawX, 0.0, yawZ);
            Vec3 vec32 = new Vec3((double)(exit2.m_123341_() - exit1.m_123341_()), (double)(exit2.m_123342_() - exit1.m_123342_()), (double)(exit2.m_123343_() - exit1.m_123343_()));
            if (vec3.m_82526_(vec32) <= 0.0) {
                Vec3i temp = exit1;
                exit1 = exit2;
                exit2 = temp;
            }
            double xDiff = exit2.m_123341_() - exit1.m_123341_();
            double zDiff = exit2.m_123343_() - exit1.m_123343_();
            double dist = Math.sqrt(xDiff * xDiff + zDiff * zDiff);
            if (exit1.m_123342_() != 0 && Mth.m_14107_((double)(pX += (xDiff /= dist) * pOffset)) - i == exit1.m_123341_() && Mth.m_14107_((double)(pZ += (zDiff /= dist) * pOffset)) - k == exit1.m_123343_()) {
                pY += (double)exit1.m_123342_();
            } else if (exit2.m_123342_() != 0 && Mth.m_14107_((double)pX) - i == exit2.m_123341_() && Mth.m_14107_((double)pZ) - k == exit2.m_123343_()) {
                pY += (double)exit2.m_123342_();
            }
            return this.m_38179_(pX, pY, pZ);
        }
        return null;
    }

    public boolean m_6000_(double pX, double pY, double pZ) {
        return true;
    }

    public Direction m_6374_() {
        return Direction.m_122364_((double)this.m_146908_());
    }

    public void m_146922_(float pYRot) {
        super.m_146922_(pYRot);
    }

    protected void tickVanilla() {
        super.m_8119_();
    }

    public void m_142687_(Entity.RemovalReason r) {
        this.handleLinkableKill();
        super.m_142687_(r);
    }

    public void m_7617_(@NotNull DamageSource pSource) {
        int i = (int)Stream.of(this.linkingHandler.leader, this.linkingHandler.follower).filter(Optional::isPresent).count();
        this.m_142687_(Entity.RemovalReason.KILLED);
        if (this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
            ItemStack stack = this.m_142340_();
            if (this.m_8077_()) {
                stack.m_41714_(this.m_7770_());
            }
            this.m_19983_(stack);
            for (int j = 0; j < i; ++j) {
                this.spawnChain();
            }
        }
    }

    protected void prevent180() {
        Vec3 dir = new Vec3((double)this.m_6350_().m_122429_(), (double)this.m_6350_().m_122430_(), (double)this.m_6350_().m_122431_());
        Vec3 vel = this.m_20184_();
        Vec3 mag = vel.m_82559_(dir);
        Vec3 fixer = new Vec3(this.fixUtil(mag.f_82479_), 1.0, this.fixUtil(mag.f_82481_));
        this.m_20256_(this.m_20184_().m_82559_(fixer));
    }

    private double fixUtil(double mag) {
        return mag < 0.0 ? 0.0 : 1.0;
    }

    private void doChainMath() {
        this.linkingHandler.leader.ifPresent(parent -> {
            Optional<Pair<Direction, Integer>> railDirDis = this.railHelper.traverseBi(this.m_20097_().m_7494_(), RailHelper.samePositionPredicate(parent), 5, this);
            boolean docked = this.getTrain().getTug().isPresent() && this.getTrain().getTug().get().m_20184_().equals((Object)Vec3.f_82478_);
            double maxDist = docked ? 1.0 : 1.2;
            double minDist = 1.0;
            float distance = railDirDis.map(Pair::getSecond).filter(a -> a > 0).map(di -> {
                float euclid = this.m_20270_((Entity)parent);
                return Float.valueOf((double)euclid < maxDist ? (float)di.intValue() : euclid);
            }).orElse(Float.valueOf(this.m_20270_((Entity)parent))).floatValue();
            if (distance <= 6.0f) {
                Vec3 euclideanDir = parent.m_20182_().m_82546_(this.m_20182_()).m_82541_();
                Vec3 parentDirection = railDirDis.map(Pair::getFirst).map(Direction::m_122436_).map(Vec3::m_82528_).orElse(euclideanDir).m_82541_();
                Vec3 parentVelocity = parent.m_20184_();
                if ((double)distance > maxDist) {
                    if (parentVelocity.m_82553_() == 0.0) {
                        this.m_20256_(parentDirection.m_82490_(0.05));
                    } else {
                        this.m_20256_(parentDirection.m_82490_(parentVelocity.m_82553_()));
                        if ((double)distance > maxDist + 0.2) {
                            this.m_20256_(this.m_20184_().m_82490_((double)distance * 0.8));
                        }
                    }
                } else if ((double)parent.m_20270_((Entity)this) < minDist && parent.m_20184_().m_82553_() < 0.01) {
                    this.m_6027_(Math.floor(this.m_20185_()) + 0.5, this.m_20186_(), Math.floor(this.m_20189_()) + 0.5);
                    this.m_20256_(Vec3.f_82478_);
                } else {
                    this.m_20256_(Vec3.f_82478_);
                }
            } else {
                this.linkingHandler.leader.ifPresent(LinkableEntity::removeDominated);
                this.removeDominant();
            }
        });
    }

    public AbstractMinecart.Type m_6064_() {
        return AbstractMinecart.Type.CHEST;
    }

    @Override
    public Optional<AbstractTrainCarEntity> getFollower() {
        return this.linkingHandler.follower;
    }

    @Override
    public Optional<AbstractTrainCarEntity> getLeader() {
        return this.linkingHandler.leader;
    }

    private void spawnChain() {
        ItemStack stack = new ItemStack((ItemLike)ModItems.SPRING.get());
        this.m_19983_(stack);
    }

    @Override
    public void handleShearsCut() {
        if (!this.m_9236_().f_46443_ && this.linkingHandler.leader.isPresent()) {
            this.spawnChain();
        }
        this.linkingHandler.leader.ifPresent(LinkableEntity::removeDominated);
        this.removeDominant();
    }

    @Override
    public BlockPos getBlockPos() {
        return this.m_20097_();
    }

    @Override
    public Train<AbstractTrainCarEntity> getTrain() {
        return this.linkingHandler.train;
    }

    @Override
    public boolean hasWaterOnSides() {
        return false;
    }

    private void invertDoms() {
        Optional temp = this.linkingHandler.leader;
        this.linkingHandler.leader = this.linkingHandler.follower;
        this.linkingHandler.follower = temp;
    }

    private Optional<Integer> distHelper(AbstractTrainCarEntity car1, AbstractTrainCarEntity car2) {
        return this.railHelper.traverseBi(car1.m_20097_().m_7494_(), (l, p) -> RailHelper.getRail(car2.m_20097_().m_7494_(), car2.m_9236_()).map(rp -> rp.equals(p)).orElse(false), 5, car1).map(Pair::getSecond);
    }

    private Optional<Pair<AbstractTrainCarEntity, AbstractTrainCarEntity>> findClosestPair(Train<AbstractTrainCarEntity> train1, Train<AbstractTrainCarEntity> train2) {
        int mindistance = Integer.MAX_VALUE;
        Optional<Pair> curr = Optional.empty();
        List<Pair> pairs = Arrays.asList(Pair.of((Object)train1.getHead(), (Object)train2.getTail()), Pair.of((Object)train1.getTail(), (Object)train2.getHead()), Pair.of((Object)train1.getTail(), (Object)train2.getTail()), Pair.of((Object)train1.getHead(), (Object)train2.getHead()));
        for (Pair pair2 : pairs) {
            Optional<Integer> d = this.distHelper((AbstractTrainCarEntity)pair2.getFirst(), (AbstractTrainCarEntity)pair2.getSecond());
            if (!d.isPresent() || d.get() >= mindistance) continue;
            mindistance = d.get();
            curr = Optional.of(pair2);
        }
        return curr.filter(pair -> !(pair.getFirst() instanceof AbstractLocomotiveEntity && !((AbstractTrainCarEntity)pair.getFirst()).getFollower().isEmpty() || pair.getSecond() instanceof AbstractLocomotiveEntity && !((AbstractTrainCarEntity)pair.getSecond()).getFollower().isEmpty()));
    }

    private static Pair<AbstractTrainCarEntity, AbstractTrainCarEntity> caseTailHead(Train<AbstractTrainCarEntity> trainTail, Train<AbstractTrainCarEntity> trainHead, Pair<AbstractTrainCarEntity, AbstractTrainCarEntity> targetPair) {
        if (trainHead.getTug().isPresent()) {
            AbstractTrainCarEntity.invertTrain(trainHead);
            AbstractTrainCarEntity.invertTrain(trainTail);
            return targetPair.swap();
        }
        return targetPair;
    }

    private static void invertTrain(Train<AbstractTrainCarEntity> train) {
        AbstractTrainCarEntity head = train.getHead();
        AbstractTrainCarEntity tail = train.getTail();
        train.asList().forEach(AbstractTrainCarEntity::invertDoms);
        train.setHead(tail);
        train.setTail(head);
    }

    private Optional<Pair<AbstractTrainCarEntity, AbstractTrainCarEntity>> tryFindAndPrepareClosePair(Train<AbstractTrainCarEntity> train1, Train<AbstractTrainCarEntity> train2) {
        return this.findClosestPair(train1, train2).flatMap(targetPair -> {
            if (((AbstractTrainCarEntity)targetPair.getFirst()).equals(train1.getHead()) && ((AbstractTrainCarEntity)targetPair.getSecond()).equals(train2.getHead())) {
                if (train1.getTug().isPresent()) {
                    return Optional.of(targetPair);
                }
                AbstractTrainCarEntity.invertTrain(train2);
                return Optional.of(targetPair.swap());
            }
            if (((AbstractTrainCarEntity)targetPair.getFirst()).equals(train1.getHead()) && ((AbstractTrainCarEntity)targetPair.getSecond()).equals(train2.getTail())) {
                return Optional.of(AbstractTrainCarEntity.caseTailHead(train2, train1, (Pair<AbstractTrainCarEntity, AbstractTrainCarEntity>)targetPair.swap()));
            }
            if (((AbstractTrainCarEntity)targetPair.getFirst()).equals(train1.getTail()) && ((AbstractTrainCarEntity)targetPair.getSecond()).equals(train2.getHead())) {
                return Optional.of(AbstractTrainCarEntity.caseTailHead(train1, train2, (Pair<AbstractTrainCarEntity, AbstractTrainCarEntity>)targetPair));
            }
            if (((AbstractTrainCarEntity)targetPair.getFirst()).equals(train1.getTail()) && ((AbstractTrainCarEntity)targetPair.getSecond()).equals(train2.getTail())) {
                if (train2.getTug().isPresent()) {
                    AbstractTrainCarEntity.invertTrain(train1);
                    return Optional.of(targetPair.swap());
                }
                AbstractTrainCarEntity.invertTrain(train2);
                return Optional.of(targetPair);
            }
            return Optional.empty();
        });
    }

    @Override
    public boolean linkEntities(Player player, Entity target) {
        if (target instanceof AbstractTrainCarEntity) {
            AbstractTrainCarEntity t = (AbstractTrainCarEntity)target;
            Train<AbstractTrainCarEntity> train1 = t.getTrain();
            Train<AbstractTrainCarEntity> train2 = this.getTrain();
            if (train2.getTug().isPresent() && train1.getTug().isPresent()) {
                player.m_5661_((Component)Component.m_237115_((String)"item.littlelogistics.spring.noTwoLoco"), true);
                return false;
            }
            if (train2.equals(train1)) {
                player.m_5661_((Component)Component.m_237115_((String)"item.littlelogistics.spring.noLoops"), true);
                return false;
            }
            this.tryFindAndPrepareClosePair(train1, train2).ifPresentOrElse(pair -> AbstractTrainCarEntity.createLinks((AbstractTrainCarEntity)pair.getFirst(), (AbstractTrainCarEntity)pair.getSecond()), () -> player.m_5661_((Component)Component.m_237115_((String)"item.littlelogistics.spring.tooFar"), true));
            return true;
        }
        player.m_5661_((Component)Component.m_237115_((String)"item.littlelogistics.spring.badTypes"), true);
        return false;
    }

    private static void createLinks(AbstractTrainCarEntity dominant, AbstractTrainCarEntity dominated) {
        dominated.setDominant(dominant);
        dominant.setDominated(dominated);
    }

    @NonNull
    public abstract ItemStack m_142340_();

    public RailHelper getRailHelper() {
        return this.railHelper;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public void setFrozen(boolean frozen) {
        this.frozen = frozen;
    }
}

