/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.appflux.common.me.strategy;

import appeng.api.behaviors.ContainerItemStrategy;
import appeng.api.config.Actionable;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import com.glodblock.github.appflux.api.ItemContext;
import com.glodblock.github.appflux.common.me.key.FluxKey;
import com.glodblock.github.appflux.common.me.key.type.EnergyType;
import com.glodblock.github.appflux.common.me.strategy.context.CarriedContext;
import com.glodblock.github.appflux.common.me.strategy.context.PlayerInvContext;
import com.glodblock.github.appflux.util.AFUtil;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class FEContainerItemStrategy
implements ContainerItemStrategy<FluxKey, ItemContext> {
    @Nullable
    public GenericStack getContainedStack(ItemStack stack) {
        IEnergyStorage energy = (IEnergyStorage)AFUtil.findCapability(stack, ForgeCapabilities.ENERGY);
        if (energy != null && energy.getEnergyStored() > 0) {
            return new GenericStack((AEKey)FluxKey.of(EnergyType.FE), (long)energy.getEnergyStored());
        }
        return null;
    }

    @Nullable
    public ItemContext findCarriedContext(Player player, AbstractContainerMenu menu) {
        if (menu.m_142621_().getCapability(ForgeCapabilities.ENERGY).isPresent()) {
            return new CarriedContext(player, menu);
        }
        return null;
    }

    @Nullable
    public ItemContext findPlayerSlotContext(Player player, int slot) {
        if (player.m_150109_().m_8020_(slot).getCapability(ForgeCapabilities.ENERGY).isPresent()) {
            return new PlayerInvContext(player, slot);
        }
        return null;
    }

    public long extract(ItemContext context, FluxKey what, long amount, Actionable mode) {
        System.out.println("amount: " + amount);
        ItemStack stack = context.getStack();
        ItemStack copy = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1);
        IEnergyStorage handler = (IEnergyStorage)AFUtil.findCapability(copy, ForgeCapabilities.ENERGY);
        if (handler == null) {
            return 0L;
        }
        int extracted = handler.extractEnergy(AFUtil.clampLong(amount), mode.isSimulate());
        System.out.println("stack: " + stack);
        System.out.println("handler: " + handler);
        System.out.println("extracted: " + extracted);
        if (mode == Actionable.MODULATE) {
            stack.m_41774_(1);
            context.addOverflow(copy);
        }
        return extracted;
    }

    public long insert(ItemContext context, FluxKey what, long amount, Actionable mode) {
        ItemStack stack = context.getStack();
        ItemStack copy = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1);
        IEnergyStorage handler = (IEnergyStorage)AFUtil.findCapability(copy, ForgeCapabilities.ENERGY);
        if (handler == null) {
            return 0L;
        }
        int filled = handler.receiveEnergy(AFUtil.clampLong(amount), mode.isSimulate());
        if (mode == Actionable.MODULATE) {
            stack.m_41774_(1);
            context.addOverflow(copy);
        }
        return filled;
    }

    public void playFillSound(Player player, FluxKey what) {
    }

    public void playEmptySound(Player player, FluxKey what) {
    }

    @Nullable
    public GenericStack getExtractableContent(ItemContext context) {
        long canExt = this.extract(context, FluxKey.of(EnergyType.FE), Integer.MAX_VALUE, Actionable.SIMULATE);
        if (canExt <= 0L) {
            return null;
        }
        return new GenericStack((AEKey)FluxKey.of(EnergyType.FE), canExt);
    }
}

