/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.appflux.common.me.energy;

import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageService;
import com.glodblock.github.appflux.common.caps.NetworkFEPower;
import com.glodblock.github.appflux.xmod.fluxnetwork.FluxNetworkPower;
import com.glodblock.github.appflux.xmod.gtceu.GTEUPower;
import com.gregtechceu.gtceu.api.capability.forge.GTCapability;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sonar.fluxnetworks.api.FluxCapabilities;

public final class CapAdaptor {
    private static final Reference2ObjectMap<Capability<?>, Factory<?>> CONVERTER = new Reference2ObjectOpenHashMap();

    public static <T> void addCap(Capability<T> cap, Factory<T> factory) {
        CONVERTER.put(cap, factory);
    }

    public static <T> void addCap(Capability<T> cap, NonDataFactory<T> factory) {
        CONVERTER.put(cap, factory);
    }

    public static <T> Factory<T> find(Capability<T> cap) {
        return (Factory)CONVERTER.get(cap);
    }

    static {
        CapAdaptor.addCap(ForgeCapabilities.ENERGY, NetworkFEPower::of);
        if (ModList.get().isLoaded("fluxnetworks")) {
            CapAdaptor.addCap(FluxCapabilities.FN_ENERGY_STORAGE, FluxNetworkPower::of);
        }
        if (ModList.get().isLoaded("gtceu")) {
            CapAdaptor.addCap(GTCapability.CAPABILITY_ENERGY_CONTAINER, GTEUPower::of);
        }
    }

    public static interface Factory<T> {
        @NotNull
        public T create(@Nullable IStorageService var1, IActionSource var2, Supplier<CompoundTag> var3);
    }

    public static interface NonDataFactory<T>
    extends Factory<T> {
        @NotNull
        public T create(@Nullable IStorageService var1, IActionSource var2);

        @Override
        @NotNull
        default public T create(@Nullable IStorageService storage, IActionSource source, Supplier<CompoundTag> data) {
            return this.create(storage, source);
        }
    }
}

