/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.appflux.common;

import appeng.api.behaviors.ContainerItemStrategy;
import appeng.api.behaviors.GenericSlotCapacities;
import appeng.api.client.StorageCellModels;
import appeng.api.networking.GridServices;
import appeng.api.parts.PartModels;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.AEKeyTypes;
import appeng.api.storage.StorageCells;
import appeng.api.storage.cells.ICellHandler;
import appeng.api.upgrades.Upgrades;
import appeng.block.AEBaseBlockItem;
import appeng.block.AEBaseEntityBlock;
import appeng.blockentity.AEBaseBlockEntity;
import appeng.blockentity.ClientTickingBlockEntity;
import appeng.blockentity.ServerTickingBlockEntity;
import appeng.core.AppEng;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEItems;
import appeng.core.definitions.AEParts;
import appeng.core.localization.GuiText;
import appeng.items.AEBaseItem;
import appeng.parts.automation.StackWorldBehaviors;
import com.glodblock.github.appflux.AppFlux;
import com.glodblock.github.appflux.common.AFContainers;
import com.glodblock.github.appflux.common.AFItemAndBlock;
import com.glodblock.github.appflux.common.me.cell.FECellHandler;
import com.glodblock.github.appflux.common.me.key.FluxKey;
import com.glodblock.github.appflux.common.me.key.type.FluxKeyType;
import com.glodblock.github.appflux.common.me.service.EnergyDistributeService;
import com.glodblock.github.appflux.common.me.strategy.FEContainerItemStrategy;
import com.glodblock.github.appflux.common.me.strategy.FEExternalStorageStrategy;
import com.glodblock.github.appflux.common.me.strategy.FEStackExportStrategy;
import com.glodblock.github.appflux.common.me.strategy.FEStackImportStrategy;
import com.glodblock.github.appflux.common.parts.PartFluxAccessor;
import com.glodblock.github.appflux.config.AFConfig;
import com.glodblock.github.glodium.registry.RegistryHandler;
import com.glodblock.github.glodium.util.GlodUtil;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import org.apache.commons.lang3.tuple.Pair;

public class AFRegistryHandler
extends RegistryHandler {
    public static final AFRegistryHandler INSTANCE = new AFRegistryHandler();

    public AFRegistryHandler() {
        super("appflux");
    }

    public <T extends AEBaseBlockEntity> void block(String name, AEBaseEntityBlock<T> block, Class<T> clazz, BlockEntityType.BlockEntitySupplier<? extends T> supplier) {
        this.bindTileEntity(clazz, block, supplier);
        this.block(name, (Block)block, b -> new AEBaseBlockItem(b, new Item.Properties()));
        this.tile(name, block.getBlockEntityType());
    }

    private <T extends AEBaseBlockEntity> void bindTileEntity(Class<T> clazz, AEBaseEntityBlock<T> block, BlockEntityType.BlockEntitySupplier<? extends T> supplier) {
        BlockEntityTicker serverTicker = null;
        if (ServerTickingBlockEntity.class.isAssignableFrom(clazz)) {
            serverTicker = (level, pos, state, entity) -> ((ServerTickingBlockEntity)entity).serverTick();
        }
        BlockEntityTicker clientTicker = null;
        if (ClientTickingBlockEntity.class.isAssignableFrom(clazz)) {
            clientTicker = (level, pos, state, entity) -> ((ClientTickingBlockEntity)entity).clientTick();
        }
        block.setBlockEntity(clazz, GlodUtil.getTileType(clazz, supplier, block), clientTicker, serverTicker);
    }

    public void init() {
        StackWorldBehaviors.registerExternalStorageStrategy((AEKeyType)FluxKeyType.TYPE, FEExternalStorageStrategy::new);
        StackWorldBehaviors.registerExportStrategy((AEKeyType)FluxKeyType.TYPE, FEStackExportStrategy::new);
        if (AFConfig.pullFE()) {
            StackWorldBehaviors.registerImportStrategy((AEKeyType)FluxKeyType.TYPE, FEStackImportStrategy::new);
        }
        ContainerItemStrategy.register((AEKeyType)FluxKeyType.TYPE, FluxKey.class, (ContainerItemStrategy)new FEContainerItemStrategy());
        GenericSlotCapacities.register((AEKeyType)FluxKeyType.TYPE, (Long)1000000L);
        StorageCells.addCellHandler((ICellHandler)FECellHandler.HANDLER);
        GridServices.register(EnergyDistributeService.class, EnergyDistributeService.class);
        StorageCellModels.registerModel((ItemLike)AFItemAndBlock.FE_CELL_1k, (ResourceLocation)AppFlux.id("block/drive/fe_cell"));
        StorageCellModels.registerModel((ItemLike)AFItemAndBlock.FE_CELL_4k, (ResourceLocation)AppFlux.id("block/drive/fe_cell"));
        StorageCellModels.registerModel((ItemLike)AFItemAndBlock.FE_CELL_16k, (ResourceLocation)AppFlux.id("block/drive/fe_cell"));
        StorageCellModels.registerModel((ItemLike)AFItemAndBlock.FE_CELL_64k, (ResourceLocation)AppFlux.id("block/drive/fe_cell"));
        StorageCellModels.registerModel((ItemLike)AFItemAndBlock.FE_CELL_256k, (ResourceLocation)AppFlux.id("block/drive/fe_cell"));
        StorageCellModels.registerModel((ItemLike)AFItemAndBlock.FE_CELL_1M, (ResourceLocation)AppFlux.id("block/drive/fe_mega_cell"));
        StorageCellModels.registerModel((ItemLike)AFItemAndBlock.FE_CELL_4M, (ResourceLocation)AppFlux.id("block/drive/fe_mega_cell"));
        StorageCellModels.registerModel((ItemLike)AFItemAndBlock.FE_CELL_16M, (ResourceLocation)AppFlux.id("block/drive/fe_mega_cell"));
        StorageCellModels.registerModel((ItemLike)AFItemAndBlock.FE_CELL_64M, (ResourceLocation)AppFlux.id("block/drive/fe_mega_cell"));
        StorageCellModels.registerModel((ItemLike)AFItemAndBlock.FE_CELL_256M, (ResourceLocation)AppFlux.id("block/drive/fe_mega_cell"));
        StorageCellModels.registerModel((ItemLike)AFItemAndBlock.FE_PORTABLE_CELL_1k, (ResourceLocation)AppFlux.id("block/drive/fe_cell"));
        StorageCellModels.registerModel((ItemLike)AFItemAndBlock.FE_PORTABLE_CELL_4k, (ResourceLocation)AppFlux.id("block/drive/fe_cell"));
        StorageCellModels.registerModel((ItemLike)AFItemAndBlock.FE_PORTABLE_CELL_16k, (ResourceLocation)AppFlux.id("block/drive/fe_cell"));
        StorageCellModels.registerModel((ItemLike)AFItemAndBlock.FE_PORTABLE_CELL_64k, (ResourceLocation)AppFlux.id("block/drive/fe_cell"));
        StorageCellModels.registerModel((ItemLike)AFItemAndBlock.FE_PORTABLE_CELL_256k, (ResourceLocation)AppFlux.id("block/drive/fe_cell"));
        StorageCellModels.registerModel((ItemLike)AFItemAndBlock.FE_PORTABLE_CELL_1M, (ResourceLocation)AppFlux.id("block/drive/fe_mega_cell"));
        StorageCellModels.registerModel((ItemLike)AFItemAndBlock.FE_PORTABLE_CELL_4M, (ResourceLocation)AppFlux.id("block/drive/fe_mega_cell"));
        StorageCellModels.registerModel((ItemLike)AFItemAndBlock.FE_PORTABLE_CELL_16M, (ResourceLocation)AppFlux.id("block/drive/fe_mega_cell"));
        StorageCellModels.registerModel((ItemLike)AFItemAndBlock.FE_PORTABLE_CELL_64M, (ResourceLocation)AppFlux.id("block/drive/fe_mega_cell"));
        StorageCellModels.registerModel((ItemLike)AFItemAndBlock.FE_PORTABLE_CELL_256M, (ResourceLocation)AppFlux.id("block/drive/fe_mega_cell"));
        for (Pair entry : this.blocks) {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(AppFlux.id((String)entry.getKey()));
            if (!(block instanceof AEBaseEntityBlock)) continue;
            AEBaseBlockEntity.registerBlockEntityItem((BlockEntityType)((AEBaseEntityBlock)block).getBlockEntityType(), (Item)block.m_5456_());
        }
        AFRegistryHandler.registerCellUpgrades(new ItemLike[]{AFItemAndBlock.FE_CELL_1k, AFItemAndBlock.FE_CELL_4k, AFItemAndBlock.FE_CELL_16k, AFItemAndBlock.FE_CELL_64k, AFItemAndBlock.FE_CELL_256k, AFItemAndBlock.FE_CELL_1M, AFItemAndBlock.FE_CELL_4M, AFItemAndBlock.FE_CELL_16M, AFItemAndBlock.FE_CELL_64M, AFItemAndBlock.FE_CELL_256M});
        AFRegistryHandler.registerPortableCellUpgrades(new ItemLike[]{AFItemAndBlock.FE_PORTABLE_CELL_1k, AFItemAndBlock.FE_PORTABLE_CELL_4k, AFItemAndBlock.FE_PORTABLE_CELL_16k, AFItemAndBlock.FE_PORTABLE_CELL_64k, AFItemAndBlock.FE_PORTABLE_CELL_256k, AFItemAndBlock.FE_PORTABLE_CELL_1M, AFItemAndBlock.FE_PORTABLE_CELL_4M, AFItemAndBlock.FE_PORTABLE_CELL_16M, AFItemAndBlock.FE_PORTABLE_CELL_64M, AFItemAndBlock.FE_PORTABLE_CELL_256M});
        Upgrades.add((ItemLike)AFItemAndBlock.INDUCTION_CARD, (ItemLike)AEBlocks.INTERFACE, (int)1, (String)GuiText.Interface.getTranslationKey());
        Upgrades.add((ItemLike)AFItemAndBlock.INDUCTION_CARD, (ItemLike)AEParts.INTERFACE, (int)1, (String)GuiText.Interface.getTranslationKey());
        Upgrades.add((ItemLike)AFItemAndBlock.INDUCTION_CARD, (ItemLike)AEBlocks.PATTERN_PROVIDER, (int)1, (String)"group.pattern_provider.name");
        Upgrades.add((ItemLike)AFItemAndBlock.INDUCTION_CARD, (ItemLike)AEParts.PATTERN_PROVIDER, (int)1, (String)"group.pattern_provider.name");
    }

    private static void registerCellUpgrades(ItemLike ... cells) {
        for (ItemLike cell : cells) {
            Upgrades.add((ItemLike)AEItems.VOID_CARD, (ItemLike)cell, (int)1, (String)GuiText.StorageCells.getTranslationKey());
        }
    }

    private static void registerPortableCellUpgrades(ItemLike ... cells) {
        for (ItemLike cell : cells) {
            Upgrades.add((ItemLike)AEItems.VOID_CARD, (ItemLike)cell, (int)1, (String)GuiText.PortableCells.getTranslationKey());
            Upgrades.add((ItemLike)AEItems.ENERGY_CARD, (ItemLike)cell, (int)2, (String)GuiText.PortableCells.getTranslationKey());
            Upgrades.add((ItemLike)AFItemAndBlock.INDUCTION_CARD, (ItemLike)cell, (int)1, (String)"group.fe_portable_cells.name");
        }
    }

    public void register(RegisterEvent event) {
        super.register(event);
        AEKeyTypes.register((AEKeyType)FluxKeyType.TYPE);
        PartModels.registerModels((ResourceLocation[])new ResourceLocation[]{PartFluxAccessor.RL});
        ForgeRegistries.MENU_TYPES.register(AppEng.makeId((String)"portable_fe_cell"), AFContainers.PORTABLE_FE_CELL_TYPE);
    }

    public void registerTab(Registry<CreativeModeTab> registry) {
        CreativeModeTab tab = CreativeModeTab.builder().m_257737_(() -> new ItemStack((ItemLike)AFItemAndBlock.FE_CELL_1k)).m_257941_((Component)Component.m_237115_((String)"itemGroup.af")).m_257501_((__, o) -> {
            for (Pair entry : this.items) {
                Object patt9769$temp = entry.getRight();
                if (patt9769$temp instanceof AEBaseItem) {
                    AEBaseItem aeItem = (AEBaseItem)patt9769$temp;
                    aeItem.addToMainCreativeTab(o);
                    continue;
                }
                o.m_246326_((ItemLike)entry.getRight());
            }
            for (Pair entry : this.blocks) {
                o.m_246326_((ItemLike)entry.getRight());
            }
        }).m_257652_();
        Registry.m_122965_(registry, (ResourceLocation)AppFlux.id("tab_main"), (Object)tab);
    }
}

