/*
 * Decompiled with CFR 0.152.
 */
package commoble.hyperbox.client;

import commoble.hyperbox.Hyperbox;
import commoble.hyperbox.blocks.HyperboxMenu;
import commoble.hyperbox.dimension.HyperboxDimension;
import commoble.hyperbox.network.C2SSaveHyperboxPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class HyperboxScreen
extends AbstractContainerScreen<HyperboxMenu> {
    public static final Component EDIT_NAME_LABEL = Component.m_237115_((String)"menu.hyperbox.edit_name");
    public static final Component SAVE_AND_ENTER_LABEL = Component.m_237115_((String)"menu.hyperbox.save_and_enter");
    public static final Component SAVE_AND_EXIT_LABEL = Component.m_237115_((String)"menu.hyperbox.save_and_exit");
    public static final Component CANCEL_LABEL = Component.m_237115_((String)"gui.cancel");
    public static final Component DIMENSION_ID_IN_USE = Component.m_237115_((String)"menu.hyperbox.dimension_id_in_use");
    private EditBox nameEdit;
    private Button saveAndEnterButton;
    private Button saveAndExitButton;
    private Button cancelButton;

    public HyperboxScreen(HyperboxMenu menu, Inventory playerInventory, Component component) {
        super((AbstractContainerMenu)menu, playerInventory, component);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.nameEdit = new EditBox(this.f_96547_, this.f_96543_ / 2 - 152, 40, 300, 20, EDIT_NAME_LABEL);
        this.nameEdit.m_94199_(120);
        this.nameEdit.m_94151_(name -> {
            boolean savable;
            this.saveAndEnterButton.f_93623_ = savable = !name.isBlank() && HyperboxScreen.isDimensionIdFree(name);
            this.saveAndExitButton.f_93623_ = savable;
        });
        this.m_142416_((GuiEventListener)this.nameEdit);
        this.saveAndEnterButton = Button.m_253074_((Component)SAVE_AND_ENTER_LABEL, b -> this.onSave(true)).m_252987_(this.f_96543_ / 2 - 152, 80, 300, 20).m_253136_();
        this.saveAndEnterButton.f_93623_ = false;
        this.m_142416_((GuiEventListener)this.saveAndEnterButton);
        this.saveAndExitButton = Button.m_253074_((Component)SAVE_AND_EXIT_LABEL, b -> this.onSave(false)).m_252987_(this.f_96543_ / 2 - 152, 105, 300, 20).m_253136_();
        this.saveAndExitButton.f_93623_ = false;
        this.m_142416_((GuiEventListener)this.saveAndExitButton);
        this.cancelButton = Button.m_253074_((Component)CANCEL_LABEL, b -> this.f_96541_.f_91074_.m_6915_()).m_252987_(this.f_96543_ / 2 - 152, 130, 300, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.cancelButton);
        this.m_264313_((GuiEventListener)this.nameEdit);
    }

    protected void m_181908_() {
        super.m_181908_();
        this.nameEdit.m_94120_();
    }

    public boolean m_7933_(int key, int scanCode, int mods) {
        if (key == 256 && this.m_6913_()) {
            this.m_7379_();
            return true;
        }
        if (key == 258) {
            FocusNavigationEvent.TabNavigation tabEvent = new FocusNavigationEvent.TabNavigation(!HyperboxScreen.m_96638_());
            ComponentPath nextFocusPath = super.m_264064_((FocusNavigationEvent)tabEvent);
            if (nextFocusPath == null) {
                ComponentPath currentFocusPath = this.m_264435_();
                if (currentFocusPath != null) {
                    currentFocusPath.m_264432_(false);
                }
                nextFocusPath = super.m_264064_((FocusNavigationEvent)tabEvent);
            }
            if (nextFocusPath != null) {
                this.m_264158_(nextFocusPath);
            }
            return false;
        }
        if (this.m_7222_() != null && this.m_7222_().m_7933_(key, scanCode, mods)) {
            return true;
        }
        if (key != 257 && key != 335) {
            return false;
        }
        if (this.nameEdit.m_94155_().isBlank()) {
            this.m_7379_();
        } else {
            this.onSave(true);
        }
        return true;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 10, 0xFFFFFF);
        graphics.m_280430_(this.f_96547_, EDIT_NAME_LABEL, this.f_96543_ / 2 - 152, 30, 0xA0A0A0);
        if (!HyperboxScreen.isDimensionIdFree(this.nameEdit.m_94155_())) {
            graphics.m_280430_(this.f_96547_, DIMENSION_ID_IN_USE, this.f_96543_ / 2 - 152, 65, 0xFF0000);
        }
        for (Renderable renderable : this.f_169369_) {
            renderable.m_88315_(graphics, mouseX, mouseY, partialTicks);
        }
    }

    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
    }

    protected void onSave(boolean enterImmediate) {
        this.f_96541_.m_91152_((Screen)null);
        this.saveAndEnterButton.f_93623_ = false;
        this.saveAndExitButton.f_93623_ = false;
        String name = this.nameEdit.m_94155_();
        Hyperbox.CHANNEL.sendToServer((Object)new C2SSaveHyperboxPacket(name, enterImmediate));
    }

    public static boolean isDimensionIdFree(String name) {
        ResourceLocation dimensionId = HyperboxDimension.generateId((Player)Minecraft.m_91087_().f_91074_, name);
        return !Minecraft.m_91087_().f_91074_.f_108617_.m_105151_().contains(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)dimensionId));
    }
}

