/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.content.oxygen;

import ad_astra_giselle_addon.common.fluid.FluidUtils2;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;

public interface IOxygenStorage {
    public long extractOxygen(@Nullable LivingEntity var1, long var2, boolean var4);

    public long getOxygenAmount();

    public long getOxygenCapacity();

    public boolean canUseOnCold();

    public boolean canUseOnHot();

    default public double getOxygenStoredRatio() {
        long amount = this.getOxygenAmount();
        long capacity = this.getOxygenCapacity();
        return FluidUtils2.getStoredRatio(amount, capacity);
    }

    default public boolean canUse(boolean isCold, boolean isHot) {
        if (isCold && !this.canUseOnCold()) {
            return false;
        }
        return !isHot || this.canUseOnHot();
    }
}

