/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.integration.flywheel;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.backend.instancing.blockentity.BlockEntityInstance;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.hardcoded.ModelPart;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.jozufozu.flywheel.util.AnimationTickHolder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.mehvahdjukaar.supplementaries.client.ModMaterials;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.CannonBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.common.block.blocks.CannonBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.CannonBlockTile;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class CannonInstance
extends BlockEntityInstance<CannonBlockTile>
implements DynamicInstance {
    private final TextureAtlasSprite texture = ModMaterials.CANNON_MATERIAL.m_119204_();
    private final ModelData head;
    private final ModelData headOverlay;
    private final ModelData legs;
    private final ModelData base;
    private final PoseStack stack = new PoseStack();

    public CannonInstance(MaterialManager materialManager, CannonBlockTile tile) {
        super(materialManager, (BlockEntity)tile);
        BlockPos p = this.getInstancePosition();
        this.stack.m_252880_((float)p.m_123341_(), (float)p.m_123342_(), (float)p.m_123343_());
        this.stack.m_85841_(0.9995f, 0.9995f, 0.9995f);
        this.stack.m_85837_(2.5E-4, 2.5E-4, 2.5E-4);
        this.stack.m_85837_(0.5, 0.5, 0.5);
        this.legs = this.makeLegsInstance().setTransform(this.stack);
        this.base = this.makeBaseInstance().setTransform(this.stack);
        this.stack.m_85836_();
        this.stack.m_252880_(0.0f, -0.0625f, 0.0f);
        this.head = this.makeHeadInstance().setTransform(this.stack);
        this.headOverlay = this.makeHeadOverlayInstance().setTransform(this.stack);
        this.stack.m_85849_();
    }

    public void beginFrame() {
        float partialTick = AnimationTickHolder.getPartialTicks();
        this.stack.m_85836_();
        Quaternionf rotation = ((Direction)((CannonBlockTile)this.blockEntity).m_58900_().m_61143_((Property)CannonBlock.f_52588_)).m_122424_().m_253075_();
        this.stack.m_252781_(rotation);
        this.base.setTransform(this.stack);
        float yawRad = ((CannonBlockTile)this.blockEntity).getYaw(partialTick) * ((float)Math.PI / 180);
        float pitchRad = ((CannonBlockTile)this.blockEntity).getPitch(partialTick) * ((float)Math.PI / 180);
        Vector3f forward = new Vector3f(0.0f, 0.0f, 1.0f);
        forward.rotateX((float)Math.PI - pitchRad);
        forward.rotateY((float)Math.PI - yawRad);
        forward.rotate((Quaternionfc)rotation.invert());
        yawRad = (float)Mth.m_14136_((double)forward.x, (double)forward.z);
        pitchRad = (float)Mth.m_14136_((double)(-forward.y), (double)Mth.m_14116_((float)(forward.x * forward.x + forward.z * forward.z)));
        this.stack.m_252781_(Axis.f_252436_.m_252961_(yawRad));
        this.legs.setTransform(this.stack);
        this.stack.m_252880_(0.0f, -0.0625f, 0.0f);
        this.stack.m_252781_(Axis.f_252529_.m_252961_(pitchRad));
        float cooldownCounter = ((CannonBlockTile)this.blockEntity).getCooldownAnimation(partialTick);
        float fireCounter = ((CannonBlockTile)this.blockEntity).getFiringAnimation(partialTick);
        float squish = CannonBlockTileRenderer.triangle(1.0f - cooldownCounter, 0.01f, 0.15f) * 0.2f;
        float wobble = Mth.m_14031_((float)(fireCounter * 20.0f * (float)Math.PI)) * 0.005f;
        float scale = wobble + 1.0f + squish * 0.7f;
        this.stack.m_252880_(0.0f, 0.0f, squish * 5.675f / 16.0f);
        this.stack.m_85841_(scale, scale, 1.0f - squish);
        this.headOverlay.setTransform(this.stack);
        float overlayScale = 0.95f;
        this.stack.m_85841_(overlayScale, overlayScale, overlayScale);
        this.head.setTransform(this.stack);
        this.stack.m_85849_();
    }

    public void remove() {
        this.legs.delete();
        this.base.delete();
        this.head.delete();
        this.headOverlay.delete();
    }

    public void updateLight() {
        this.relight(this.pos, new FlatLit[]{this.legs, this.base, this.head, this.headOverlay});
    }

    private ModelData makeLegsInstance() {
        return (ModelData)this.materialManager.defaultCutout().material(Materials.TRANSFORMED).model((Object)("legs_" + String.valueOf(((CannonBlockTile)this.blockEntity).m_58903_())), this::makeLegs).createInstance();
    }

    private ModelData makeBaseInstance() {
        return (ModelData)this.materialManager.defaultCutout().material(Materials.TRANSFORMED).model((Object)("base_" + String.valueOf(((CannonBlockTile)this.blockEntity).m_58903_())), this::makeBase).createInstance();
    }

    private ModelData makeHeadInstance() {
        return (ModelData)this.materialManager.defaultCutout().material(Materials.TRANSFORMED).model((Object)("head_" + String.valueOf(((CannonBlockTile)this.blockEntity).m_58903_())), this::makeHead).createInstance();
    }

    private ModelData makeHeadOverlayInstance() {
        return (ModelData)this.materialManager.defaultCutout().material(Materials.TRANSFORMED).model((Object)("head_overlay_" + String.valueOf(((CannonBlockTile)this.blockEntity).m_58903_())), this::makeHeadOverlay).createInstance();
    }

    private ModelPart makeLegs() {
        return ModelPart.builder((String)"legs", (int)64, (int)64).sprite(this.texture).cuboid().textureOffset(0, 0).start(6.0f, -4.0f, -3.0f).size(2.0f, 10.0f, 6.0f).endCuboid().cuboid().textureOffset(48, 0).start(-8.0f, -4.0f, -3.0f).size(2.0f, 10.0f, 6.0f).endCuboid().build();
    }

    private ModelPart makeBase() {
        return ModelPart.builder((String)"base", (int)64, (int)64).sprite(this.texture).cuboid().textureOffset(0, 0).start(-8.0f, 6.0f, -8.0f).size(16.0f, 2.0f, 16.0f).endCuboid().build();
    }

    private ModelPart makeHead() {
        return ModelPart.builder((String)"head", (int)64, (int)64).sprite(this.texture).cuboid().textureOffset(0, 18).start(-6.0f, -6.0f, -6.5f).size(12.0f, 12.0f, 13.0f).endCuboid().build();
    }

    private ModelPart makeHeadOverlay() {
        return ModelPart.builder((String)"head_overlay", (int)64, (int)64).sprite(this.texture).cuboid().textureOffset(0, 46).start(-6.0f, -6.0f, -6.5f).size(12.0f, 12.0f, 6.0f).endCuboid().build();
    }
}

