/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.misc;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.mehvahdjukaar.moonlight.api.map.CustomMapData;
import net.mehvahdjukaar.moonlight.api.map.MapDataRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.api.util.math.ColorUtils;
import net.mehvahdjukaar.moonlight.api.util.math.colors.LABColor;
import net.mehvahdjukaar.moonlight.api.util.math.colors.RGBColor;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.reg.ClientRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class ColoredMapHandler {
    protected static int DITHERING = 1;
    public static final CustomMapData.Type<ColorData> COLOR_DATA = MapDataRegistry.registerCustomMapSavedData((ResourceLocation)Supplementaries.res("color_data"), ColorData::new);

    public static void init() {
    }

    public static ColorData getColorData(MapItemSavedData data) {
        return (ColorData)COLOR_DATA.get(data);
    }

    @Nullable
    public static Block getCustomColor(Block block) {
        Holder.Reference blockReference = block.m_204297_();
        if (blockReference.m_203656_(ModTags.NOT_TINTED_ON_MAPS)) {
            return null;
        }
        if (blockReference.m_203656_(ModTags.TINTED_ON_MAPS_GC)) {
            if (block instanceof BushBlock) {
                return Blocks.f_50034_;
            }
            return Blocks.f_50440_;
        }
        if (blockReference.m_203656_(ModTags.TINTED_ON_MAPS_FC) || block instanceof LeavesBlock) {
            return Blocks.f_50050_;
        }
        if (blockReference.m_203656_(ModTags.TINTED_ON_MAPS_WC)) {
            return Blocks.f_49990_;
        }
        if (blockReference.m_203656_(ModTags.TINTED_ON_MAPS_GENERIC)) {
            return block;
        }
        return null;
    }

    public static class ColorData
    implements CustomMapData<Counter>,
    BlockAndTintGetter {
        public static final int BIOME_SIZE = 4;
        public static final String MIN_X = "min_x";
        public static final String MAX_X = "max_x";
        public static final String MIN_Z = "min_z";
        private static final Map<Pair<Pair<Block, ResourceLocation>, Integer>, Integer> GLOBAL_COLOR_CACHE = new Object2IntOpenHashMap();
        private static final int[] IND2COLOR_BUFFER = new int[1024];
        private byte[][] data = null;
        private final List<ResourceLocation> biomesIndexes = new ArrayList<ResourceLocation>();
        private final List<Block> blockIndexes = new ArrayList<Block>();
        private int lastMinDirtyX = 0;
        private int lastMinDirtyZ = 0;
        private int lastMaxDirtyX = 0;
        private int lastMaxDirtyZ = 0;
        private Pair<Block, ResourceLocation> lastEntryHack;

        @Nullable
        private Pair<Block, ResourceLocation> getEntry(int x, int z) {
            if (this.data == null) {
                return null;
            }
            if (x < 0 || x >= 128 || z < 0 || z >= 128) {
                return null;
            }
            if (this.data[x] != null) {
                int packed = Byte.toUnsignedInt(this.data[x][z]);
                if (packed == 0) {
                    return null;
                }
                int bi = --packed & 0xF;
                int bli = packed >> 4;
                if (bi >= this.blockIndexes.size() || bli >= this.biomesIndexes.size()) {
                    return null;
                }
                return Pair.of((Object)this.blockIndexes.get(bi), (Object)this.biomesIndexes.get(bli));
            }
            return null;
        }

        private int getIndex(int x, int z) {
            if (this.data == null || this.data[x] == null) {
                return 0;
            }
            return Byte.toUnsignedInt(this.data[x][z]);
        }

        private void addEntry(MapItemSavedData md, int x, int z, Pair<Block, ResourceLocation> res) {
            boolean changedBiome;
            boolean changedBlock;
            Block block = (Block)res.getFirst();
            if (!this.blockIndexes.contains(block)) {
                if (this.blockIndexes.size() >= 16) {
                    return;
                }
                this.blockIndexes.add(block);
                changedBlock = true;
            } else {
                changedBlock = false;
            }
            int blockIndex = this.blockIndexes.indexOf(block);
            ResourceLocation biome = (ResourceLocation)res.getSecond();
            if (!this.biomesIndexes.contains(biome)) {
                if (this.biomesIndexes.size() >= 16) {
                    return;
                }
                this.biomesIndexes.add(biome);
                changedBiome = true;
            } else {
                changedBiome = false;
            }
            int biomeIndex = this.biomesIndexes.indexOf(biome);
            if (this.data == null) {
                this.data = new byte[128][];
            }
            if (this.data[x] == null) {
                this.data[x] = new byte[128];
            }
            this.data[x][z] = (byte)((blockIndex & 0xF | biomeIndex << 4) + 1);
            this.setDirty(md, counter -> counter.markDirty(x, z, changedBiome, changedBlock));
        }

        public void load(CompoundTag tag) {
            byte i;
            int j;
            this.lastMinDirtyX = 0;
            this.lastMinDirtyZ = 0;
            this.lastMaxDirtyX = 0;
            this.lastMaxDirtyZ = 0;
            if (tag.m_128441_("positions")) {
                CompoundTag t = tag.m_128469_("positions");
                int minX = 0;
                if (t.m_128441_(MIN_X)) {
                    minX = t.m_128451_(MIN_X);
                }
                this.lastMinDirtyX = minX;
                int maxX = 127;
                if (t.m_128441_(MAX_X)) {
                    maxX = t.m_128451_(MAX_X);
                }
                this.lastMaxDirtyX = maxX;
                int minZ = 0;
                if (t.m_128441_(MIN_Z)) {
                    minZ = t.m_128451_(MIN_Z);
                }
                this.lastMinDirtyZ = minZ;
                for (int x = minX; x <= maxX; ++x) {
                    byte[] rowData = t.m_128463_("pos_" + x);
                    this.lastMaxDirtyZ = minZ + rowData.length;
                    if (this.data == null) {
                        this.data = new byte[128][];
                    }
                    if (this.data[x] == null) {
                        this.data[x] = new byte[128];
                    }
                    System.arraycopy(rowData, 0, this.data[x], minZ, rowData.length);
                }
            }
            if (tag.m_128441_("biomes")) {
                this.biomesIndexes.clear();
                ListTag biomes = tag.m_128437_("biomes", 10);
                for (j = 0; j < biomes.size(); ++j) {
                    CompoundTag c = biomes.m_128728_(j);
                    i = c.m_128445_("index");
                    String id = c.m_128461_("id");
                    this.biomesIndexes.add(i, new ResourceLocation(id));
                }
            }
            if (tag.m_128441_("blocks")) {
                this.blockIndexes.clear();
                ListTag blocks = tag.m_128437_("blocks", 10);
                for (j = 0; j < blocks.size(); ++j) {
                    CompoundTag c = blocks.m_128728_(j);
                    i = c.m_128445_("index");
                    String id = c.m_128461_("id");
                    this.blockIndexes.add(i, (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(id)));
                }
            }
        }

        private void savePatch(CompoundTag tag, int minX, int maxX, int minZ, int maxZ, boolean pos, boolean block, boolean biome) {
            int i;
            if (pos && this.data != null) {
                CompoundTag t = new CompoundTag();
                if (minX != 0) {
                    t.m_128405_(MIN_X, minX);
                }
                if (maxX != 127) {
                    t.m_128405_(MAX_X, maxX);
                }
                if (minZ != 0) {
                    t.m_128405_(MIN_Z, minZ);
                }
                for (int x = minX; x <= maxX; ++x) {
                    if (this.data[x] == null) continue;
                    byte[] rowData = new byte[maxZ - minZ + 1];
                    System.arraycopy(this.data[x], minZ, rowData, 0, rowData.length);
                    t.m_128382_("pos_" + x, rowData);
                }
                tag.m_128365_("positions", (Tag)t);
            }
            if (biome && !this.biomesIndexes.isEmpty()) {
                ListTag biomesList = new ListTag();
                for (i = 0; i < this.biomesIndexes.size(); ++i) {
                    CompoundTag biomeTag = new CompoundTag();
                    biomeTag.m_128344_("index", (byte)i);
                    biomeTag.m_128359_("id", this.biomesIndexes.get(i).toString());
                    biomesList.add((Object)biomeTag);
                }
                tag.m_128365_("biomes", (Tag)biomesList);
            }
            if (block && !this.blockIndexes.isEmpty()) {
                ListTag blocksList = new ListTag();
                for (i = 0; i < this.blockIndexes.size(); ++i) {
                    CompoundTag blockTag = new CompoundTag();
                    blockTag.m_128344_("index", (byte)i);
                    blockTag.m_128359_("id", Utils.getID((Block)this.blockIndexes.get(i)).toString());
                    blocksList.add((Object)blockTag);
                }
                tag.m_128365_("blocks", (Tag)blocksList);
            }
        }

        public void save(CompoundTag tag) {
            this.savePatch(tag, 0, 127, 0, 127, true, true, true);
        }

        public void saveToUpdateTag(CompoundTag tag, Counter dc) {
            this.savePatch(tag, dc.minDirtyX, dc.maxDirtyX, dc.minDirtyZ, dc.maxDirtyZ, dc.posDirty, dc.blockDirty, dc.biomesDirty);
        }

        public void loadUpdateTag(CompoundTag tag) {
            this.load(tag);
        }

        public boolean persistOnCopyOrLock() {
            return false;
        }

        public CustomMapData.Type<?> getType() {
            return COLOR_DATA;
        }

        public Counter createDirtyCounter() {
            return new Counter();
        }

        public void markColored(int x, int z, Block block, Level level, BlockPos pos, MapItemSavedData data) {
            Block customColor = ColoredMapHandler.getCustomColor(block);
            if (customColor != null) {
                boolean odd = x % 2 == 0 ^ z % 2 == 1;
                pos = pos.m_7918_(odd ? DITHERING : -DITHERING, 0, odd ? DITHERING : -DITHERING);
                ResourceKey biome = (ResourceKey)level.m_204166_(pos).m_203543_().get();
                Pair pair = Pair.of((Object)customColor, (Object)biome.m_135782_());
                if (!Objects.equals(this.getEntry(x, z), pair)) {
                    this.addEntry(data, x, z, (Pair<Block, ResourceLocation>)pair);
                }
            } else if (this.data != null && this.data[x] != null && this.data[x][z] != 0) {
                this.data[x][z] = 0;
                this.setDirty(data, counter -> counter.markDirty(x, z, false, false));
                for (byte b : this.data[x]) {
                    if (b == 0) continue;
                    return;
                }
                this.data[x] = null;
            }
        }

        @Nullable
        public BlockEntity m_7702_(BlockPos pos) {
            return null;
        }

        public BlockState m_8055_(BlockPos pos) {
            Pair<Block, ResourceLocation> entry = this.getEntry(pos.m_123341_(), pos.m_123343_());
            return entry == null ? Blocks.f_50016_.m_49966_() : ((Block)entry.getFirst()).m_49966_();
        }

        public FluidState m_6425_(BlockPos pos) {
            return this.m_8055_(pos).m_60819_();
        }

        public int m_141928_() {
            return 0;
        }

        public int m_141937_() {
            return 0;
        }

        @OnlyIn(value=Dist.CLIENT)
        public void processTexture(NativeImage texture, int startX, int startY, byte[] colors) {
            if (!ClientConfigs.Tweaks.COLORED_MAPS.get().booleanValue() || this.data == null) {
                return;
            }
            boolean tallGrass = ClientConfigs.Tweaks.TALL_GRASS_COLOR_CHANGE.get();
            boolean accurateConfig = ClientConfigs.Tweaks.ACCURATE_COLORED_MAPS.get();
            if (!accurateConfig) {
                Arrays.fill(IND2COLOR_BUFFER, 0);
            }
            BlockColors blockColors = Minecraft.m_91087_().m_91298_();
            for (int x = 0; x < 128; ++x) {
                for (int z = 0; z < 128; ++z) {
                    int alreadyKnownColor;
                    int index = this.getIndex(x, z);
                    if (index == 0) continue;
                    int newTint = -1;
                    int k = x + z * 128;
                    byte packedId = colors[k];
                    int brightnessInd = packedId & 3;
                    if (!accurateConfig && (alreadyKnownColor = IND2COLOR_BUFFER[index + brightnessInd * 256]) != 0) {
                        newTint = alreadyKnownColor;
                    }
                    if (newTint == -1) {
                        Pair<Block, ResourceLocation> e = this.getEntry(x, z);
                        this.lastEntryHack = e;
                        if (e == null) continue;
                        Block block = (Block)e.getFirst();
                        if (accurateConfig) {
                            BlockPos pos = new BlockPos(x, 64, z);
                            int tint = blockColors.m_92577_(block.m_49966_(), (BlockAndTintGetter)this, pos, 0);
                            if (tint != -1) {
                                newTint = ColorData.postProcessTint(tallGrass, packedId, block, tint);
                            }
                        } else {
                            ColorData.IND2COLOR_BUFFER[index + brightnessInd * 256] = newTint = GLOBAL_COLOR_CACHE.computeIfAbsent((Pair<Pair<Block, ResourceLocation>, Integer>)Pair.of(e, (Object)brightnessInd), n -> {
                                BlockPos pos = new BlockPos(0, 64, 0);
                                int tint = blockColors.m_92577_(block.m_49966_(), (BlockAndTintGetter)this, pos, 0);
                                return ColorData.postProcessTint(tallGrass, packedId, block, tint);
                            }).intValue();
                        }
                    }
                    if (newTint == -1) continue;
                    texture.m_84988_(startX + x, startY + z, newTint);
                }
            }
        }

        private static int postProcessTint(boolean tg, byte packedId, Block block, int tint) {
            float lumIncrease = 1.3f;
            MapColor mapColor = MapColor.m_284175_((int)((packedId & 0xFF) >> 2));
            if (mapColor == MapColor.f_283864_) {
                lumIncrease = 2.0f;
            } else if (mapColor == MapColor.f_283915_ && block instanceof BushBlock && tg) {
                packedId = MapColor.f_283824_.m_284523_(MapColor.Brightness.m_284351_((int)(packedId & 3)));
            }
            int color = MapColor.m_284315_((int)packedId);
            tint = ColorUtils.swapFormat((int)tint);
            RGBColor tintColor = new RGBColor(tint);
            LABColor c = new RGBColor(color).asLAB();
            RGBColor gray = c.multiply(lumIncrease, 0.0f, 0.0f, 1.0f).asRGB();
            return gray.multiply(tintColor.red(), tintColor.green(), tintColor.blue(), 1.0f).asHSL().multiply(1.0f, 1.3f, 1.0f, 1.0f).asRGB().toInt();
        }

        public float m_7717_(Direction direction, boolean shade) {
            return 0.0f;
        }

        public LevelLightEngine m_5518_() {
            return ClientRegistry.getLightEngine();
        }

        public int m_6171_(BlockPos pos, ColorResolver colorResolver) {
            if (this.lastEntryHack != null) {
                if (pos == null || colorResolver == null) {
                    throw new IllegalStateException("Block position of Color resolvers were null. How? " + String.valueOf(pos) + String.valueOf(colorResolver));
                }
                int x = pos.m_123341_();
                int z = pos.m_123343_();
                Biome b = (Biome)Utils.hackyGetRegistry((ResourceKey)Registries.f_256952_).m_7745_((ResourceLocation)this.lastEntryHack.getSecond());
                if (b != null) {
                    boolean odd = x % 2 == 0 ^ z % 2 == 1;
                    pos = pos.m_7918_(odd ? DITHERING : -DITHERING, 0, odd ? DITHERING : -DITHERING);
                    return colorResolver.m_130045_(b, (double)pos.m_123341_() + 0.5, (double)pos.m_123343_() + 0.5);
                }
            }
            return 0;
        }

        public void clear() {
            this.data = null;
            this.biomesIndexes.clear();
            this.blockIndexes.clear();
        }
    }

    public static class Counter
    implements CustomMapData.DirtyCounter {
        private int minDirtyX = 0;
        private int maxDirtyX = 127;
        private int minDirtyZ = 0;
        private int maxDirtyZ = 127;
        private boolean posDirty = true;
        private boolean blockDirty = true;
        private boolean biomesDirty = true;

        public void markDirty(int x, int z, boolean changedBiome, boolean changedBlock) {
            if (changedBiome) {
                this.biomesDirty = true;
            }
            if (changedBlock) {
                this.blockDirty = true;
            }
            if (this.posDirty) {
                this.minDirtyX = Math.min(this.minDirtyX, x);
                this.minDirtyZ = Math.min(this.minDirtyZ, z);
                this.maxDirtyX = Math.max(this.maxDirtyX, x);
                this.maxDirtyZ = Math.max(this.maxDirtyZ, z);
            } else {
                this.posDirty = true;
                this.minDirtyX = x;
                this.minDirtyZ = z;
                this.maxDirtyX = x;
                this.maxDirtyZ = z;
            }
        }

        public boolean isDirty() {
            return this.posDirty || this.biomesDirty || this.blockDirty;
        }

        public void clearDirty() {
            this.biomesDirty = false;
            this.blockDirty = false;
            this.posDirty = false;
            this.minDirtyX = 0;
            this.minDirtyZ = 0;
            this.maxDirtyX = 0;
            this.maxDirtyZ = 0;
        }
    }
}

