/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.client.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.toma.configuration.client.theme.ConfigTheme;
import dev.toma.configuration.client.widget.AbstractThemeWidget;
import dev.toma.configuration.client.widget.render.IRenderer;
import dev.toma.configuration.client.widget.render.SpriteRenderer;
import dev.toma.configuration.config.value.NumericValue;
import java.text.DecimalFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class SliderWidget<N extends Number>
extends AbstractThemeWidget {
    public static final SpriteRenderer.SpriteOptions SLIDER_OPT = new SpriteRenderer.SpriteOptions(0, 60);
    public static final SpriteRenderer.SpriteOptions SLIDER_HOVERED_OPT = new SpriteRenderer.SpriteOptions(0, 80);
    public static final SpriteRenderer.SpriteOptions HANDLE_OPT = new SpriteRenderer.SpriteOptions(200, 60);
    public static final SpriteRenderer.SpriteOptions HANDLE_HOVERED_OPT = new SpriteRenderer.SpriteOptions(200, 80);
    protected final Font font;
    protected final NumericValue<N> numericValue;
    protected IRenderer handleRenderer;
    protected double value;
    protected N num;
    private DecimalFormat decimalFormat;

    public SliderWidget(int x, int y, int width, int height, ConfigTheme theme, NumericValue<N> numericValue, Font font) {
        super(x, y, width, height, theme);
        this.numericValue = numericValue;
        this.value = numericValue.getSliderValue();
        this.font = font;
        this.updateDisplayText();
    }

    public static SpriteRenderer.SpriteOptions getSpriteOptions(AbstractThemeWidget themeWidget) {
        return themeWidget.m_198029_() ? SLIDER_HOVERED_OPT : SLIDER_OPT;
    }

    public static SpriteRenderer.SpriteOptions getHandleSpriteOptions(AbstractThemeWidget themeWidget) {
        return themeWidget.m_93696_() ? HANDLE_HOVERED_OPT : HANDLE_OPT;
    }

    public void setFormatter(DecimalFormat decimalFormat) {
        this.decimalFormat = decimalFormat;
        this.updateDisplayText();
    }

    public void setHandleRenderer(IRenderer handleRenderer) {
        this.handleRenderer = handleRenderer;
    }

    protected void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float deltaTick) {
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, this.f_93625_);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        this.renderBackground(guiGraphics);
        this.applyRenderer(this.handleRenderer, guiGraphics, this.m_252754_() + (int)(this.value * ((double)this.f_93618_ - 8.0)), this.m_252907_(), 8, this.m_93694_());
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        int textColor = this.theme.getWidgetTextColor(this.f_93623_, this.f_93622_);
        this.m_280372_(guiGraphics, this.font, 2, textColor);
    }

    public void m_5716_(double mouseX, double mouseY) {
        this.setValueFromMouse(mouseX);
    }

    private void setValueFromMouse(double x) {
        this.setValue((x - ((double)this.m_252754_() + 4.0)) / ((double)this.f_93618_ - 8.0));
    }

    public void setValue(double value) {
        double oldValue = this.value;
        this.value = Mth.m_14008_((double)value, (double)0.0, (double)1.0);
        if (oldValue != this.value) {
            N updatedValue = this.numericValue.getValueFromSlider(this.value);
            this.numericValue.setValue(updatedValue);
            this.setChanged();
        }
        this.updateDisplayText();
    }

    protected void updateDisplayText() {
        this.num = (Number)this.numericValue.get();
        this.m_93666_((Component)Component.m_237113_((String)(this.decimalFormat != null ? this.decimalFormat.format(this.num) : String.valueOf(this.num))));
    }

    protected void m_7212_(double mouseX, double mouseY, double dragX, double dragY) {
        this.setValueFromMouse(mouseX);
        super.m_7212_(mouseX, mouseY, dragX, dragY);
    }

    public void m_7435_(SoundManager $$0) {
    }

    public void m_7691_(double mouseX, double mouseY) {
        super.m_7435_(Minecraft.m_91087_().m_91106_());
    }

    @Override
    protected void m_168797_(NarrationElementOutput output) {
    }
}

