/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.client.screen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;

public class DialogScreen
extends Screen {
    public static final Component TEXT_CONFIRM = Component.m_237115_((String)"text.configuration.screen.dialog.confirm");
    public static final Component TEXT_CANCEL = Component.m_237115_((String)"text.configuration.screen.dialog.cancel");
    private final Screen background;
    private DialogRespondEvent onCancel;
    private DialogRespondEvent onConfirm;
    protected final Component[] text;
    protected int dialogWidth;
    protected int dialogHeight;
    protected int dialogLeft;
    protected int dialogTop;
    private List<FormattedCharSequence> splitText = new ArrayList<FormattedCharSequence>();

    public DialogScreen(Component title, Component[] text, Screen background) {
        super(title);
        this.text = text;
        this.background = background;
        this.onCancel = screen -> this.displayPreviousScreen();
        this.onConfirm = screen -> this.displayPreviousScreen();
    }

    public void onCancelled(DialogRespondEvent cancelEvent) {
        this.onCancel = Objects.requireNonNull(cancelEvent);
    }

    public void onConfirmed(DialogRespondEvent confirmEvent) {
        this.onConfirm = Objects.requireNonNull(confirmEvent);
    }

    public void setDimensions(int dialogWidth, int dialogHeight) {
        this.dialogWidth = dialogWidth;
        this.dialogHeight = dialogHeight;
        this.dialogLeft = (this.f_96543_ - this.dialogWidth) / 2;
        this.dialogTop = (this.f_96544_ - this.dialogHeight) / 2;
        this.splitText = Arrays.stream(this.text).map(line -> this.f_96547_.m_92923_((FormattedText)line, this.dialogWidth - 10)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    protected void m_7856_() {
        this.background.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
        this.setDimensions(140, 100);
        this.addDefaultDialogButtons();
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int backgroundColor = -16777216;
        this.background.m_88315_(graphics, -1, -1, partialTicks);
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(0.0f, 0.0f, 400.0f);
        graphics.m_280509_(0, 0, this.f_96543_, this.f_96544_, -1442840576);
        graphics.m_280024_(this.dialogLeft - 1, this.dialogTop - 1, this.dialogLeft + this.dialogWidth + 1, this.dialogTop + this.dialogHeight + 1, -1, -1);
        graphics.m_280024_(this.dialogLeft, this.dialogTop, this.dialogLeft + this.dialogWidth, this.dialogTop + this.dialogHeight, backgroundColor, backgroundColor);
        this.renderForeground(graphics, mouseX, mouseY, partialTicks);
        this.f_169369_.forEach(renderable -> renderable.m_88315_(graphics, mouseX, mouseY, partialTicks));
        graphics.m_280168_().m_85849_();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.allowKeyboardInteractions()) {
            if (keyCode == 256) {
                this.cancel();
                return true;
            }
            if (keyCode == 257 || keyCode == 335) {
                this.confirm();
                return true;
            }
            return false;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    protected void renderForeground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int headerWidth = this.f_96547_.m_92852_((FormattedText)this.f_96539_);
        graphics.m_280430_(this.f_96547_, this.f_96539_, this.dialogLeft + (this.dialogWidth - headerWidth) / 2, this.dialogTop + 5, 0xFFFFFF);
        int line = 0;
        for (FormattedCharSequence textLine : this.splitText) {
            graphics.m_280648_(this.f_96547_, textLine, this.dialogLeft + 5, this.dialogTop + 20 + line * 10, 0xFFFFFF);
            ++line;
        }
    }

    protected void addDefaultDialogButtons() {
        int useableWidth = this.dialogWidth - 15;
        int componentWidth = useableWidth / 2;
        int cancelX = this.dialogLeft + 5;
        int confirmX = this.dialogLeft + this.dialogWidth - 5 - componentWidth;
        int componentY = this.dialogTop + this.dialogHeight - 25;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)TEXT_CANCEL, btn -> this.cancel()).m_252794_(cancelX, componentY).m_253046_(componentWidth, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)TEXT_CONFIRM, btn -> this.confirm()).m_252794_(confirmX, componentY).m_253046_(componentWidth, 20).m_253136_());
    }

    protected void confirm() {
        this.onConfirm.respond(this);
    }

    protected void cancel() {
        this.onCancel.respond(this);
    }

    public void displayPreviousScreen() {
        this.f_96541_.m_91152_(this.background);
    }

    protected boolean allowKeyboardInteractions() {
        return true;
    }

    @FunctionalInterface
    public static interface DialogRespondEvent {
        public void respond(DialogScreen var1);
    }
}

