/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client.gui;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.FTBChunksWorldConfig;
import dev.ftb.mods.ftbchunks.api.ClaimResult;
import dev.ftb.mods.ftbchunks.api.client.icon.MapType;
import dev.ftb.mods.ftbchunks.client.FTBChunksClient;
import dev.ftb.mods.ftbchunks.client.gui.LargeMapScreen;
import dev.ftb.mods.ftbchunks.client.gui.PointerIcon;
import dev.ftb.mods.ftbchunks.client.map.MapChunk;
import dev.ftb.mods.ftbchunks.client.map.MapDimension;
import dev.ftb.mods.ftbchunks.client.map.MapManager;
import dev.ftb.mods.ftbchunks.client.map.RenderMapImageTask;
import dev.ftb.mods.ftbchunks.net.RequestChunkChangePacket;
import dev.ftb.mods.ftbchunks.net.RequestMapDataPacket;
import dev.ftb.mods.ftbchunks.net.UpdateForceLoadExpiryPacket;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.FaceIcon;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.icon.ImageIcon;
import dev.ftb.mods.ftblibrary.math.MathUtils;
import dev.ftb.mods.ftblibrary.math.XZ;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.ScreenWrapper;
import dev.ftb.mods.ftblibrary.ui.SimpleButton;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.ui.misc.KeyReferenceScreen;
import dev.ftb.mods.ftblibrary.util.TimeUtils;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftbteams.api.property.TeamProperties;
import dev.ftb.mods.ftbteams.api.property.TeamProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class ChunkScreen
extends BaseScreen {
    private static final ImageIcon FORCE_LOAD_ICON = new ImageIcon(new ResourceLocation("ftbchunks", "textures/force_loaded.png"));
    private final MapDimension dimension;
    private final List<ChunkButton> chunkButtons = new ArrayList<ChunkButton>();
    private final Set<XZ> selectedChunks = new HashSet<XZ>();
    private ChunkUpdateInfo updateInfo;

    public ChunkScreen(MapDimension dimension) {
        RenderMapImageTask.setAlwaysRenderChunksOnMap(true);
        this.dimension = dimension;
        MapManager.getInstance().ifPresent(m -> m.updateAllRegions(false));
    }

    public static void openChunkScreen() {
        MapDimension.getCurrent().ifPresentOrElse(mapDimension -> new ChunkScreen((MapDimension)mapDimension).openGui(), () -> FTBChunks.LOGGER.warn("MapDimension data missing?? not opening chunk screen"));
    }

    public static void notifyChunkUpdates(int totalChunks, int changedChunks, EnumMap<ClaimResult.StandardProblem, Integer> problems) {
        ScreenWrapper sw;
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof ScreenWrapper && (screen = (sw = (ScreenWrapper)screen).getGui()) instanceof ChunkScreen) {
            ChunkScreen cs = (ChunkScreen)screen;
            cs.updateInfo = new ChunkUpdateInfo(totalChunks, changedChunks, problems, Minecraft.m_91087_().f_91073_.m_46467_());
        }
    }

    public boolean onInit() {
        return this.setFullscreen();
    }

    public void onClosed() {
        RenderMapImageTask.setAlwaysRenderChunksOnMap(false);
        MapManager.getInstance().ifPresent(m -> m.updateAllRegions(false));
        super.onClosed();
    }

    public void addWidgets() {
        int sx = this.getX() + (this.width - 240) / 2;
        int sy = this.getY() + (this.height - 240) / 2;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        ChunkPos chunkPos = player.m_146902_();
        int startX = chunkPos.f_45578_ - 7;
        int startZ = chunkPos.f_45579_ - 7;
        this.chunkButtons.clear();
        for (int z = 0; z < 15; ++z) {
            for (int x = 0; x < 15; ++x) {
                ChunkButton button = new ChunkButton((Panel)this, XZ.of((int)(startX + x), (int)(startZ + z)));
                this.chunkButtons.add(button);
                button.setPos(sx + x * 16, sy + z * 16);
            }
        }
        this.addAll(this.chunkButtons);
        new RequestMapDataPacket(chunkPos.f_45578_ - 7, chunkPos.f_45579_ - 7, chunkPos.f_45578_ + 7, chunkPos.f_45579_ + 7).sendToServer();
        this.add(new SimpleButton((Panel)this, (Component)Component.m_237115_((String)"ftbchunks.gui.large_map"), Icons.MAP, (simpleButton, mouseButton) -> LargeMapScreen.openMap()).setPosAndSize(1, 1, 16, 16));
        this.add(new SimpleButton((Panel)this, (Component)Component.m_237115_((String)"ftbchunks.gui.chunk_info"), Icons.INFO, (btn, mb) -> new ChunkMouseReferenceScreen().openGui()).setPosAndSize(1, 19, 16, 16));
    }

    public void mouseReleased(MouseButton button) {
        super.mouseReleased(button);
        if (!this.selectedChunks.isEmpty()) {
            new RequestChunkChangePacket(RequestChunkChangePacket.ChunkChangeOp.create(button.isLeft(), ChunkScreen.isShiftKeyDown()), this.selectedChunks).sendToServer();
            this.selectedChunks.clear();
            this.playClickSound();
        }
    }

    public boolean keyPressed(Key key) {
        if (FTBChunksWorldConfig.playerHasMapStage((Player)Minecraft.m_91087_().f_91074_) && (key.is(77) || key.is(67))) {
            LargeMapScreen.openMap();
            return true;
        }
        return super.keyPressed(key);
    }

    public void drawBackground(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        int sx = x + (w - 240) / 2;
        int sy = y + (h - 240) / 2;
        RenderSystem.setShaderTexture((int)0, (int)FTBChunksClient.INSTANCE.getMinimapTextureId());
        GuiHelper.drawTexturedRect((GuiGraphics)graphics, (int)sx, (int)sy, (int)240, (int)240, (Color4I)Color4I.WHITE, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        if (!InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)258)) {
            for (int gy = 1; gy < 15; ++gy) {
                graphics.m_280656_(sx, sx + 240, sy + gy * 16, 0x64464646);
            }
            for (int gx = 1; gx < 15; ++gx) {
                graphics.m_280315_(sx + gx * 16, sy, sy + 240, 0x64464646);
            }
        }
        double hx = (double)(sx + 112) + MathUtils.mod((double)player.m_20185_(), (double)16.0);
        double hy = (double)(sy + 112) + MathUtils.mod((double)player.m_20189_(), (double)16.0);
        new PointerIcon().draw(MapType.LARGE_MAP, graphics, (int)(hx - 4.0), (int)(hy - 4.0), 8, 8, false, 255);
        FaceIcon.getFace((GameProfile)player.m_36316_()).draw(graphics, (int)(hx - 4.0), (int)(hy - 4.0), 8, 8);
        List<Component> list = FTBChunksClient.INSTANCE.getChunkSummary();
        int fh = theme.getFontHeight() + 1;
        for (int i = 0; i < list.size(); ++i) {
            theme.drawString(graphics, (Object)list.get(i), 3, this.getScreen().m_85446_() - fh * (list.size() - i) - 1, Color4I.WHITE, 2);
        }
        if (this.updateInfo != null && this.updateInfo.shouldDisplay()) {
            theme.drawString(graphics, (Object)this.updateInfo.summary(), sx + 2, sy + 2, 2);
            int line = 1;
            for (Map.Entry<ClaimResult.StandardProblem, Integer> entry : this.updateInfo.problems.entrySet()) {
                ClaimResult.StandardProblem problem = entry.getKey();
                int count = entry.getValue();
                theme.drawString(graphics, (Object)problem.getMessage().m_130946_(": " + count), sx + 2, sy + 5 + theme.getFontHeight() * line++, 2);
            }
        }
    }

    private record ChunkUpdateInfo(int totalChunks, int changedChunks, EnumMap<ClaimResult.StandardProblem, Integer> problems, long timestamp) {
        public boolean shouldDisplay() {
            long timeout = 60L + 20L * (long)this.problems.size();
            return Minecraft.m_91087_().f_91073_.m_46467_() - this.timestamp < timeout;
        }

        public Component summary() {
            ChatFormatting color = this.changedChunks == 0 ? ChatFormatting.RED : (this.changedChunks < this.totalChunks ? ChatFormatting.YELLOW : ChatFormatting.GREEN);
            return Component.m_237110_((String)"ftbchunks.claim_result", (Object[])new Object[]{this.changedChunks, this.totalChunks}).m_130944_(new ChatFormatting[]{ChatFormatting.UNDERLINE, color});
        }
    }

    private class ChunkButton
    extends Button {
        private final XZ chunkPos;
        private final MapChunk chunk;
        private long lastAdjust;

        public ChunkButton(Panel panel, XZ xz) {
            super(panel, (Component)Component.m_237119_(), (Icon)Color4I.empty());
            this.lastAdjust = 0L;
            this.setSize(16, 16);
            this.chunkPos = xz;
            this.chunk = ChunkScreen.this.dimension.getRegion(XZ.regionFromChunk((int)this.chunkPos.x(), (int)this.chunkPos.z())).getDataBlocking().getChunk(this.chunkPos);
        }

        public void onClicked(MouseButton mouseButton) {
            ChunkScreen.this.selectedChunks.add(this.chunkPos);
        }

        public void drawBackground(GuiGraphics matrixStack, Theme theme, int x, int y, int w, int h) {
            if (this.chunk.getForceLoadedDate().isPresent() && !InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)258)) {
                this.chunk.getTeam().ifPresent(team -> {
                    Color4I teamColor = (Color4I)team.getProperties().get((TeamProperty)TeamProperties.COLOR);
                    float[] hsb = Color4I.RGBtoHSB((int)teamColor.redi(), (int)teamColor.greeni(), (int)teamColor.bluei(), null);
                    hsb[0] = (hsb[0] + 0.5f) % 1.0f;
                    FORCE_LOAD_ICON.withColor(Color4I.hsb((float)hsb[0], (float)hsb[1], (float)hsb[2])).draw(matrixStack, x, y, 16, 16);
                });
            }
            if (this.isMouseOver() || ChunkScreen.this.selectedChunks.contains(this.chunkPos)) {
                Color4I.WHITE.withAlpha(100).draw(matrixStack, x, y, w, h);
                if (ChunkButton.isMouseButtonDown((MouseButton)MouseButton.LEFT) || ChunkButton.isMouseButtonDown((MouseButton)MouseButton.RIGHT)) {
                    ChunkScreen.this.selectedChunks.add(this.chunkPos);
                }
            }
        }

        public void addMouseOverText(TooltipList list) {
            if (this.chunk == null) {
                return;
            }
            this.chunk.getTeam().ifPresent(team -> {
                list.add((Component)team.getName().m_6881_().m_130940_(ChatFormatting.WHITE));
                Date date = new Date();
                this.chunk.getClaimedDate().ifPresent(claimedDate -> {
                    if (Screen.m_96639_()) {
                        list.add((Component)Component.m_237113_((String)claimedDate.toLocaleString()).m_130940_(ChatFormatting.GRAY));
                    } else {
                        list.add((Component)Component.m_237113_((String)(TimeUtils.prettyTimeString((long)((date.getTime() - claimedDate.getTime()) / 1000L)) + " ago")).m_130940_(ChatFormatting.GRAY));
                    }
                });
                this.chunk.getForceLoadedDate().ifPresent(forceLoadedDate -> {
                    list.add((Component)Component.m_237115_((String)"ftbchunks.gui.force_loaded").m_130940_(ChatFormatting.YELLOW));
                    String loadStr = Screen.m_96639_() ? "  " + forceLoadedDate.toLocaleString() : "  " + TimeUtils.prettyTimeString((long)((date.getTime() - forceLoadedDate.getTime()) / 1000L)) + " ago";
                    list.add((Component)Component.m_237113_((String)loadStr).m_130940_(ChatFormatting.GRAY));
                    this.chunk.getForceLoadExpiryDate().ifPresent(expiryDate -> {
                        list.add((Component)Component.m_237115_((String)"ftbchunks.gui.force_load_expires").m_130940_(ChatFormatting.GOLD));
                        String expireStr = Screen.m_96639_() ? "  " + expiryDate.toLocaleString() : "  " + TimeUtils.prettyTimeString((long)((expiryDate.getTime() - date.getTime()) / 1000L)) + " from now";
                        list.add((Component)Component.m_237113_((String)expireStr).m_130940_(ChatFormatting.GRAY));
                    });
                    if (!Screen.m_96639_()) {
                        list.add((Component)Component.m_237115_((String)"ftbchunks.gui.hold_alt_for_dates").m_130940_(ChatFormatting.DARK_GRAY));
                    }
                    if (team.getRankForPlayer(Minecraft.m_91087_().f_91074_.m_20148_()).isMemberOrBetter()) {
                        list.add((Component)Component.m_237115_((String)"ftbchunks.gui.mouse_wheel_expiry").m_130940_(ChatFormatting.DARK_GRAY));
                    }
                });
            });
        }

        public boolean mouseScrolled(double scroll) {
            return this.chunk.getForceLoadedDate().map(forceLoadedDate -> {
                if (this.isMouseOver && this.chunk.isTeamMember((Player)Minecraft.m_91087_().f_91074_)) {
                    int dir = (int)Math.signum(scroll);
                    long now = System.currentTimeMillis();
                    Date expiry = this.chunk.getForceLoadExpiryDate().orElse(new Date(now));
                    long offset = ChunkButton.calcOffset(expiry, now, dir);
                    this.chunk.updateForceLoadExpiryDate(now, offset * 1000L);
                    this.lastAdjust = now;
                    return true;
                }
                return super.mouseScrolled(scroll);
            }).orElse(super.mouseScrolled(scroll));
        }

        private static long calcOffset(Date expiry, long now, int dir) {
            long offset = (expiry.getTime() - now) / 1000L;
            if (dir == 1) {
                offset = offset < 86400L ? (offset += 3600L) : (offset < 604800L ? (offset += 86400L) : (offset += 604800L));
            } else if (dir == -1) {
                offset = offset <= 86400L ? Math.max(0L, offset - 3600L) : (offset <= 604800L ? Math.max(86400L, offset - 86400L) : Math.max(604800L, offset - 604800L));
            }
            return offset;
        }

        public void tick() {
            super.tick();
            if (this.lastAdjust > 0L && System.currentTimeMillis() - this.lastAdjust > 1000L) {
                new UpdateForceLoadExpiryPacket(this.chunkPos.dim((Level)Minecraft.m_91087_().f_91073_), this.chunk.getForceLoadExpiryDate().orElse(null)).sendToServer();
                this.lastAdjust = 0L;
            }
        }
    }

    private static class ChunkMouseReferenceScreen
    extends KeyReferenceScreen {
        public ChunkMouseReferenceScreen() {
            super(new String[]{"ftbchunks.gui.chunk_info.text"});
        }

        public Component getTitle() {
            return Component.m_237115_((String)"ftbchunks.gui.chunk_info");
        }
    }
}

