/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.dyenamicsandfriends.compat;

import com.supermartijn642.connectedglass.CGColoredGlassBlock;
import com.supermartijn642.connectedglass.CGColoredPaneBlock;
import com.supermartijn642.connectedglass.CGColoredTintedGlassBlock;
import com.supermartijn642.connectedglass.CGGlassType;
import cy.jdkdigital.dyenamics.core.util.DyenamicDyeColor;
import cy.jdkdigital.dyenamicsandfriends.registry.DyenamicRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.registries.RegistryObject;

public class ConnectedGlassCompat {
    public static final List<RegistryObject<? extends Block>> GLASS_BLOCKS = new ArrayList<RegistryObject<? extends Block>>();
    public static final List<RegistryObject<? extends Block>> GLASS_PANES = new ArrayList<RegistryObject<? extends Block>>();

    public static void registerBlocks(DyenamicDyeColor color) {
        for (CGGlassType glassType : CGGlassType.values()) {
            String typeName = glassType.name().toLowerCase(Locale.ROOT);
            String prefix = "connectedglass_" + typeName + "_" + color.m_7912_();
            RegistryObject<? extends Block> block = DyenamicRegistry.registerBlock(prefix, () -> glassType.isTinted ? new CGColoredTintedGlassBlock(typeName + "_" + color.m_7912_(), true, color.getAnalogue()) : new CGColoredGlassBlock(prefix + "_glass", true, color.getAnalogue()), true);
            GLASS_BLOCKS.add(block);
            if (!glassType.hasPanes) continue;
            GLASS_PANES.add(DyenamicRegistry.registerBlock(prefix + "_pane", () -> new CGColoredPaneBlock((CGColoredGlassBlock)block.get()), true));
        }
    }

    public static void buildTabContents(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey().equals((Object)CreativeModeTabs.f_256791_)) {
            GLASS_BLOCKS.forEach(arg_0 -> ((BuildCreativeModeTabContentsEvent)event).accept(arg_0));
            GLASS_PANES.forEach(arg_0 -> ((BuildCreativeModeTabContentsEvent)event).accept(arg_0));
        }
    }
}

