/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import io.redspace.ironsspellbooks.IronsSpellbooks;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.SyncedSpellData;
import io.redspace.ironsspellbooks.spells.blood.RayOfSiphoningSpell;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class SpellRenderingHelper {
    public static final ResourceLocation SOLID = IronsSpellbooks.id("textures/entity/ray/solid.png");
    public static final ResourceLocation BEACON = IronsSpellbooks.id("textures/entity/ray/beacon_beam.png");
    public static final ResourceLocation STRAIGHT_GLOW = IronsSpellbooks.id("textures/entity/ray/ribbon_glow.png");
    public static final ResourceLocation TWISTING_GLOW = IronsSpellbooks.id("textures/entity/ray/twisting_glow.png");

    public static void renderSpellHelper(SyncedSpellData spellData, LivingEntity castingMob, PoseStack poseStack, MultiBufferSource bufferSource, float partialTicks) {
        if (((AbstractSpell)SpellRegistry.RAY_OF_SIPHONING_SPELL.get()).getSpellId().equals(spellData.getCastingSpellId())) {
            SpellRenderingHelper.renderRayOfSiphoning(castingMob, poseStack, bufferSource, partialTicks);
        }
    }

    public static void renderRayOfSiphoning(LivingEntity entity, PoseStack poseStack, MultiBufferSource bufferSource, float partialTicks) {
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, entity.m_20192_() * 0.8f, 0.0f);
        PoseStack.Pose pose = poseStack.m_85850_();
        Vec3 start = Vec3.f_82478_;
        Vec3 impact = Utils.raycastForEntity(entity.m_9236_(), (Entity)entity, RayOfSiphoningSpell.getRange(0), true).m_82450_();
        float distance = (float)entity.m_146892_().m_82554_(impact);
        float radius = 0.12f;
        int r = 178;
        int g = 0;
        int b = 0;
        int a = 255;
        float deltaTicks = (float)entity.f_19797_ + partialTicks;
        float deltaUV = -deltaTicks % 10.0f;
        float max = Mth.m_14187_((float)(deltaUV * 0.2f - (float)Mth.m_14143_((float)(deltaUV * 0.1f))));
        float min = -1.0f + max;
        Vec3 dir = entity.m_20154_().m_82541_();
        float dx = (float)dir.f_82479_;
        float dz = (float)dir.f_82481_;
        float yRot = (float)Mth.m_14136_((double)dz, (double)dx) - 1.5707f;
        float dxz = Mth.m_14116_((float)(dx * dx + dz * dz));
        float dy = (float)dir.f_82480_;
        float xRot = (float)Mth.m_14136_((double)dy, (double)dxz);
        poseStack.m_252781_(Axis.f_252436_.m_252961_(-yRot));
        poseStack.m_252781_(Axis.f_252529_.m_252961_(-xRot));
        for (float j = 1.0f; j <= distance; j += 0.5f) {
            Vec3 wiggle = new Vec3((double)(Mth.m_14031_((float)(deltaTicks * 0.8f)) * 0.02f), (double)(Mth.m_14031_((float)(deltaTicks * 0.8f + 100.0f)) * 0.02f), (double)(Mth.m_14089_((float)(deltaTicks * 0.8f)) * 0.02f));
            Vec3 end = new Vec3(0.0, 0.0, (double)Math.min(j, distance)).m_82549_(wiggle);
            VertexConsumer inner = bufferSource.m_6299_(RenderType.m_110454_((ResourceLocation)BEACON, (boolean)true));
            SpellRenderingHelper.drawHull(start, end, radius, radius, pose, inner, r, g, b, a, min, max);
            VertexConsumer outer = bufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)TWISTING_GLOW));
            SpellRenderingHelper.drawQuad(start, end, radius * 4.0f, 0.0f, pose, outer, r, g, b, a, min, max);
            SpellRenderingHelper.drawQuad(start, end, 0.0f, radius * 4.0f, pose, outer, r, g, b, a, min, max);
            start = end;
        }
        poseStack.m_85849_();
    }

    private static void drawHull(Vec3 from, Vec3 to, float width, float height, PoseStack.Pose pose, VertexConsumer consumer, int r, int g, int b, int a, float uvMin, float uvMax) {
        SpellRenderingHelper.drawQuad(from.m_82492_(0.0, (double)(height * 0.5f), 0.0), to.m_82492_(0.0, (double)(height * 0.5f), 0.0), width, 0.0f, pose, consumer, r, g, b, a, uvMin, uvMax);
        SpellRenderingHelper.drawQuad(from.m_82520_(0.0, (double)(height * 0.5f), 0.0), to.m_82520_(0.0, (double)(height * 0.5f), 0.0), width, 0.0f, pose, consumer, r, g, b, a, uvMin, uvMax);
        SpellRenderingHelper.drawQuad(from.m_82492_((double)(width * 0.5f), 0.0, 0.0), to.m_82492_((double)(width * 0.5f), 0.0, 0.0), 0.0f, height, pose, consumer, r, g, b, a, uvMin, uvMax);
        SpellRenderingHelper.drawQuad(from.m_82520_((double)(width * 0.5f), 0.0, 0.0), to.m_82520_((double)(width * 0.5f), 0.0, 0.0), 0.0f, height, pose, consumer, r, g, b, a, uvMin, uvMax);
    }

    private static void drawQuad(Vec3 from, Vec3 to, float width, float height, PoseStack.Pose pose, VertexConsumer consumer, int r, int g, int b, int a, float uvMin, float uvMax) {
        Matrix4f poseMatrix = pose.m_252922_();
        Matrix3f normalMatrix = pose.m_252943_();
        float halfWidth = width * 0.5f;
        float halfHeight = height * 0.5f;
        consumer.m_252986_(poseMatrix, (float)from.f_82479_ - halfWidth, (float)from.f_82480_ - halfHeight, (float)from.f_82481_).m_6122_(r, g, b, a).m_7421_(0.0f, uvMin).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(poseMatrix, (float)from.f_82479_ + halfWidth, (float)from.f_82480_ + halfHeight, (float)from.f_82481_).m_6122_(r, g, b, a).m_7421_(1.0f, uvMin).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(poseMatrix, (float)to.f_82479_ + halfWidth, (float)to.f_82480_ + halfHeight, (float)to.f_82481_).m_6122_(r, g, b, a).m_7421_(1.0f, uvMax).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(poseMatrix, (float)to.f_82479_ - halfWidth, (float)to.f_82480_ - halfHeight, (float)to.f_82481_).m_6122_(r, g, b, a).m_7421_(0.0f, uvMax).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
    }
}

