/*
 * Decompiled with CFR 0.152.
 */
package reliquary.client.particle;

import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import reliquary.client.particle.BubbleColorParticleData;
import reliquary.client.particle.ColorParticleData;

@OnlyIn(value=Dist.CLIENT)
public class CauldronBubbleParticle
extends TextureSheetParticle {
    private static final int FRAMES_OF_EACH_POP_STAGE = 2;
    private static final int POP_STAGES = 3;
    private final SpriteSet spriteSet;

    private CauldronBubbleParticle(ClientLevel world, ColorParticleData particleData, double x, double y, double z, SpriteSet spriteSet) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.spriteSet = spriteSet;
        this.m_107250_(0.02f, 0.02f);
        this.f_107663_ = 0.5f + (world.f_46441_.m_188501_() - 0.5f) * 0.4f;
        this.f_107215_ = 0.0;
        this.f_107216_ = 0.0;
        this.f_107217_ = 0.0;
        this.f_107227_ = particleData.getRed();
        this.f_107228_ = particleData.getGreen();
        this.f_107229_ = particleData.getBlue();
        this.f_107225_ = 20;
        this.f_107224_ = 0;
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        this.m_107271_((float)this.f_107224_ / (float)this.f_107225_);
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        } else {
            this.m_108339_(this.spriteSet);
        }
    }

    public float m_5902_(float partialTicks) {
        return 0.1f * this.f_107663_ * (1.0f + (float)this.f_107224_ / 20.0f);
    }

    public void m_108339_(SpriteSet animatedSprite) {
        int ageFromDeath = this.f_107225_ - this.f_107224_;
        if (ageFromDeath <= 6) {
            this.m_108337_(animatedSprite.m_5819_(4 - Math.max(ageFromDeath / 2, 1), 3));
        } else {
            this.m_108337_(animatedSprite.m_5819_(0, this.f_107225_));
        }
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<BubbleColorParticleData> {
        private final SpriteSet spriteSet;

        public Provider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle createParticle(BubbleColorParticleData particleData, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            CauldronBubbleParticle particle = new CauldronBubbleParticle(level, particleData, x, y, z, this.spriteSet);
            particle.m_108337_(this.spriteSet.m_5819_(particle.f_107224_, particle.f_107225_));
            return particle;
        }
    }
}

