/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.storage;

import com.ldtteam.structurize.blueprints.v1.Blueprint;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

public class ClientFutureProcessor {
    private static final Queue<BlueprintProcessingData> blueprintConsumerQueue = new LinkedList<BlueprintProcessingData>();
    private static final Queue<BlueprintDataProcessingData> blueprintDataConsumerQueue = new LinkedList<BlueprintDataProcessingData>();

    public static void queueBlueprint(@NotNull BlueprintProcessingData processingData) {
        blueprintConsumerQueue.add(processingData);
    }

    public static void queueBlueprintData(@NotNull BlueprintDataProcessingData processingData) {
        blueprintDataConsumerQueue.add(processingData);
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Record data;
            if (!blueprintConsumerQueue.isEmpty() && ClientFutureProcessor.blueprintConsumerQueue.peek().blueprintFuture.isDone()) {
                data = blueprintConsumerQueue.poll();
                try {
                    data.consumer.accept(data.blueprintFuture.get());
                }
                catch (InterruptedException | ExecutionException e) {
                    e.printStackTrace();
                }
            }
            if (!blueprintDataConsumerQueue.isEmpty() && ClientFutureProcessor.blueprintDataConsumerQueue.peek().blueprintDataFuture.isDone()) {
                data = blueprintDataConsumerQueue.poll();
                try {
                    ((BlueprintDataProcessingData)data).consumer.accept(((BlueprintDataProcessingData)data).blueprintDataFuture.get());
                }
                catch (InterruptedException | ExecutionException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public record BlueprintProcessingData(Future<Blueprint> blueprintFuture, Consumer<Blueprint> consumer) {
    }

    public record BlueprintDataProcessingData(Future<byte[]> blueprintDataFuture, Consumer<byte[]> consumer) {
    }
}

