/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.operations;

import com.ldtteam.structurize.Network;
import com.ldtteam.structurize.Structurize;
import com.ldtteam.structurize.network.messages.UpdateClientRender;
import com.ldtteam.structurize.operations.BaseOperation;
import com.ldtteam.structurize.util.ChangeStorage;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;

public abstract class AreaOperation
extends BaseOperation {
    protected final Player player;
    protected final BlockPos startPos;
    protected final BlockPos endPos;
    private BlockPos currentPos;

    protected AreaOperation(Component storageText, Player player, BlockPos startPos, BlockPos endPos) {
        super(new ChangeStorage(storageText, player != null ? player.m_20148_() : UUID.randomUUID()));
        this.player = player;
        this.startPos = new BlockPos(Math.min(startPos.m_123341_(), endPos.m_123341_()), Math.min(startPos.m_123342_(), endPos.m_123342_()), Math.min(startPos.m_123343_(), endPos.m_123343_()));
        this.endPos = new BlockPos(Math.max(startPos.m_123341_(), endPos.m_123341_()), Math.max(startPos.m_123342_(), endPos.m_123342_()), Math.max(startPos.m_123343_(), endPos.m_123343_()));
        this.currentPos = this.startPos;
    }

    @Override
    public final boolean apply(ServerLevel world) {
        if (this.player != null && this.player.m_9236_().m_46472_() != world.m_46472_()) {
            return false;
        }
        int count = 0;
        for (int y = this.currentPos.m_123342_(); y <= this.endPos.m_123342_(); ++y) {
            for (int x = this.currentPos.m_123341_(); x <= this.endPos.m_123341_(); ++x) {
                for (int z = this.currentPos.m_123343_(); z <= this.endPos.m_123343_(); ++z) {
                    BlockPos here = new BlockPos(x, y, z);
                    this.apply(world, here);
                    if (++count < (Integer)Structurize.getConfig().getServer().maxOperationsPerTick.get()) continue;
                    this.currentPos = here;
                    return false;
                }
                this.currentPos = new BlockPos(x, y, this.startPos.m_123343_());
            }
            this.currentPos = new BlockPos(this.startPos.m_123341_(), y, this.startPos.m_123343_());
        }
        Network.getNetwork().sendToEveryone(new UpdateClientRender(this.startPos, this.endPos));
        return true;
    }

    protected abstract void apply(ServerLevel var1, BlockPos var2);
}

