/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.common.block.entity.machine;

import cofh.core.util.helpers.AugmentableHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.lib.api.StorageGroup;
import cofh.lib.api.inventory.IItemStackHolder;
import cofh.lib.client.sounds.ConditionalSoundInstance;
import cofh.lib.common.inventory.ItemStorageCoFH;
import cofh.lib.util.helpers.MathHelper;
import cofh.thermal.core.common.config.ThermalCoreConfig;
import cofh.thermal.core.common.item.SlotSealItem;
import cofh.thermal.core.util.managers.machine.PulverizerRecipeManager;
import cofh.thermal.expansion.common.inventory.machine.MachinePulverizerMenu;
import cofh.thermal.expansion.init.registries.TExpBlockEntities;
import cofh.thermal.expansion.init.registries.TExpSounds;
import cofh.thermal.lib.common.block.entity.MachineBlockEntity;
import cofh.thermal.lib.util.recipes.IMachineInventory;
import cofh.thermal.lib.util.recipes.IThermalInventory;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class MachinePulverizerBlockEntity
extends MachineBlockEntity {
    protected ItemStorageCoFH inputSlot = new ItemStorageCoFH(item -> this.filter.valid(item) && PulverizerRecipeManager.instance().validRecipe(item));
    protected ItemStorageCoFH catalystSlot = new ItemStorageCoFH(item -> item.m_41720_() instanceof SlotSealItem || PulverizerRecipeManager.instance().validCatalyst(item));
    protected boolean cyclicProcessingFeature = false;

    public MachinePulverizerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TExpBlockEntities.MACHINE_PULVERIZER_TILE.get(), pos, state);
        this.inventory.addSlot(this.inputSlot, StorageGroup.INPUT);
        this.inventory.addSlot(this.catalystSlot, StorageGroup.CATALYST);
        this.inventory.addSlots(StorageGroup.OUTPUT, 4);
        this.inventory.addSlot(this.chargeSlot, StorageGroup.INTERNAL);
        this.addAugmentSlots(ThermalCoreConfig.machineAugments);
        this.initHandlers();
    }

    protected int getBaseProcessTick() {
        return PulverizerRecipeManager.instance().getBasePower();
    }

    protected boolean cacheRecipe() {
        this.curRecipe = PulverizerRecipeManager.instance().getRecipe((IThermalInventory)this);
        this.curCatalyst = PulverizerRecipeManager.instance().getCatalyst((IItemStackHolder)this.catalystSlot);
        if (this.curRecipe != null) {
            this.itemInputCounts = this.curRecipe.getInputItemCounts((IMachineInventory)this);
        }
        return this.curRecipe != null;
    }

    protected void resolveInputs() {
        int decrement;
        this.inputSlot.modify(-((Integer)this.itemInputCounts.get(0)).intValue());
        if (this.cyclicProcessingFeature && !this.catalystSlot.isEmpty() && !this.catalystSlot.isFull()) {
            ItemStack catalyst = this.catalystSlot.getItemStack();
            for (ItemStorageCoFH slot : this.outputSlots()) {
                if (!ItemHelper.itemsEqualWithTags((ItemStack)slot.getItemStack(), (ItemStack)catalyst)) continue;
                slot.modify(-1);
                this.catalystSlot.modify(1);
                break;
            }
        }
        int n = decrement = this.itemInputCounts.size() > 1 ? (Integer)this.itemInputCounts.get(1) : 0;
        if (decrement > 0) {
            if (this.catalystSlot.getItemStack().m_41763_()) {
                if (this.catalystSlot.getItemStack().m_220157_(decrement, MathHelper.RANDOM, null)) {
                    this.catalystSlot.modify(-1);
                }
            } else {
                this.catalystSlot.modify(-decrement);
            }
        }
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return new MachinePulverizerMenu(i, this.f_58857_, this.f_58858_, inventory, player);
    }

    protected Object getSound() {
        return new ConditionalSoundInstance((SoundEvent)TExpSounds.SOUND_MACHINE_PULVERIZER.get(), SoundSource.AMBIENT, (BlockEntity)this, () -> !this.f_58859_ && this.isActive);
    }

    protected boolean validateInputs() {
        if (!this.cacheRecipe()) {
            return false;
        }
        return this.inputSlot.getCount() >= (Integer)this.itemInputCounts.get(0);
    }

    protected void resetAttributes() {
        super.resetAttributes();
        this.cyclicProcessingFeature = false;
    }

    protected void setAttributesFromAugment(CompoundTag augmentData) {
        super.setAttributesFromAugment(augmentData);
        this.cyclicProcessingFeature |= AugmentableHelper.getAttributeMod((CompoundTag)augmentData, (String)"CycProc") > 0.0f;
    }
}

