/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.crafting.CraftingHelper;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.type.IBlockType;
import xfacthd.framedblocks.common.crafting.FramingSawRecipe;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeAdditive;

public final class FramingSawRecipeSerializer
implements RecipeSerializer<FramingSawRecipe> {
    public FramingSawRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
        boolean disabled = GsonHelper.m_13855_((JsonObject)json, (String)"disabled", (boolean)false);
        int material = GsonHelper.m_13927_((JsonObject)json, (String)"material");
        if (material <= 0) {
            throw new JsonSyntaxException("Value of 'material' must be greater than 0");
        }
        ArrayList<FramingSawRecipeAdditive> additives = new ArrayList<FramingSawRecipeAdditive>();
        if (json.has("additives")) {
            JsonArray additiveArr = GsonHelper.m_13933_((JsonObject)json, (String)"additives");
            if (additiveArr.size() > 3) {
                throw new JsonSyntaxException("More than 3 additives are not supported");
            }
            for (JsonElement additiveElem : additiveArr) {
                JsonObject additiveObj = additiveElem.getAsJsonObject();
                Ingredient additive = Ingredient.m_43917_((JsonElement)additiveObj.get("ingredient"));
                if (!additive.isSimple()) {
                    throw new JsonSyntaxException("Custom ingredients are not supported");
                }
                int additiveCount = GsonHelper.m_13927_((JsonObject)additiveObj, (String)"count");
                if (additiveCount <= 0) {
                    throw new JsonSyntaxException("Value of 'additive_count' must be greater than 0");
                }
                additives.add(new FramingSawRecipeAdditive(additive, additiveCount));
            }
        }
        JsonObject resultObj = GsonHelper.m_13930_((JsonObject)json, (String)"result");
        ItemStack result = CraftingHelper.getItemStack((JsonObject)resultObj, (boolean)false);
        IBlockType resultType = FramingSawRecipeSerializer.findResultType(result);
        return new FramingSawRecipe(recipeId, material, additives, result, resultType, disabled);
    }

    public FramingSawRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        int material = buffer.readInt();
        int count = buffer.readInt();
        ArrayList<FramingSawRecipeAdditive> additives = new ArrayList<FramingSawRecipeAdditive>(count);
        for (int i = 0; i < count; ++i) {
            Ingredient additive = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int additiveCount = buffer.readInt();
            additives.add(new FramingSawRecipeAdditive(additive, additiveCount));
        }
        ItemStack result = buffer.m_130267_();
        IBlockType resultType = FramingSawRecipeSerializer.findResultType(result);
        boolean disabled = buffer.readBoolean();
        return new FramingSawRecipe(recipeId, material, additives, result, resultType, disabled);
    }

    public void toNetwork(FriendlyByteBuf buffer, FramingSawRecipe recipe) {
        buffer.writeInt(recipe.getMaterialAmount());
        List<FramingSawRecipeAdditive> additives = recipe.getAdditives();
        buffer.writeInt(additives.size());
        for (FramingSawRecipeAdditive additive : additives) {
            additive.ingredient().m_43923_(buffer);
            buffer.writeInt(additive.count());
        }
        buffer.m_130055_(recipe.getResult());
        buffer.writeBoolean(recipe.isDisabled());
    }

    private static IBlockType findResultType(ItemStack result) {
        Item item = result.m_41720_();
        if (!(item instanceof BlockItem)) {
            throw new JsonSyntaxException("Result items must be BlockItems");
        }
        BlockItem item2 = (BlockItem)item;
        Block block = item2.m_40614_();
        if (!(block instanceof IFramedBlock)) {
            throw new JsonSyntaxException("Block of result items must be IFramedBlocks");
        }
        IFramedBlock block2 = (IFramedBlock)block;
        return block2.getBlockType();
    }
}

