/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.door;

import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.extensions.common.IClientBlockExtensions;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.block.render.FramedBlockRenderProperties;
import xfacthd.framedblocks.common.data.BlockType;

public class FramedDoorBlock
extends DoorBlock
implements IFramedBlock {
    private final BlockType type;

    private FramedDoorBlock(BlockType type, BlockBehaviour.Properties props, BlockSetType blockSet) {
        super(props, blockSet);
        this.type = type;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FramedProperties.SOLID, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FramedProperties.GLOWING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FramedProperties.PROPAGATES_SKYLIGHT, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FramedProperties.SOLID, FramedProperties.GLOWING, FramedProperties.PROPAGATES_SKYLIGHT});
    }

    public final InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        InteractionResult result = this.handleUse(state, level, pos, player, hand, hit);
        return result.m_19077_() ? result : super.m_6227_(state, level, pos, player, hand, hit);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        this.tryApplyCamoImmediately(level, pos, placer, stack);
        this.tryApplyCamoImmediately(level, pos.m_7494_(), placer, stack);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        BlockState newState = super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
        if (newState == state) {
            this.updateCulling((LevelReader)level, currentPos);
        }
        return newState;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, level, pos, block, fromPos, isMoving);
        this.updateCulling((LevelReader)level, pos);
    }

    public boolean m_7923_(BlockState state) {
        return this.useCamoOcclusionShapeForLightOcclusion(state);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getCamoOcclusionShape(state, level, pos, null);
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return this.getCamoVisualShape(state, level, pos, ctx);
    }

    public float m_7749_(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getCamoShadeBrightness(state, level, pos, super.m_7749_(state, level, pos));
    }

    public boolean m_7420_(BlockState state, BlockGetter level, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)FramedProperties.PROPAGATES_SKYLIGHT);
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        return this.getCamoDrops(super.m_49635_(state, builder), builder);
    }

    @Override
    public BlockType getBlockType() {
        return this.type;
    }

    public void initializeClient(Consumer<IClientBlockExtensions> consumer) {
        consumer.accept(FramedBlockRenderProperties.INSTANCE);
    }

    public static FramedDoorBlock wood() {
        return new FramedDoorBlock(BlockType.FRAMED_DOOR, IFramedBlock.createProperties(BlockType.FRAMED_DOOR), BlockSetType.f_271198_);
    }

    public static FramedDoorBlock iron() {
        return new FramedDoorBlock(BlockType.FRAMED_IRON_DOOR, IFramedBlock.createProperties(BlockType.FRAMED_IRON_DOOR).m_60999_(), BlockSetType.f_271132_);
    }
}

