/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.cube;

import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.ModelData;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.blockentity.special.FramedCollapsibleBlockEntity;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.NullableDirection;

public class FramedCollapsibleBlockModel
extends FramedBlockModel {
    public static final ResourceLocation ALT_BASE_MODEL_LOC = Utils.rl("block/framed_collapsible_block_alt");
    private static final float MIN_DEPTH = 0.001f;
    private static BakedModel altBaseModel = null;
    private final Direction collapsedFace;
    private final boolean rotSplitLine;

    public FramedCollapsibleBlockModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.collapsedFace = ((NullableDirection)((Object)state.m_61143_(PropertyHolder.NULLABLE_FACE))).toDirection();
        this.rotSplitLine = (Boolean)state.m_61143_((Property)PropertyHolder.ROTATE_SPLIT_LINE);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad, ModelData data) {
        Direction quadDir = quad.m_111306_();
        if (this.collapsedFace == null || quadDir == this.collapsedFace.m_122424_()) {
            quadMap.get(quadDir).add(quad);
            return;
        }
        Integer offsets = (Integer)data.get(FramedCollapsibleBlockEntity.OFFSETS);
        float[] vertexPos = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        if (offsets != null && offsets != 0) {
            byte[] relOff = FramedCollapsibleBlockEntity.unpackOffsets(offsets);
            boolean allSame = relOff[0] == relOff[1] && relOff[0] == relOff[2] && relOff[0] == relOff[3];
            for (int i = 0; i < 4; ++i) {
                vertexPos[i] = Math.max(1.0f - (float)relOff[i] / 16.0f, allSame ? 0.001f : 0.0f);
            }
        }
        if (quadDir == this.collapsedFace) {
            float diff02 = Math.abs(vertexPos[0] - vertexPos[2]);
            float diff13 = Math.abs(vertexPos[1] - vertexPos[3]);
            boolean rotate = diff13 > diff02 != this.rotSplitLine;
            float[] vertexPosTwo = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
            System.arraycopy(vertexPos, 0, vertexPosTwo, 0, vertexPos.length);
            if (rotate) {
                vertexPos[2] = vertexPos[1] + vertexPos[3] - vertexPos[0];
                vertexPosTwo[0] = vertexPosTwo[1] + vertexPosTwo[3] - vertexPosTwo[2];
            } else {
                vertexPos[3] = vertexPos[0] + vertexPos[2] - vertexPos[1];
                vertexPosTwo[1] = vertexPosTwo[0] + vertexPosTwo[2] - vertexPosTwo[3];
            }
            if (Utils.isY(this.collapsedFace)) {
                float left = (rotate ^= this.collapsedFace == Direction.DOWN) ? 0.0f : 1.0f;
                float right = rotate ? 1.0f : 0.0f;
                QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(Direction.EAST, left, right)).apply(Modifiers.setPosition(vertexPos)).export(quadMap.get(null));
                QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(Direction.WEST, left, right)).apply(Modifiers.setPosition(vertexPosTwo)).export(quadMap.get(null));
            } else {
                QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(quadDir.m_122428_(), rotate ? 1.0f : 0.0f, rotate ? 0.0f : 1.0f)).apply(Modifiers.setPosition(vertexPos)).export(quadMap.get(null));
                QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(quadDir.m_122427_(), rotate ? 0.0f : 1.0f, rotate ? 1.0f : 0.0f)).apply(Modifiers.setPosition(vertexPosTwo)).export(quadMap.get(null));
            }
        } else if (Utils.isY(this.collapsedFace)) {
            boolean top = this.collapsedFace == Direction.UP;
            int idxOne = this.getYCollapsedIndexOffset(quadDir);
            int idxTwo = Math.floorMod(idxOne + (top ? 1 : -1), 4);
            float posOne = vertexPos[idxOne];
            float posTwo = vertexPos[idxTwo];
            QuadModifier.geometry(quad).apply(Modifiers.cutSideUpDown(!top, posOne, posTwo)).export(quadMap.get(quadDir));
        } else if (Utils.isY(quadDir)) {
            boolean top = quad.m_111306_() == Direction.UP;
            float posOne = vertexPos[top ? 0 : 1];
            float posTwo = vertexPos[top ? 3 : 2];
            QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(this.collapsedFace, posOne, posTwo)).export(quadMap.get(quadDir));
        } else {
            boolean right = this.collapsedFace == quadDir.m_122427_();
            float posTop = vertexPos[right ? 3 : 0];
            float posBot = vertexPos[right ? 2 : 1];
            QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(this.collapsedFace, posTop, posBot)).export(quadMap.get(quadDir));
        }
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
    }

    @Override
    protected boolean useBaseModel() {
        return true;
    }

    @Override
    protected BakedModel getCamoModel(BlockState camoState, boolean useBaseModel, boolean useAltModel) {
        if (useBaseModel && useAltModel) {
            return altBaseModel;
        }
        return super.getCamoModel(camoState, useBaseModel, useAltModel);
    }

    @Override
    protected FramedBlockModel.QuadCacheKey makeCacheKey(BlockState state, Object ctCtx, ModelData data) {
        Integer packedOffsets = (Integer)data.get(FramedCollapsibleBlockEntity.OFFSETS);
        return new CollapsibleBlockQuadCacheKey(state, ctCtx, packedOffsets);
    }

    private int getYCollapsedIndexOffset(Direction quadFace) {
        boolean top = this.collapsedFace == Direction.UP;
        return switch (quadFace) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.NORTH -> {
                if (top) {
                    yield 3;
                }
                yield 2;
            }
            case Direction.EAST -> {
                if (top) {
                    yield 2;
                }
                yield 3;
            }
            case Direction.SOUTH -> {
                if (top) {
                    yield 1;
                }
                yield 0;
            }
            case Direction.WEST -> {
                if (top) {
                    yield 0;
                }
                yield 1;
            }
            case Direction.DOWN, Direction.UP -> throw new IllegalArgumentException("Invalid facing for y face collapse!");
        };
    }

    public static void captureAltBaseModel(Map<ResourceLocation, BakedModel> models) {
        altBaseModel = models.get(ALT_BASE_MODEL_LOC);
    }

    private record CollapsibleBlockQuadCacheKey(BlockState state, Object ctCtx, Integer packedOffsets) implements FramedBlockModel.QuadCacheKey
    {
    }
}

