/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.modules.items;

import codechicken.enderstorage.api.Frequency;
import codechicken.enderstorage.config.EnderStorageConfig;
import codechicken.enderstorage.tile.TileEnderChest;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.data.NoData;
import com.brandon3055.draconicevolution.api.modules.items.ModuleItem;
import com.brandon3055.draconicevolution.integration.ModHelper;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class EnderCollectionModuleItem
extends ModuleItem<NoData> {
    public EnderCollectionModuleItem(Supplier<Module<?>> moduleSupplier) {
        super(moduleSupplier);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Level level = context.m_43725_();
        if (ModHelper.ENDERSTORAGE.isPresent()) {
            return this.bindFrequency(stack, level, context);
        }
        return InteractionResult.PASS;
    }

    private InteractionResult bindFrequency(ItemStack stack, Level level, UseOnContext context) {
        BlockEntity tile = level.m_7702_(context.m_8083_());
        if (tile instanceof TileEnderChest) {
            TileEnderChest chest = (TileEnderChest)tile;
            if (context.m_43723_().m_6047_()) {
                if (level.m_5776_()) {
                    return InteractionResult.SUCCESS;
                }
                Frequency frequency = chest.getFrequency().copy();
                if (EnderStorageConfig.anarchyMode && (frequency.owner == null || !frequency.owner.equals(context.m_43723_().m_20148_()))) {
                    frequency.setOwner(null);
                }
                stack.m_41784_().m_128365_("frequency", (Tag)frequency.writeToNBT(new CompoundTag()));
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (level.m_5776_()) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (player.m_6047_() && ModHelper.ENDERSTORAGE.isPresent() && stack.m_41782_()) {
            stack.m_41784_().m_128473_("frequency");
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        if (ModHelper.ENDERSTORAGE.isPresent() && stack.m_41782_()) {
            this.addEnderStorageInfo(stack, tooltip);
        }
        tooltip.add((Component)Component.m_237115_((String)"module.draconicevolution.ender_storage.about").m_130940_(ChatFormatting.DARK_GRAY));
        tooltip.add((Component)Component.m_237115_((String)"module.draconicevolution.ender_storage.about_compat").m_130940_(ChatFormatting.DARK_GRAY));
        tooltip.add((Component)Component.m_237115_((String)"module.draconicevolution.ender_storage.about_compat2").m_130940_(ChatFormatting.DARK_GRAY));
    }

    private void addEnderStorageInfo(ItemStack stack, List<Component> tooltip) {
        Component freq;
        MutableComponent mutable;
        CompoundTag tag = stack.m_41784_().m_128469_("frequency");
        if (tag.m_128456_()) {
            return;
        }
        Frequency frequency = new Frequency(tag);
        if (frequency.hasOwner()) {
            Component name = frequency.getOwnerName();
            if (name instanceof MutableComponent) {
                mutable = (MutableComponent)name;
                mutable.m_130940_(ChatFormatting.DARK_GREEN);
            }
            tooltip.add((Component)Component.m_237115_((String)"module.draconicevolution.ender_storage.owner").m_130940_(ChatFormatting.GRAY).m_130946_(": ").m_7220_(name));
        }
        if ((freq = frequency.getTooltip()) instanceof MutableComponent) {
            mutable = (MutableComponent)freq;
            mutable.m_130940_(ChatFormatting.DARK_GREEN);
        }
        tooltip.add((Component)Component.m_237115_((String)"module.draconicevolution.ender_storage.frequency").m_130940_(ChatFormatting.GRAY).m_130946_(": ").m_7220_(freq));
    }
}

