/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.mixin;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import quek.undergarden.registry.UGDimensions;
import quek.undergarden.registry.UGFluids;
import quek.undergarden.registry.UGParticleTypes;

@Mixin(value={PointedDripstoneBlock.class})
public abstract class PointedDripstoneMixin {
    @Shadow
    @Nullable
    private static BlockPos m_154130_(BlockState state, LevelAccessor accessor, BlockPos pos, int maxIterations, boolean isMergedTip) {
        return null;
    }

    @Shadow
    @Nullable
    private static BlockPos m_154076_(Level level, BlockPos pos, Fluid fluid) {
        return null;
    }

    @Shadow
    private static Optional<PointedDripstoneBlock.FluidInfo> m_154181_(Level level, BlockPos pos, BlockState state) {
        return Optional.empty();
    }

    @Inject(method={"getDripFluid"}, at={@At(value="RETURN", ordinal=0, shift=At.Shift.BEFORE)}, cancellable=true)
    private static void undergarden$dripVirulentInUndergarden(Level level, Fluid fluid, CallbackInfoReturnable<Fluid> cir) {
        if (level.m_46472_().equals(UGDimensions.UNDERGARDEN_LEVEL)) {
            cir.setReturnValue((Object)((Fluid)UGFluids.VIRULENT_MIX_SOURCE.get()));
        }
    }

    @Inject(method={"canFillCauldron"}, at={@At(value="HEAD")}, cancellable=true)
    private static void undergarden$allowVirulentDrippingIntoCauldron(Fluid fluid, CallbackInfoReturnable<Boolean> cir) {
        if (fluid == UGFluids.VIRULENT_MIX_SOURCE.get()) {
            cir.setReturnValue((Object)true);
        }
    }

    @ModifyVariable(at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;addParticle(Lnet/minecraft/core/particles/ParticleOptions;DDDDDD)V", shift=At.Shift.BY, by=-10), index=14, method={"spawnDripParticle(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/material/Fluid;)V"})
    private static ParticleOptions undergarden$spawnProperDripParticle(ParticleOptions particle, Level level, BlockPos pos, BlockState state, Fluid fluid) {
        return fluid.m_6212_((Fluid)UGFluids.VIRULENT_MIX_SOURCE.get()) ? (ParticleOptions)UGParticleTypes.DRIPPING_VIRULENT.get() : particle;
    }

    @Inject(method={"maybeTransferFluid"}, at={@At(value="INVOKE", target="Ljava/util/Optional;isEmpty()Z", shift=At.Shift.BEFORE)})
    private static void undergarden$dripVirulentMixIntoCauldron(BlockState state, ServerLevel level, BlockPos pos, float chance, CallbackInfo ci) {
        if (PointedDripstoneMixin.m_154181_((Level)level, pos, state).isPresent()) {
            BlockPos blockpos1;
            BlockPos blockpos;
            Fluid fluid = PointedDripstoneMixin.m_154181_((Level)level, pos, state).get().f_221893_();
            float f = 0.05859375f;
            if (fluid.m_6212_((Fluid)UGFluids.VIRULENT_MIX_SOURCE.get()) && !(chance >= f) && (blockpos = PointedDripstoneMixin.m_154130_(state, (LevelAccessor)level, pos, 11, false)) != null && (blockpos1 = PointedDripstoneMixin.m_154076_((Level)level, blockpos, fluid)) != null) {
                level.m_46796_(1504, blockpos, 0);
                int i = blockpos.m_123342_() - blockpos1.m_123342_();
                int j = 50 + i;
                BlockState blockstate = level.m_8055_(blockpos1);
                level.m_186460_(blockpos1, blockstate.m_60734_(), j);
            }
        }
    }
}

