/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.item;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.event.entity.living.EnderManAngerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import quek.undergarden.registry.UGBlocks;

@Mod.EventBusSubscriber(modid="undergarden", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CarvedGloomgourdItem
extends BlockItem {
    public CarvedGloomgourdItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return EquipmentSlot.HEAD;
    }

    @SubscribeEvent
    public static void lookedAtEnderman(EnderManAngerEvent event) {
        if (!event.isCanceled() && !event.getPlayer().m_7500_() && CarvedGloomgourdItem.isPlayerLookingAtEnderman(event.getPlayer(), event.getEntity()) && !event.getEntity().m_21674_((LivingEntity)event.getPlayer()) && event.getPlayer().m_6844_(EquipmentSlot.HEAD).m_150930_(((Block)UGBlocks.CARVED_GLOOMGOURD.get()).m_5456_())) {
            event.getEntity().m_9236_().m_6443_(EnderMan.class, event.getEntity().m_20191_().m_82400_(64.0), enderMan -> enderMan.m_142582_((Entity)event.getPlayer())).forEach(enderMan -> enderMan.m_6710_((LivingEntity)event.getPlayer()));
        }
    }

    private static boolean isPlayerLookingAtEnderman(Player player, EnderMan enderMan) {
        Vec3 vec3 = player.m_20252_(1.0f).m_82541_();
        Vec3 vec31 = new Vec3(enderMan.m_20185_() - player.m_20185_(), enderMan.m_20188_() - player.m_20188_(), enderMan.m_20189_() - player.m_20189_());
        double d0 = vec31.m_82553_();
        double d1 = vec3.m_82526_(vec31 = vec31.m_82541_());
        return d1 > 1.0 - 0.025 / d0 && player.m_142582_((Entity)enderMan);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public void renderHelmetOverlay(ItemStack stack, Player player, int width, int height, float partialTicks) {
                ResourceLocation overlay = new ResourceLocation("undergarden", "textures/gloomgourd_overlay.png");
                RenderSystem.disableDepthTest();
                RenderSystem.depthMask((boolean)false);
                RenderSystem.defaultBlendFunc();
                RenderSystem.setShader(GameRenderer::m_172817_);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)overlay);
                Minecraft.m_91087_().m_91097_().m_174784_(overlay);
                Tesselator tessellator = Tesselator.m_85913_();
                BufferBuilder bufferbuilder = tessellator.m_85915_();
                bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                double scaledWidth = Minecraft.m_91087_().m_91268_().m_85445_();
                double scaledHeight = Minecraft.m_91087_().m_91268_().m_85446_();
                bufferbuilder.m_5483_(0.0, scaledHeight, -90.0).m_7421_(0.0f, 1.0f).m_5752_();
                bufferbuilder.m_5483_(scaledWidth, scaledHeight, -90.0).m_7421_(1.0f, 1.0f).m_5752_();
                bufferbuilder.m_5483_(scaledWidth, 0.0, -90.0).m_7421_(1.0f, 0.0f).m_5752_();
                bufferbuilder.m_5483_(0.0, 0.0, -90.0).m_7421_(0.0f, 0.0f).m_5752_();
                tessellator.m_85914_();
                RenderSystem.depthMask((boolean)true);
                RenderSystem.enableDepthTest();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        });
    }
}

