/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.structures;

import java.util.Optional;
import java.util.Random;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.povstalec.sgjourney.common.config.CommonGenerationConfig;
import net.povstalec.sgjourney.common.structures.SGJourneyStructure;

public abstract class StargateStructure
extends SGJourneyStructure {
    private static Optional<Long> currentSeed = Optional.empty();
    private static Optional<Integer> x = Optional.empty();
    private static Optional<Integer> z = Optional.empty();

    public StargateStructure(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int size, HeightProvider startHeight, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter) {
        super(config, startPool, startJigsawName, size, startHeight, projectStartToHeightmap, maxDistanceFromCenter);
    }

    private static final void checkSeed(long seed) {
        if (currentSeed.isEmpty() || currentSeed.isPresent() && currentSeed.get() != seed) {
            currentSeed = Optional.of(seed);
            x = Optional.empty();
            z = Optional.empty();
        }
    }

    public static final int getX(long seed) {
        StargateStructure.checkSeed(seed);
        if (x.isEmpty()) {
            Random random = new Random(seed + 2L);
            int xOffset = (Integer)CommonGenerationConfig.stargate_generation_center_x_chunk_offset.get();
            int xBound = (Integer)CommonGenerationConfig.stargate_generation_x_bound.get();
            int chunkX = xBound <= 0 ? xOffset : xOffset + random.nextInt(-xBound, xBound + 1);
            x = Optional.of(chunkX);
        }
        return x.get();
    }

    public static final int getZ(long seed) {
        StargateStructure.checkSeed(seed);
        if (z.isEmpty()) {
            Random random = new Random(seed + 3L);
            int zOffset = (Integer)CommonGenerationConfig.stargate_generation_center_z_chunk_offset.get();
            int zBound = (Integer)CommonGenerationConfig.stargate_generation_z_bound.get();
            int chunkZ = zBound <= 0 ? zOffset : zOffset + random.nextInt(-zBound, zBound + 1);
            z = Optional.of(chunkZ);
        }
        return z.get();
    }

    @Override
    protected boolean extraSpawningChecks(Structure.GenerationContext context) {
        ChunkPos chunkpos = context.f_226628_();
        long seed = context.f_226627_();
        return chunkpos.f_45578_ == StargateStructure.getX(seed) && chunkpos.f_45579_ == StargateStructure.getZ(seed);
    }
}

