/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client.render.block_entity;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.ModelData;
import net.povstalec.sgjourney.client.models.IrisModel;
import net.povstalec.sgjourney.client.models.ShieldModel;
import net.povstalec.sgjourney.client.models.WormholeModel;
import net.povstalec.sgjourney.client.resourcepack.stargate_variant.ClientStargateVariant;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.blockstates.Orientation;
import net.povstalec.sgjourney.common.blockstates.StargatePart;

public abstract class AbstractStargateRenderer<StargateEntity extends AbstractStargateEntity, Variant extends ClientStargateVariant>
implements BlockEntityRenderer<StargateEntity> {
    protected final WormholeModel wormholeModel;
    protected final ShieldModel shieldModel;
    protected final IrisModel irisModel;
    private final RandomSource randomsource = RandomSource.m_216327_();

    public AbstractStargateRenderer(BlockEntityRendererProvider.Context context, float maxDefaultDistortion, boolean renderWhenOpen, float maxOpenIrisDegrees) {
        this.shieldModel = new ShieldModel();
        this.irisModel = new IrisModel(renderWhenOpen, maxOpenIrisDegrees);
        this.wormholeModel = new WormholeModel(maxDefaultDistortion);
    }

    public int m_142163_() {
        return 128;
    }

    protected abstract Variant getClientVariant(StargateEntity var1);

    protected void renderWormhole(AbstractStargateEntity stargate, Variant stargateVariant, PoseStack stack, MultiBufferSource source, int combinedLight, int combinedOverlay) {
        if (stargate.isConnected()) {
            this.wormholeModel.renderWormhole(stargate, stack, source, ((ClientStargateVariant)stargateVariant).getWormhole(), combinedLight, combinedOverlay);
        }
    }

    protected void renderCover(AbstractStargateEntity stargate, PoseStack stack, MultiBufferSource source, int combinedLight, int combinedOverlay) {
        for (Map.Entry<StargatePart, BlockState> entry : stargate.blockCover.blockStates.entrySet()) {
            this.renderCoverBlock(stargate, entry.getValue(), entry.getKey(), stack, source, combinedOverlay);
        }
    }

    protected void renderCoverBlock(AbstractStargateEntity stargate, BlockState state, StargatePart part, PoseStack stack, MultiBufferSource source, int combinedOverlay) {
        Level level = stargate.m_58904_();
        Direction direction = stargate.getDirection();
        Orientation orientation = stargate.getOrientation();
        if (direction != null && orientation != null) {
            Vec3 relativeBlockPos = part.getRelativeRingPos(stargate.m_58899_(), direction, orientation);
            BlockPos absolutePos = part.getRingPos(stargate.m_58899_(), stargate.getDirection(), stargate.getOrientation());
            stack.m_85836_();
            stack.m_85837_(relativeBlockPos.m_7096_(), relativeBlockPos.m_7098_(), relativeBlockPos.m_7094_());
            BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
            BakedModel model = dispatcher.m_110910_(state);
            for (RenderType renderType : model.getRenderTypes(state, this.randomsource, ModelData.EMPTY)) {
                dispatcher.renderBatched(state, absolutePos, (BlockAndTintGetter)level, stack, source.m_6299_(renderType), true, this.randomsource, model.getModelData((BlockAndTintGetter)level, absolutePos, state, ModelData.EMPTY), null);
            }
            stack.m_85849_();
        }
    }

    protected boolean canSink(AbstractStargateEntity stargate) {
        return stargate.blockCover.canSinkGate;
    }
}

