/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.mjoellnir;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import javax.annotation.Nonnull;
import mythicbotany.config.MythicConfig;
import mythicbotany.mjoellnir.BlockMjoellnir;
import mythicbotany.mjoellnir.Mjoellnir;
import mythicbotany.register.ModEnchantments;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class ItemMjoellnir
extends BlockItem {
    public ItemMjoellnir(Block blockIn, Item.Properties properties) {
        super(blockIn, properties);
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level level, @Nonnull Player player, @Nonnull InteractionHand hand) {
        if (!player.m_6144_()) {
            this.throwHammer(level, player, hand);
            if (MythicConfig.mjoellnir.ranged_cooldown > 0) {
                player.m_36335_().m_41524_((Item)this, MythicConfig.mjoellnir.ranged_cooldown);
            }
            return InteractionResultHolder.m_19092_((Object)player.m_21120_(hand), (boolean)level.f_46443_);
        }
        return super.m_7203_(level, player, hand);
    }

    @Nonnull
    public InteractionResult m_6225_(@Nonnull UseOnContext context) {
        if (context.m_43723_() != null && context.m_43723_().m_6144_()) {
            return super.m_6225_(context);
        }
        return InteractionResult.PASS;
    }

    protected boolean m_7429_(BlockPlaceContext context, @Nonnull BlockState state) {
        return BlockMjoellnir.placeInWorld(context.m_43722_(), context.m_43725_(), context.m_8083_());
    }

    public void m_6883_(@Nonnull ItemStack stack, @Nonnull Level level, @Nonnull Entity entity, int itemSlot, boolean isSelected) {
        Player player;
        if (!level.f_46443_ && entity instanceof Player && !BlockMjoellnir.canHold(player = (Player)entity)) {
            BlockMjoellnir.putInWorld(stack.m_41777_(), level, player.m_20183_());
            stack.m_41774_(stack.m_41613_());
            player.m_213846_((Component)Component.m_237115_((String)"message.mythicbotany.mjoellnir_heavy_drop").m_130940_(ChatFormatting.GRAY));
        }
    }

    private void throwHammer(Level level, Player player, InteractionHand hand) {
        if (!level.f_46443_) {
            ItemStack hammer = player.m_21120_(hand).m_41777_();
            player.m_21008_(hand, ItemStack.f_41583_);
            Mjoellnir projectile = new Mjoellnir(level);
            projectile.m_6034_(player.m_20185_(), player.m_20188_(), player.m_20189_());
            projectile.setStack(hammer);
            projectile.setThrower(player);
            projectile.setThrowPos(player.m_20182_());
            projectile.setHotBarSlot(BlockMjoellnir.getHotbarSlot(player, hand));
            projectile.m_20256_(player.m_20154_().m_82542_(1.2, 1.2, 1.2));
            level.m_7967_((Entity)projectile);
        }
    }

    public int getEntityLifespan(ItemStack itemStack, Level level) {
        return Integer.MAX_VALUE;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return (enchantment.f_44672_ == EnchantmentCategory.WEAPON || enchantment.f_44672_ == ModEnchantments.MJOELLNIR_ENCHANTS || enchantment == Enchantments.f_44988_ || enchantment == Enchantments.f_44989_ || enchantment == Enchantments.f_44990_ || enchantment == Enchantments.f_44955_) && enchantment != Enchantments.f_44983_ && enchantment != Enchantments.f_44978_ && enchantment != Enchantments.f_44979_;
    }

    public int getEnchantmentValue(ItemStack stack) {
        return 1;
    }

    public boolean m_8120_(@Nonnull ItemStack stack) {
        return true;
    }

    @Nonnull
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot == EquipmentSlot.MAINHAND) {
            float dmgModifier = EnchantmentHelper.m_44833_((ItemStack)stack, (MobType)MobType.f_21640_);
            float speedModifier = MythicConfig.mjoellnir.attack_speed_multiplier * (float)stack.getEnchantmentLevel(ModEnchantments.hammerMobility);
            ImmutableMultimap.Builder attributeBuilder = ImmutableMultimap.builder();
            attributeBuilder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "mjoellnir_damage_modifier", (double)(MythicConfig.mjoellnir.base_damage_melee - 1.0f + (MythicConfig.mjoellnir.enchantment_multiplier - 1.0f) * dmgModifier), AttributeModifier.Operation.ADDITION));
            attributeBuilder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "mjoellnir_attack_speed_modifier", (double)(MythicConfig.mjoellnir.base_attack_speed + speedModifier), AttributeModifier.Operation.ADDITION));
            return attributeBuilder.build();
        }
        return super.getAttributeModifiers(slot, stack);
    }
}

