/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.data.model;

import com.enderio.EnderIO;
import com.enderio.core.data.model.EIOModel;
import com.enderio.machines.common.block.ProgressMachineBlock;
import com.enderio.machines.common.block.SolarPanelBlock;
import com.enderio.machines.common.blockentity.solar.SolarPanelTier;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.providers.RegistrateItemModelProvider;
import java.util.Locale;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.client.model.generators.loaders.CompositeModelBuilder;

public class MachineModelUtil {
    public static void machineBlock(DataGenContext<Block, ? extends Block> ctx, RegistrateBlockstateProvider prov) {
        String ns = ctx.getId().m_135827_();
        String path = ctx.getId().m_135815_();
        MachineModelUtil.machineBlock(ctx, prov, MachineModelUtil.wrapMachineModel(ctx, prov, new ResourceLocation(ns, "block/" + path)));
    }

    public static void progressMachineBlock(DataGenContext<Block, ? extends Block> ctx, RegistrateBlockstateProvider prov) {
        String ns = ctx.getId().m_135827_();
        String path = ctx.getId().m_135815_();
        ResourceLocation unpowered = new ResourceLocation(ns, "block/" + path);
        ResourceLocation powered = new ResourceLocation(ns, "block/" + path + "_active");
        ModelFile unpoweredModel = MachineModelUtil.wrapMachineModel(ctx, prov, unpowered);
        ModelFile poweredModel = MachineModelUtil.wrapMachineModel(ctx, prov, powered);
        MachineModelUtil.progressMachineBlock(ctx, prov, unpoweredModel, poweredModel);
    }

    public static void solarPanel(DataGenContext<Block, ? extends Block> ctx, RegistrateBlockstateProvider prov, SolarPanelTier tier) {
        String tierName = tier.name().toLowerCase(Locale.ROOT);
        BlockModelBuilder baseModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_base", EnderIO.loc("block/photovoltaic_cell_base"))).texture("panel", "block/" + tierName + "_top")).texture("side", "block/" + tierName + "_side");
        BlockModelBuilder sideModel = (BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_side", EnderIO.loc("block/photovoltaic_cell_side"))).texture("side", "block/" + tierName + "_side");
        BlockModelBuilder cornerModel = (BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_corner", EnderIO.loc("block/photovoltaic_cell_corner"))).texture("side", "block/" + tierName + "_side");
        MultiPartBlockStateBuilder builder = prov.getMultipartBuilder((Block)ctx.get());
        builder.part().modelFile((ModelFile)baseModel).addModel();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)sideModel).addModel()).condition((Property)SolarPanelBlock.NORTH, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)sideModel).rotationY(90).addModel()).condition((Property)SolarPanelBlock.EAST, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)sideModel).rotationY(180).addModel()).condition((Property)SolarPanelBlock.SOUTH, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)sideModel).rotationY(270).addModel()).condition((Property)SolarPanelBlock.WEST, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)cornerModel).addModel()).condition((Property)SolarPanelBlock.NORTH_EAST, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)cornerModel).rotationY(90).addModel()).condition((Property)SolarPanelBlock.SOUTH_EAST, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)cornerModel).rotationY(180).addModel()).condition((Property)SolarPanelBlock.SOUTH_WEST, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)cornerModel).rotationY(270).addModel()).condition((Property)SolarPanelBlock.NORTH_WEST, (Comparable[])new Boolean[]{true});
    }

    public static void solarPanel(DataGenContext<Item, ? extends Item> ctx, RegistrateItemModelProvider prov, SolarPanelTier tier) {
        String tierName = tier.name().toLowerCase(Locale.ROOT);
        ((ItemModelBuilder)((ItemModelBuilder)prov.withExistingParent(ctx.getName(), EnderIO.loc("item/photovoltaic_cell"))).texture("side", "block/" + tierName + "_side")).texture("panel", "block/" + tierName + "_top");
    }

    private static void machineBlock(DataGenContext<Block, ? extends Block> ctx, RegistrateBlockstateProvider prov, ModelFile model) {
        prov.getVariantBuilder((Block)ctx.get()).forAllStates(state -> ConfiguredModel.builder().modelFile(model).rotationY(((int)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() + 180) % 360).build());
    }

    private static void progressMachineBlock(DataGenContext<Block, ? extends Block> ctx, RegistrateBlockstateProvider prov, ModelFile unpowered, ModelFile powered) {
        prov.getVariantBuilder((Block)ctx.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((Boolean)state.m_61143_((Property)ProgressMachineBlock.POWERED) != false ? powered : unpowered).rotationY(((int)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() + 180) % 360).build());
    }

    private static ModelFile wrapMachineModel(DataGenContext<Block, ? extends Block> ctx, RegistrateBlockstateProvider prov, ResourceLocation model) {
        return ((CompositeModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(model.m_135815_() + "_combined", prov.mcLoc("block/block"))).texture("particle", ctx.getName().equals("enchanter") ? EnderIO.loc("block/dark_steel_pressure_plate") : new ResourceLocation(model.m_135827_(), "block/" + ctx.getName() + "_front"))).customLoader(CompositeModelBuilder::begin)).child("machine", (ModelBuilder)EIOModel.getExistingParent(prov.models(), model)).child("overlay", (ModelBuilder)EIOModel.getExistingParent(prov.models(), EnderIO.loc("block/io_overlay"))).end();
    }
}

