/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.dyenamics.common.cap;

import cy.jdkdigital.dyenamics.Dyenamics;
import cy.jdkdigital.dyenamics.common.cap.DyenamicSwagProvider;
import cy.jdkdigital.dyenamics.common.network.PacketHandler;
import cy.jdkdigital.dyenamics.common.network.SwagPacket;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.PacketDistributor;

public class DyenamicSwagImpl {

    public static class Provider
    implements ICapabilitySerializable<CompoundTag> {
        public static final ResourceLocation NAME = new ResourceLocation("dyenamics", "dyenamic_swag");
        private final DefaultImpl impl;
        private final LazyOptional<DyenamicSwagProvider> cap;

        public Provider(Entity entity) {
            this.impl = new DefaultImpl(entity);
            this.cap = LazyOptional.of(() -> this.impl);
        }

        public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
            if (capability == Dyenamics.DYENAMIC_SWAG) {
                return this.cap.cast();
            }
            return LazyOptional.empty();
        }

        public CompoundTag serializeNBT() {
            return this.impl.serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.impl.deserializeNBT(nbt);
        }
    }

    private static class DefaultImpl
    implements DyenamicSwagProvider {
        private final Entity entity;
        private int swag = -1;

        private DefaultImpl(Entity entity) {
            this.entity = entity;
        }

        @Override
        public int getSwagId() {
            return this.swag;
        }

        @Override
        public void sync(Entity entity) {
            PacketHandler.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), new SwagPacket(entity.m_19879_(), this.serializeNBT()));
        }

        @Override
        public void setSwag(int id) {
            this.swag = id;
            this.sync(this.entity);
        }

        @Override
        public void removeSwag() {
            this.swag = -1;
            this.sync(this.entity);
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("swag", this.swag);
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            this.swag = tag.m_128451_("swag");
        }
    }
}

