/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.dyenamics.client.util;

import cy.jdkdigital.dyenamics.Dyenamics;
import cy.jdkdigital.dyenamics.client.render.block.DyenamicBannerRenderer;
import cy.jdkdigital.dyenamics.client.render.block.DyenamicBedRenderer;
import cy.jdkdigital.dyenamics.client.render.block.DyenamicShulkerBoxBlockEntityRenderer;
import cy.jdkdigital.dyenamics.client.render.entity.DyenamicLlamaDecorLayer;
import cy.jdkdigital.dyenamics.client.render.entity.DyenamicSheepRenderer;
import cy.jdkdigital.dyenamics.core.init.BlockEntityInit;
import cy.jdkdigital.dyenamics.core.init.BlockInit;
import cy.jdkdigital.dyenamics.core.init.EntityInit;
import cy.jdkdigital.dyenamics.core.util.DyenamicDyeColor;
import net.minecraft.client.model.LlamaModel;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="dyenamics", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientSetupEvents {
    @SubscribeEvent
    public static void registerEntityLayers(EntityRenderersEvent.AddLayers event) {
        try {
            MobRenderer llamaRenderer = (MobRenderer)event.getRenderer(EntityType.f_20466_);
            llamaRenderer.m_115326_((RenderLayer)new DyenamicLlamaDecorLayer((RenderLayerParent<Llama, LlamaModel<Llama>>)llamaRenderer, event.getEntityModels()));
        }
        catch (Exception e) {
            Dyenamics.LOGGER.warn("Llamarenderer is not a Llamarenderer");
        }
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)BlockEntityInit.BED.get(), DyenamicBedRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)BlockEntityInit.SHULKER_BOX.get(), DyenamicShulkerBoxBlockEntityRenderer::new);
        event.registerEntityRenderer((EntityType)EntityInit.SHEEP.get(), DyenamicSheepRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)BlockEntityInit.BANNER.get(), DyenamicBannerRenderer::new);
    }

    @SubscribeEvent
    public static void clientSetup(FMLClientSetupEvent event) {
        for (DyenamicDyeColor color : DyenamicDyeColor.dyenamicValues()) {
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockInit.DYED_BLOCKS.get(color.m_7912_()).get("stained_glass").get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockInit.DYED_BLOCKS.get(color.m_7912_()).get("stained_glass_pane").get()), (RenderType)RenderType.m_110466_());
            Dyenamics.BED_MATERIAL_MAP.put(color.m_7912_(), new Material(Sheets.f_110736_, new ResourceLocation("dyenamics", "entity/bed/" + color.m_7912_())));
            Dyenamics.SHULKER_MATERIAL_MAP.put(color.m_7912_(), new Material(Sheets.f_110735_, new ResourceLocation("dyenamics", "entity/shulker/" + color.m_7912_())));
        }
    }
}

