/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.affix;

import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixInstance;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixRegistry;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixType;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.loot.RarityRegistry;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import dev.shadowsoffire.placebo.util.CachedObject;
import dev.shadowsoffire.placebo.util.StepFunction;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;

public class AffixHelper {
    public static final ResourceLocation AFFIX_CACHED_OBJECT = Apotheosis.loc("affixes");
    public static final String DISPLAY = "display";
    public static final String LORE = "Lore";
    public static final String AFFIX_DATA = "affix_data";
    public static final String AFFIXES = "affixes";
    public static final String RARITY = "rarity";
    public static final String NAME = "name";
    public static final String CATEGORY = "category";

    public static void applyAffix(ItemStack stack, AffixInstance affix) {
        HashMap<DynamicHolder<? extends Affix>, AffixInstance> affixes = new HashMap<DynamicHolder<? extends Affix>, AffixInstance>(AffixHelper.getAffixes(stack));
        affixes.put(affix.affix(), affix);
        AffixHelper.setAffixes(stack, affixes);
    }

    public static void setAffixes(ItemStack stack, Map<DynamicHolder<? extends Affix>, AffixInstance> affixes) {
        CompoundTag afxData = stack.m_41698_(AFFIX_DATA);
        CompoundTag affixesTag = new CompoundTag();
        for (AffixInstance inst : affixes.values()) {
            affixesTag.m_128350_(inst.affix().getId().toString(), inst.level());
        }
        afxData.m_128365_(AFFIXES, (Tag)affixesTag);
    }

    public static void setName(ItemStack stack, Component name) {
        CompoundTag afxData = stack.m_41698_(AFFIX_DATA);
        afxData.m_128359_(NAME, Component.Serializer.m_130703_((Component)name));
    }

    @Nullable
    public static Component getName(ItemStack stack) {
        if (!stack.m_41782_()) {
            return null;
        }
        CompoundTag afxData = stack.m_41737_(AFFIX_DATA);
        if (afxData == null) {
            return null;
        }
        return Component.Serializer.m_130701_((String)afxData.m_128461_(NAME));
    }

    public static Map<DynamicHolder<? extends Affix>, AffixInstance> getAffixes(ItemStack stack) {
        if (AffixRegistry.INSTANCE.getValues().isEmpty()) {
            return Collections.emptyMap();
        }
        return (Map)CachedObject.CachedObjectSource.getOrCreate((ItemStack)stack, (ResourceLocation)AFFIX_CACHED_OBJECT, AffixHelper::getAffixesImpl, (ToIntFunction)CachedObject.hashSubkey((String)AFFIX_DATA));
    }

    public static Map<DynamicHolder<? extends Affix>, AffixInstance> getAffixesImpl(ItemStack stack) {
        if (stack.m_41619_()) {
            return Collections.emptyMap();
        }
        HashMap<DynamicHolder, AffixInstance> map = new HashMap<DynamicHolder, AffixInstance>();
        CompoundTag afxData = stack.m_41737_(AFFIX_DATA);
        if (afxData != null && afxData.m_128441_(AFFIXES)) {
            CompoundTag affixes = afxData.m_128469_(AFFIXES);
            DynamicHolder<LootRarity> rarity = AffixHelper.getRarity(afxData);
            if (!rarity.isBound()) {
                rarity = RarityRegistry.getMinRarity();
            }
            LootCategory cat = LootCategory.forItem(stack);
            for (String key : affixes.m_128431_()) {
                DynamicHolder affix = AffixRegistry.INSTANCE.holder(new ResourceLocation(key));
                if (!affix.isBound() || !((Affix)affix.get()).canApplyTo(stack, cat, (LootRarity)rarity.get())) continue;
                float lvl = affixes.m_128457_(key);
                map.put(affix, new AffixInstance((DynamicHolder<? extends Affix>)affix, stack, rarity, lvl));
            }
        }
        return Collections.unmodifiableMap(map);
    }

    public static Stream<AffixInstance> streamAffixes(ItemStack stack) {
        return AffixHelper.getAffixes(stack).values().stream().filter(AffixInstance::isValid);
    }

    public static boolean hasAffixes(ItemStack stack) {
        return stack.m_41782_() && !stack.m_41783_().m_128469_(AFFIX_DATA).m_128469_(AFFIXES).m_128456_();
    }

    public static void setRarity(ItemStack stack, LootRarity rarity) {
        CompoundTag afxData = stack.m_41698_(AFFIX_DATA);
        afxData.m_128359_(RARITY, RarityRegistry.INSTANCE.getKey(rarity).toString());
    }

    public static void copyFrom(ItemStack stack, Entity entity) {
        if (stack.m_41782_() && stack.m_41737_(AFFIX_DATA) != null) {
            CompoundTag afxData = stack.m_41737_(AFFIX_DATA).m_6426_();
            afxData.m_128359_(CATEGORY, LootCategory.forItem(stack).getName());
            entity.getPersistentData().m_128365_(AFFIX_DATA, (Tag)afxData);
        }
    }

    @Nullable
    public static LootCategory getShooterCategory(Entity entity) {
        CompoundTag afxData = entity.getPersistentData().m_128469_(AFFIX_DATA);
        if (afxData != null && afxData.m_128441_(CATEGORY)) {
            return LootCategory.byId(afxData.m_128461_(CATEGORY));
        }
        return null;
    }

    public static Map<DynamicHolder<? extends Affix>, AffixInstance> getAffixes(AbstractArrow arrow) {
        HashMap<DynamicHolder<? extends Affix>, AffixInstance> map = new HashMap<DynamicHolder<? extends Affix>, AffixInstance>();
        CompoundTag afxData = arrow.getPersistentData().m_128469_(AFFIX_DATA);
        if (afxData != null && afxData.m_128441_(AFFIXES)) {
            CompoundTag affixes = afxData.m_128469_(AFFIXES);
            DynamicHolder<LootRarity> rarity = AffixHelper.getRarity(afxData);
            if (!rarity.isBound()) {
                rarity = RarityRegistry.getMinRarity();
            }
            for (String key : affixes.m_128431_()) {
                DynamicHolder affix = AffixRegistry.INSTANCE.holder(new ResourceLocation(key));
                if (!affix.isBound()) continue;
                float lvl = affixes.m_128457_(key);
                map.put((DynamicHolder<? extends Affix>)affix, new AffixInstance((DynamicHolder<? extends Affix>)affix, ItemStack.f_41583_, rarity, lvl));
            }
        }
        return map;
    }

    public static Stream<AffixInstance> streamAffixes(AbstractArrow arrow) {
        return AffixHelper.getAffixes(arrow).values().stream();
    }

    public static DynamicHolder<LootRarity> getRarity(ItemStack stack) {
        if (!stack.m_41782_()) {
            return RarityRegistry.INSTANCE.emptyHolder();
        }
        CompoundTag afxData = stack.m_41737_(AFFIX_DATA);
        return AffixHelper.getRarity(afxData);
    }

    public static DynamicHolder<LootRarity> getRarity(@Nullable CompoundTag afxData) {
        if (afxData != null) {
            try {
                return RarityRegistry.byLegacyId(afxData.m_128461_(RARITY));
            }
            catch (IllegalArgumentException e) {
                afxData.m_128473_(RARITY);
                return RarityRegistry.byLegacyId("empty");
            }
        }
        return RarityRegistry.INSTANCE.emptyHolder();
    }

    public static Collection<DynamicHolder<Affix>> byType(AffixType type) {
        return AffixRegistry.INSTANCE.getTypeMap().get((Object)type);
    }

    public static StepFunction step(float min, int steps, float step) {
        return new StepFunction(min, steps, step);
    }

    public static void addLore(ItemStack stack, Component lore) {
        CompoundTag display = stack.m_41698_(DISPLAY);
        ListTag tag = display.m_128437_(LORE, 8);
        tag.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)lore)));
        display.m_128365_(LORE, (Tag)tag);
    }
}

