/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.Rotations;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.decoration.ArmorStand;

public class ArmorStandRotation {
    public final Rotations head;
    public final Rotations body;
    public final Rotations leftArm;
    public final Rotations rightArm;
    public final Rotations leftLeg;
    public final Rotations rightLeg;

    public ArmorStandRotation(Rotations head, Rotations body, Rotations leftArm, Rotations rightArm, Rotations leftLeg, Rotations rightLeg) {
        this.head = head;
        this.body = body;
        this.leftArm = leftArm;
        this.rightArm = rightArm;
        this.leftLeg = leftLeg;
        this.rightLeg = rightLeg;
    }

    public static ArmorStandRotation defaultRotation() {
        return new ArmorStandRotation(ArmorStand.f_31529_, ArmorStand.f_31530_, ArmorStand.f_31531_, ArmorStand.f_31532_, ArmorStand.f_31533_, ArmorStand.f_31534_);
    }

    public static ArmorStandRotation create(float headX, float headY, float headZ, float bodyX, float bodyY, float bodyZ, float leftArmX, float leftArmY, float leftArmZ, float rightArmX, float rightArmY, float rightArmZ, float leftLegX, float leftLegY, float leftLegZ, float rightLegX, float rightLegY, float rightLegZ) {
        return new ArmorStandRotation(new Rotations(headX, headY, headZ), new Rotations(bodyX, bodyY, bodyZ), new Rotations(leftArmX, leftArmY, leftArmZ), new Rotations(rightArmX, rightArmY, rightArmZ), new Rotations(leftLegX, leftLegY, leftLegZ), new Rotations(rightLegX, rightLegY, rightLegZ));
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.head.m_123156_());
        buffer.writeFloat(this.head.m_123157_());
        buffer.writeFloat(this.head.m_123158_());
        buffer.writeFloat(this.body.m_123156_());
        buffer.writeFloat(this.body.m_123157_());
        buffer.writeFloat(this.body.m_123158_());
        buffer.writeFloat(this.leftArm.m_123156_());
        buffer.writeFloat(this.leftArm.m_123157_());
        buffer.writeFloat(this.leftArm.m_123158_());
        buffer.writeFloat(this.rightArm.m_123156_());
        buffer.writeFloat(this.rightArm.m_123157_());
        buffer.writeFloat(this.rightArm.m_123158_());
        buffer.writeFloat(this.leftLeg.m_123156_());
        buffer.writeFloat(this.leftLeg.m_123157_());
        buffer.writeFloat(this.leftLeg.m_123158_());
        buffer.writeFloat(this.rightLeg.m_123156_());
        buffer.writeFloat(this.rightLeg.m_123157_());
        buffer.writeFloat(this.rightLeg.m_123158_());
    }

    public JsonObject serialize() {
        JsonObject json = new JsonObject();
        json.add("head", (JsonElement)ArmorStandRotation.rot(this.head));
        json.add("body", (JsonElement)ArmorStandRotation.rot(this.body));
        json.add("left_arm", (JsonElement)ArmorStandRotation.rot(this.leftArm));
        json.add("right_arm", (JsonElement)ArmorStandRotation.rot(this.rightArm));
        json.add("left_leg", (JsonElement)ArmorStandRotation.rot(this.leftLeg));
        json.add("right_leg", (JsonElement)ArmorStandRotation.rot(this.rightLeg));
        return json;
    }

    private static JsonArray rot(Rotations rot) {
        JsonArray array = new JsonArray();
        array.add((Number)Float.valueOf(rot.m_123156_()));
        array.add((Number)Float.valueOf(rot.m_123157_()));
        array.add((Number)Float.valueOf(rot.m_123158_()));
        return array;
    }

    public void apply(ArmorStand entity) {
        entity.m_31597_(this.head);
        entity.m_31616_(this.body);
        entity.m_31623_(this.leftArm);
        entity.m_31628_(this.rightArm);
        entity.m_31639_(this.leftLeg);
        entity.m_31651_(this.rightLeg);
    }

    public static ArmorStandRotation read(FriendlyByteBuf buffer) {
        return new ArmorStandRotation(new Rotations(buffer.readFloat(), buffer.readFloat(), buffer.readFloat()), new Rotations(buffer.readFloat(), buffer.readFloat(), buffer.readFloat()), new Rotations(buffer.readFloat(), buffer.readFloat(), buffer.readFloat()), new Rotations(buffer.readFloat(), buffer.readFloat(), buffer.readFloat()), new Rotations(buffer.readFloat(), buffer.readFloat(), buffer.readFloat()), new Rotations(buffer.readFloat(), buffer.readFloat(), buffer.readFloat()));
    }

    public static ArmorStandRotation deserialize(JsonObject json) {
        return new ArmorStandRotation(ArmorStandRotation.rot(json, "head"), ArmorStandRotation.rot(json, "body"), ArmorStandRotation.rot(json, "left_arm"), ArmorStandRotation.rot(json, "right_arm"), ArmorStandRotation.rot(json, "left_leg"), ArmorStandRotation.rot(json, "right_leg"));
    }

    private static Rotations rot(JsonObject json, String key) {
        JsonArray array = json.getAsJsonArray(key);
        if (array.size() != 3) {
            throw new IllegalStateException("Invalid rotation: List must have a length of 3.");
        }
        return new Rotations(array.get(0).getAsFloat(), array.get(1).getAsFloat(), array.get(2).getAsFloat());
    }
}

