/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty;

import com.google.common.collect.Maps;
import java.util.Map;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;

public class ModNameCache {
    private static final Map<String, String> id2name = Maps.newHashMap();

    public static void init() {
        ModList.get().forEachModFile(modFile -> {
            for (IModInfo info : modFile.getModInfos()) {
                id2name.put(info.getModId(), info.getDisplayName());
                id2name.put(info.getModId().toLowerCase(), info.getDisplayName());
            }
        });
        id2name.put("minecraft", "Minecraft");
    }

    public static String getModName(Fluid fluid) {
        return ModNameCache.getModName(PneumaticCraftUtils.getRegistryName(fluid).orElseThrow().m_135827_());
    }

    public static String getModName(Item item) {
        return ModNameCache.getModName(PneumaticCraftUtils.getRegistryName(item).orElseThrow().m_135827_());
    }

    public static String getModName(Block block) {
        return ModNameCache.getModName(PneumaticCraftUtils.getRegistryName(block).orElseThrow().m_135827_());
    }

    public static String getModName(String modId) {
        return id2name.getOrDefault(modId, modId);
    }
}

