/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.Objects;
import java.util.regex.Pattern;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextField;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextFieldNumber;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.item.GPSToolItem;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketChangeGPSToolCoordinate;
import me.desht.pneumaticcraft.common.network.PacketTeleportCommand;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.variables.GlobalVariableHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;

public class GPSToolScreen
extends AbstractPneumaticCraftScreen {
    private static final int TEXTFIELD_WIDTH = 60;
    private static final Pattern VAR_PATTERN = Pattern.compile("^\\w*$", 2);
    protected final WidgetTextFieldNumber[] textFields = new WidgetTextFieldNumber[3];
    protected WidgetTextField variableField;
    protected WidgetButtonExtended varTypeButton;
    protected WidgetButtonExtended teleportButton;
    protected final InteractionHand hand;
    private final BlockPos oldGPSLoc;
    private String oldVarName;
    protected boolean playerGlobal;

    protected GPSToolScreen(Component title, InteractionHand hand, BlockPos gpsLoc, String oldVarName) {
        super(title);
        this.xSize = 183;
        this.ySize = 202;
        this.hand = hand;
        this.oldGPSLoc = gpsLoc;
        this.oldVarName = oldVarName;
    }

    public static void showGUI(ItemStack stack, InteractionHand handIn, BlockPos pos) {
        Minecraft.m_91087_().m_91152_((Screen)new GPSToolScreen(stack.m_41786_(), handIn, pos != null ? pos : BlockPos.f_121853_, GPSToolItem.getVariable(stack)));
    }

    @Override
    public void m_7856_() {
        int i;
        super.m_7856_();
        int[] oldText = new int[3];
        if (this.textFields[0] == null) {
            oldText[0] = this.oldGPSLoc.m_123341_();
            oldText[1] = this.oldGPSLoc.m_123342_();
            oldText[2] = this.oldGPSLoc.m_123343_();
        } else {
            for (int i2 = 0; i2 < 3; ++i2) {
                oldText[i2] = this.textFields[i2].getIntValue();
            }
        }
        int xMiddle = this.f_96543_ / 2;
        int yMiddle = this.f_96544_ / 2;
        for (i = 0; i < 3; ++i) {
            int min = i == 1 ? ClientUtils.getClientLevel().m_141937_() : Integer.MIN_VALUE;
            int max = i == 1 ? ClientUtils.getClientLevel().m_151558_() : Integer.MAX_VALUE;
            Objects.requireNonNull(this.f_96547_);
            this.textFields[i] = new WidgetTextFieldNumber(this.f_96547_, xMiddle - 30, yMiddle - 15 + i * 22, 60, 9 + 2).setValue(oldText[i]).setRange(min, max).setAdjustments(1.0, 10.0);
            this.m_142416_((GuiEventListener)this.textFields[i]);
        }
        for (i = 0; i < 3; ++i) {
            int idx = i;
            this.m_142416_((GuiEventListener)new WidgetButtonExtended(xMiddle - 52 - 30, yMiddle - 20 + i * 22, 25, 20, (Component)Component.m_237113_((String)"-10"), b -> this.updateTextField(idx, -10)));
            this.m_142416_((GuiEventListener)new WidgetButtonExtended(xMiddle - 25 - 30, yMiddle - 20 + i * 22, 22, 20, (Component)Component.m_237113_((String)"-1"), b -> this.updateTextField(idx, -1)));
            this.m_142416_((GuiEventListener)new WidgetButtonExtended(xMiddle + 3 + 30, yMiddle - 20 + i * 22, 22, 20, (Component)Component.m_237113_((String)"+1"), b -> this.updateTextField(idx, 1)));
            this.m_142416_((GuiEventListener)new WidgetButtonExtended(xMiddle + 27 + 30, yMiddle - 20 + i * 22, 25, 20, (Component)Component.m_237113_((String)"+10"), b -> this.updateTextField(idx, 10)));
        }
        if (this.variableField != null) {
            this.oldVarName = this.variableField.m_94155_();
        }
        Objects.requireNonNull(this.f_96547_);
        this.variableField = new WidgetTextField(this.f_96547_, xMiddle - 50, yMiddle + 60, 100, 9 + 1);
        this.playerGlobal = !this.oldVarName.startsWith("%");
        this.oldVarName = GlobalVariableHelper.stripVarPrefix(this.oldVarName);
        this.variableField.m_94153_(s -> VAR_PATTERN.matcher((CharSequence)s).matches());
        this.variableField.m_94144_(this.oldVarName);
        this.m_142416_((GuiEventListener)this.variableField);
        this.varTypeButton = new WidgetButtonExtended(this.variableField.m_252754_() - 13, yMiddle + 58, 12, 14, this.playerGlobal ? "#" : "%", b -> this.toggleVarType()).setTooltipKey("pneumaticcraft.gui.remote.varType.tooltip");
        this.m_142416_((GuiEventListener)this.varTypeButton);
        if (ClientUtils.getClientPlayer().m_20310_(2)) {
            BlockPos pos = this.getBlockPos();
            this.teleportButton = new WidgetButtonExtended(xMiddle - 50, this.variableField.m_252907_() + this.variableField.m_93694_() + 5, 100, 20, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.gps_tool.teleport", new Object[0]), p -> {
                NetworkHandler.sendToServer(new PacketTeleportCommand(this.getBlockPos()));
                if (!ClientUtils.hasShiftDown()) {
                    this.m_7379_();
                }
            }).setTooltipText((Component)Component.m_237113_((String)String.format("/tp %d %d %d", pos.m_123341_(), pos.m_123342_(), pos.m_123343_())).m_130940_(ChatFormatting.YELLOW));
            this.m_142416_((GuiEventListener)this.teleportButton);
        }
        MutableComponent mutableComponent = PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.coordinate.variable", new Object[0]).m_130946_(":");
        int n = this.variableField.m_252754_();
        int n2 = this.variableField.m_252907_();
        Objects.requireNonNull(this.f_96547_);
        this.addLabel((Component)mutableComponent, n, n2 - 9 - 2).setColor(0xFFFFFF);
    }

    protected BlockPos getBlockPos() {
        return new BlockPos(this.textFields[0].getIntValue(), this.textFields[1].getIntValue(), this.textFields[2].getIntValue());
    }

    protected void toggleVarType() {
        this.playerGlobal = !this.playerGlobal;
        this.varTypeButton.m_93666_((Component)Component.m_237113_((String)GlobalVariableHelper.getVarPrefix(this.playerGlobal)));
    }

    private void updateTextField(int idx, int amount) {
        this.textFields[idx].setValue(this.textFields[idx].getIntValue() + amount);
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        int xMiddle = this.f_96543_ / 2;
        int yMiddle = this.f_96544_ / 2;
        int stringX = xMiddle - 60 - 30;
        graphics.m_280653_(this.f_96547_, this.m_96636_(), xMiddle, yMiddle - 58, -1);
        Objects.requireNonNull(this.f_96547_);
        graphics.m_280056_(this.f_96547_, "X:", stringX, yMiddle - 10 - 9 / 2, -1, false);
        Objects.requireNonNull(this.f_96547_);
        graphics.m_280056_(this.f_96547_, "Y:", stringX, yMiddle + 4 + 9 / 2, -1, false);
        Objects.requireNonNull(this.f_96547_);
        graphics.m_280056_(this.f_96547_, "Z:", stringX, yMiddle + 34 - 9 / 2, -1, false);
    }

    public void m_7861_() {
        this.syncToServer();
        super.m_7861_();
    }

    protected void syncToServer() {
        String varName = GlobalVariableHelper.getPrefixedVar(GlobalVariableHelper.stripVarPrefix(this.variableField.m_94155_()), this.playerGlobal);
        NetworkHandler.sendToServer(new PacketChangeGPSToolCoordinate(this.getBlockPos(), this.hand, varName, this.getIndex()));
    }

    protected int getIndex() {
        return 0;
    }

    @Override
    protected ResourceLocation getTexture() {
        return null;
    }
}

